/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import zeus.generator.code.AgentModel;
import zeus.generator.code.GenerationPlan;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class AgentPanel
extends JPanel {
    protected GenerationPlan genplan;
    protected AgentModel agentModel;
    protected JTable agentTable;

    public AgentPanel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        this.agentModel = new AgentModel(generationPlan);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jCheckBox);
        TableColumn tableColumn = new TableColumn(0, 8, new CheckBoxCellRenderer(), defaultCellEditor);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(5, 24);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(5));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(4, 24);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(4));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(6, 24, new CheckBoxCellRenderer(), defaultCellEditor);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(6));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(7, 24);
        tableColumn.setHeaderValue(this.agentModel.getColumnName(7));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(8, 24, new IconRenderer(), new IconEditor());
        tableColumn.setHeaderValue(this.agentModel.getColumnName(8));
        defaultTableColumnModel.addColumn(tableColumn);
        this.agentTable = new JTable(this.agentModel, defaultTableColumnModel);
        this.agentTable.getTableHeader().setReorderingAllowed(false);
        this.agentTable.setColumnSelectionAllowed(false);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Task Agents");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        this.setBorder(titledBorder);
        JScrollPane jScrollPane = new JScrollPane(this.agentTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setMinimumSize(new Dimension(160, 80));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.agentTable.setBackground(Color.white);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        AgentToolBar agentToolBar = new AgentToolBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(agentToolBar, gridBagConstraints);
        this.add(agentToolBar);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.add(jScrollPane);
    }

    protected class AgentToolBar
    extends JToolBar
    implements ActionListener {
        protected JToggleButton helpBtn;
        protected HelpWindow helpWin;

        public AgentToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = SystemProps.getProperty("gif.dir") + "generator" + System.getProperty("file.separator");
            this.helpBtn = new JToggleButton(new ImageIcon(string + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), this.getLocation(), "generator", "Generation Plan: Agents");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class IconEditor
    extends DefaultCellEditor
    implements ActionListener {
        protected JButton button = new JButton("");
        protected int row;
        protected int column;
        protected Object value;
        protected FileDialog dialog = null;

        public IconEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.button.setBackground(Color.white);
            this.button.setHorizontalAlignment(2);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                File file;
                if (this.dialog == null) {
                    this.dialog = new FileDialog((Frame)SwingUtilities.getRoot(this.button), "Select (a file within) Target Directory", 0);
                }
                this.fireEditingCanceled();
                if (this.value != null && !this.value.equals("")) {
                    file = new File((String)this.value);
                    this.dialog.setFile(file.getName());
                    this.dialog.setDirectory(file.getParent());
                } else {
                    this.dialog.setFile("*.gif");
                }
                this.dialog.pack();
                this.dialog.setVisible(true);
                file = this.dialog.getFile() == null ? null : this.dialog.getDirectory() + System.getProperty("file.separator") + this.dialog.getFile();
                AgentPanel.this.agentModel.setValueAt(file, this.row, this.column);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.value = object;
            return this.button;
        }
    }

    protected class IconRenderer
    extends DefaultTableCellRenderer {
        public IconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object object) {
            if (object == null) {
                return;
            }
            String string = ((String)object).trim();
            if (string.equals("")) {
                return;
            }
            super.setIcon(new ImageIcon(string));
        }
    }

    protected class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setSelected((Boolean)object);
            }
            return this;
        }
    }
}

