/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.code;

import java.util.Vector;
import zeus.generator.code.AgentInfo;
import zeus.generator.code.GenerationPlan;
import zeus.generator.code.UtilityModel;
import zeus.util.Core;

public class AgentModel
extends UtilityModel {
    static final int GENERATE = 0;
    static final int STATUS = 1;
    static final int NAME = 2;
    static final int HOST = 3;
    static final int DATABASE = 4;
    static final int SERVER_FILE = 5;
    static final int HAS_GUI = 6;
    static final int EXTERNAL = 7;
    static final int ICON = 8;
    protected static final String[] columnNames = new String[]{"Generate", "Status", "Name", "Host", "Database Extension", "DNS file", "Create GUI?", "External Program", "Icon"};
    protected Vector data = new Vector();
    protected GenerationPlan genplan;

    public AgentModel(GenerationPlan generationPlan) {
        this.genplan = generationPlan;
        generationPlan.addChangeListener(this);
        this.refresh();
    }

    public void addNewRow() {
    }

    public void removeRows(int[] nArray) {
    }

    protected void refresh() {
        this.data.removeAllElements();
        AgentInfo[] agentInfoArray = this.genplan.getAgents();
        int n = 0;
        while (n < agentInfoArray.length) {
            this.data.addElement(agentInfoArray[n]);
            ++n;
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return columnNames.length;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String getColumnName(int n) {
        return columnNames[n];
    }

    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
            case 1: 
            case 2: {
                return false;
            }
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        AgentInfo agentInfo = (AgentInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return new Boolean(agentInfo.generate);
            }
            case 1: {
                return agentInfo.status;
            }
            case 2: {
                return agentInfo.name;
            }
            case 3: {
                return agentInfo.host;
            }
            case 4: {
                return agentInfo.database;
            }
            case 5: {
                return agentInfo.dns_file;
            }
            case 6: {
                return new Boolean(agentInfo.has_gui);
            }
            case 7: {
                return agentInfo.zeus_external;
            }
            case 8: {
                return agentInfo.icon_file;
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        AgentInfo agentInfo = (AgentInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                agentInfo.generate = this.updateBoolean(agentInfo.generate, object);
                if (!this.changed) break;
                this.genplan.setAgent(agentInfo);
                break;
            }
            case 1: {
                Core.ERROR(null, 1, (Object)this);
                break;
            }
            case 2: {
                Core.ERROR(null, 2, (Object)this);
                break;
            }
            case 3: {
                agentInfo.host = this.updateString(agentInfo.host, object);
                if (!this.changed) break;
                this.genplan.setAgent(agentInfo);
                break;
            }
            case 4: {
                agentInfo.database = this.updateString(agentInfo.database, object);
                if (!this.changed) break;
                this.genplan.setAgent(agentInfo);
                break;
            }
            case 5: {
                agentInfo.dns_file = this.updateString(agentInfo.dns_file, object);
                if (!this.changed) break;
                this.genplan.setAgent(agentInfo);
                break;
            }
            case 6: {
                agentInfo.has_gui = this.updateBoolean(agentInfo.has_gui, object);
                if (!this.changed) break;
                this.genplan.setAgent(agentInfo);
                break;
            }
            case 7: {
                agentInfo.zeus_external = this.updateString(agentInfo.zeus_external, object);
                if (!this.changed) break;
                this.genplan.setAgent(agentInfo);
                break;
            }
            case 8: {
                agentInfo.icon_file = this.updateString(agentInfo.icon_file, object);
                this.genplan.setAgentIcon(agentInfo);
            }
        }
    }
}

