/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import zeus.concepts.AgentDescription;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.AcquaintanceModel;
import zeus.generator.agent.AgentEditor;
import zeus.generator.agent.ProtocolModel;
import zeus.generator.agent.StrategyModel;
import zeus.generator.util.AttributeModel;
import zeus.generator.util.AttributeTable;
import zeus.generator.util.ControlPanel;
import zeus.generator.util.FactDialog;
import zeus.generator.util.FactSelector;
import zeus.generator.util.ParameterChooser;
import zeus.generator.util.ParameterDialog;
import zeus.gui.EditableMultipleSelectionDialog;
import zeus.gui.MultipleSelectionDialog;
import zeus.gui.help.HelpWindow;
import zeus.util.Misc;
import zeus.util.SystemProps;

public class CoordinationPanel
extends JPanel {
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};
    protected ControlPanel controlPane;
    protected AgentDescription agent;
    protected ProtocolModel protocolModel;
    protected JTable protocolTable;
    protected StrategyToolBar strategyToolBar;
    protected AttributeModel attributeModel;
    protected JTable strategyTable;
    protected StrategyModel strategyModel;
    protected Fact[] clipboard = null;
    protected OntologyDb ontologyDb;
    protected GeneratorModel genmodel;
    protected AgentEditor editor;

    public CoordinationPanel(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, AgentEditor agentEditor, AgentDescription agentDescription) {
        this.agent = agentDescription;
        this.genmodel = generatorModel;
        this.ontologyDb = ontologyDb;
        this.editor = agentEditor;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.controlPane = new ControlPanel(agentEditor, "Agent Coordination Panel", false, false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(this.controlPane, gridBagConstraints);
        this.add(this.controlPane);
        JPanel jPanel = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        AttributeModel attributeModel = new AttributeModel();
        AttributeTable attributeTable = new AttributeTable(attributeModel);
        this.strategyModel = new StrategyModel(generatorModel, ontologyDb, attributeModel);
        this.protocolModel = new ProtocolModel(ontologyDb, this.strategyModel, agentDescription.getProtocols());
        this.protocolModel.addChangeListener(agentEditor);
        attributeModel.addChangeListener(agentEditor);
        this.strategyModel.addChangeListener(agentEditor);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 24);
        tableColumn.setHeaderValue(this.protocolModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24, new FriendlyRenderer(), new DefaultCellEditor(new JTextField()));
        tableColumn.setHeaderValue(this.protocolModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jCheckBox);
        jCheckBox.addItemListener(new SymItemAction());
        tableColumn = new TableColumn(2, 8, new CheckBoxCellRenderer(), defaultCellEditor);
        tableColumn.setHeaderValue(this.protocolModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        this.protocolTable = new JTable(this.protocolModel, defaultTableColumnModel);
        this.protocolTable.getTableHeader().setReorderingAllowed(false);
        this.protocolTable.setColumnSelectionAllowed(false);
        ListSelectionModel listSelectionModel = this.protocolTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SymListAction1());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Coordination Protocols");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel.setBorder(titledBorder);
        gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBackground(Color.lightGray);
        ProtocolToolBar protocolToolBar = new ProtocolToolBar();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(protocolToolBar, gridBagConstraints);
        jPanel.add(protocolToolBar);
        JScrollPane jScrollPane = new JScrollPane(this.protocolTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setMinimumSize(new Dimension(160, 80));
        jScrollPane.setPreferredSize(new Dimension(200, 80));
        this.protocolTable.setBackground(Color.white);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        jPanel2.setBackground(Color.lightGray);
        defaultTableColumnModel = new DefaultTableColumnModel();
        JCheckBox jCheckBox2 = new JCheckBox();
        jCheckBox2.setHorizontalAlignment(0);
        tableColumn = new TableColumn(0, 4, new CheckBoxCellRenderer(), new DefaultCellEditor(jCheckBox2));
        tableColumn.setHeaderValue(this.strategyModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12);
        tableColumn.setHeaderValue(this.strategyModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24, new StringArrayCellRenderer(), new AgentCellEditor());
        tableColumn.setHeaderValue(this.strategyModel.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24, new StringArrayCellRenderer(), new RelationsCellEditor());
        tableColumn.setHeaderValue(this.strategyModel.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(4, 24, new FriendlyRenderer(), new StrategyCellEditor());
        tableColumn.setHeaderValue(this.strategyModel.getColumnName(4));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(5, 24, new HashtableCellRenderer(), new HashtableCellEditor());
        tableColumn.setHeaderValue(this.strategyModel.getColumnName(5));
        defaultTableColumnModel.addColumn(tableColumn);
        this.strategyTable = new JTable(this.strategyModel, defaultTableColumnModel);
        this.strategyTable.getTableHeader().setReorderingAllowed(false);
        this.strategyTable.setColumnSelectionAllowed(false);
        listSelectionModel = this.strategyTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SymListAction2());
        jScrollPane = new JScrollPane(this.strategyTable);
        jScrollPane.setBorder(new BevelBorder(1));
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        this.strategyTable.setBackground(Color.white);
        titledBorder = BorderFactory.createTitledBorder("Coordination Strategies");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        gridBagConstraints = new GridBagConstraints();
        this.strategyToolBar = new StrategyToolBar();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(this.strategyToolBar, gridBagConstraints);
        jPanel2.add(this.strategyToolBar);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagLayout.setConstraints(attributeTable, gridBagConstraints);
        jPanel2.add(attributeTable);
        this.strategyToolBar.setEnabled(false);
    }

    protected void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    protected void allowAllAgents() {
        if (!this.isRowSelected()) {
            return;
        }
        int n = this.strategyTable.getSelectedRow();
        this.strategyModel.setValueAt(StrategyModel.ALL, n, 2);
    }

    protected Fact[] getSelectedRows() {
        int[] nArray = this.strategyTable.getSelectedRows();
        Fact[] factArray = new Fact[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            factArray[n] = (Fact)this.strategyModel.getValueAt(nArray[n], 6);
            ++n;
        }
        return factArray;
    }

    protected Fact[] cutSelectedRows() {
        Fact[] factArray = this.getSelectedRows();
        this.strategyModel.removeRows(this.strategyTable.getSelectedRows());
        return factArray;
    }

    protected void deleteSelectedRow() {
        if (!this.isRowSelected()) {
            return;
        }
        this.cutSelectedRows();
    }

    protected boolean isRowSelected() {
        int n = this.strategyTable.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return false;
        }
        return true;
    }

    void save() {
        this.agent.setProtocols(this.protocolModel.getData());
    }

    class SymListAction2
    implements ListSelectionListener {
        SymListAction2() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            CoordinationPanel.this.strategyModel.selectRow(CoordinationPanel.this.strategyTable.getSelectedRow());
        }
    }

    class SymListAction1
    implements ListSelectionListener {
        SymListAction1() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = CoordinationPanel.this.protocolTable.getSelectedRow();
            CoordinationPanel.this.protocolModel.selectRow(n);
            if (n != -1) {
                Boolean bl = (Boolean)CoordinationPanel.this.protocolModel.getValueAt(n, 2);
                CoordinationPanel.this.strategyToolBar.setEnabled(bl.equals(Boolean.TRUE));
            }
        }
    }

    protected class ProtocolToolBar
    extends JToolBar
    implements ActionListener {
        protected JToggleButton helpBtn;
        protected JButton clearBtn;
        protected JButton allBtn;
        protected HelpWindow helpWin;

        public ProtocolToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = SystemProps.getProperty("gif.dir") + "generator" + System.getProperty("file.separator");
            this.clearBtn = new JButton(new ImageIcon(string + "clear.gif"));
            this.clearBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.clearBtn);
            this.clearBtn.setToolTipText("Clear all protocols");
            this.clearBtn.addActionListener(this);
            this.allBtn = new JButton(new ImageIcon(string + "all.gif"));
            this.allBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.allBtn);
            this.allBtn.setToolTipText("Select all protocols");
            this.allBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.clearBtn) {
                int n = 0;
                while (n < CoordinationPanel.this.protocolModel.getRowCount()) {
                    CoordinationPanel.this.protocolModel.setValueAt(Boolean.FALSE, n, 2);
                    ++n;
                }
            } else if (object == this.allBtn) {
                int n = 0;
                while (n < CoordinationPanel.this.protocolModel.getRowCount()) {
                    CoordinationPanel.this.protocolModel.setValueAt(Boolean.TRUE, n, 2);
                    ++n;
                }
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Activity Coord-1");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    protected class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer,
    Serializable {
        public CheckBoxCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setSelected((Boolean)object);
            }
            return this;
        }
    }

    class StrategyToolBar
    extends JToolBar
    implements ActionListener,
    FactSelector {
        protected FactDialog factWin;
        protected HelpWindow helpWin;
        protected JToggleButton helpBtn;
        protected JButton newBtn;
        protected JButton deleteBtn;
        protected JButton cutBtn;
        protected JButton copyBtn;
        protected JButton pasteBtn;
        protected JButton allBtn;

        public StrategyToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new1.gif"));
            this.newBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("New");
            this.newBtn.addActionListener(this);
            this.allBtn = new JButton(new ImageIcon(string2 + "all.gif"));
            this.allBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.allBtn);
            this.allBtn.setToolTipText("Set list of agents to any");
            this.allBtn.addActionListener(this);
            this.addSeparator();
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete1.gif"));
            this.deleteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete");
            this.deleteBtn.addActionListener(this);
            this.addSeparator();
            this.cutBtn = new JButton(new ImageIcon(string2 + "cut.gif"));
            this.cutBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.cutBtn);
            this.cutBtn.setToolTipText("Cut");
            this.cutBtn.addActionListener(this);
            this.copyBtn = new JButton(new ImageIcon(string2 + "copy.gif"));
            this.copyBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.copyBtn);
            this.copyBtn.setToolTipText("Copy");
            this.copyBtn.addActionListener(this);
            this.pasteBtn = new JButton(new ImageIcon(string2 + "paste.gif"));
            this.pasteBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.pasteBtn);
            this.pasteBtn.setToolTipText("Paste");
            this.pasteBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "help.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.factWin = new FactDialog((Frame)SwingUtilities.getRoot(this), CoordinationPanel.this.ontologyDb);
        }

        public void setEnabled(boolean bl) {
            this.newBtn.setEnabled(bl);
            this.allBtn.setEnabled(bl);
            this.deleteBtn.setEnabled(bl);
            this.cutBtn.setEnabled(bl);
            this.copyBtn.setEnabled(bl);
            this.pasteBtn.setEnabled(bl);
        }

        public void factSelected(String[] stringArray) {
            CoordinationPanel.this.strategyModel.addNewRows(stringArray);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.factWin.setLocationRelativeTo(this.newBtn);
                this.factWin.display(this);
            } else if (object == this.allBtn) {
                CoordinationPanel.this.allowAllAgents();
            } else if (object == this.deleteBtn) {
                CoordinationPanel.this.deleteSelectedRow();
            } else if (object == this.copyBtn) {
                CoordinationPanel.this.clipboard = CoordinationPanel.this.getSelectedRows();
            } else if (object == this.pasteBtn) {
                CoordinationPanel.this.strategyModel.addRows(CoordinationPanel.this.clipboard);
                CoordinationPanel.this.strategyTable.clearSelection();
            } else if (object == this.cutBtn) {
                CoordinationPanel.this.clipboard = CoordinationPanel.this.cutSelectedRows();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Activity Coord-2");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
            this.repaint();
        }
    }

    class HashtableCellEditor
    extends DefaultCellEditor
    implements ActionListener,
    ParameterChooser {
        protected JButton button = new JButton("");
        protected int row;
        protected int column;
        protected ParameterDialog dialog;
        protected Hashtable value;

        public HashtableCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(1);
            this.dialog = new ParameterDialog((Frame)SwingUtilities.getRoot(CoordinationPanel.this.editor), "Set Parameters");
            this.button.setBackground(Color.white);
            this.button.setHorizontalAlignment(2);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                this.dialog.setLocationRelativeTo(this.button);
                this.fireEditingCanceled();
                this.dialog.display(this, this.value);
                CoordinationPanel.this.repaint();
            }
            CoordinationPanel.this.repaint();
        }

        public void parametersChanged(Hashtable hashtable) {
            CoordinationPanel.this.strategyModel.setValueAt(hashtable, this.row, this.column);
            CoordinationPanel.this.repaint();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.value = (Hashtable)object;
            CoordinationPanel.this.repaint();
            return this.button;
        }
    }

    class HashtableCellRenderer
    extends DefaultTableCellRenderer {
        HashtableCellRenderer() {
        }

        public void setValue(Object object) {
            if (object == null) {
                super.setValue(object);
            } else {
                Hashtable hashtable = (Hashtable)object;
                Enumeration enumeration = hashtable.keys();
                String string = "";
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)hashtable.get(string2);
                    string = string + string2 + "=" + string3 + " ";
                }
                super.setValue(string.trim());
            }
        }
    }

    class FriendlyRenderer
    extends DefaultTableCellRenderer {
        FriendlyRenderer() {
        }

        public void setValue(Object object) {
            if (object == null) {
                super.setValue(object);
            } else {
                String string = SystemProps.getProperty("friendly.name." + object, (String)object);
                super.setValue(string);
            }
        }
    }

    class StringArrayCellRenderer
    extends DefaultTableCellRenderer {
        StringArrayCellRenderer() {
        }

        public void setValue(Object object) {
            String string = Misc.concat((String[])object);
            super.setValue(string);
        }
    }

    class RelationsCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        protected JButton button = new JButton("");
        protected int row;
        protected int column;
        protected MultipleSelectionDialog dialog;
        protected Object value;

        public RelationsCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(2);
            this.dialog = new MultipleSelectionDialog((Frame)SwingUtilities.getRoot(CoordinationPanel.this.editor), "Select Relations");
            this.dialog.setListData(Misc.stringArray(AcquaintanceModel.RELATIONS_LIST));
            this.button.setBackground(Color.white);
            this.button.setHorizontalAlignment(2);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                this.dialog.setSelection((String[])this.value);
                this.dialog.setLocationRelativeTo(this.button);
                this.fireEditingCanceled();
                Object[] objectArray = this.dialog.getSelection();
                CoordinationPanel.this.strategyModel.setValueAt(Misc.stringArray(objectArray), this.row, this.column);
            }
            CoordinationPanel.this.repaint();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.value = object;
            return this.button;
        }
    }

    class AgentCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        protected JButton button = new JButton("");
        protected int row;
        protected int column;
        protected EditableMultipleSelectionDialog dialog;
        protected Object value;

        public AgentCellEditor() {
            super(new JTextField());
            this.setClickCountToStart(2);
            this.dialog = new EditableMultipleSelectionDialog((Frame)SwingUtilities.getRoot(CoordinationPanel.this.editor), "Select Agents");
            this.button.setBackground(Color.white);
            this.button.setHorizontalAlignment(2);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                Object[] objectArray = CoordinationPanel.this.genmodel.getAgentNames();
                Vector vector = Misc.stringVector((String[])objectArray);
                vector.removeElement(CoordinationPanel.this.editor.getObjectName());
                objectArray = Misc.stringArray(vector);
                this.dialog.setListData(objectArray);
                this.dialog.setSelection((String[])this.value);
                this.dialog.setLocationRelativeTo(this.button);
                this.fireEditingCanceled();
                Object[] objectArray2 = this.dialog.getSelection();
                CoordinationPanel.this.strategyModel.setValueAt(Misc.stringArray(objectArray2), this.row, this.column);
            }
            CoordinationPanel.this.repaint();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.value = object;
            return this.button;
        }
    }

    class StrategyCellEditor
    extends DefaultCellEditor {
        public StrategyCellEditor() {
            super(new JComboBox(){

                public void contentsChanged(ListDataEvent listDataEvent) {
                    this.selectedItemReminder = null;
                    super.contentsChanged(listDataEvent);
                }
            });
            JComboBox jComboBox = (JComboBox)this.editorComponent;
            DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(this){
                private final /* synthetic */ StrategyCellEditor this$1;
                {
                    this.this$1 = strategyCellEditor;
                }

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    if (object != null) {
                        object = SystemProps.getProperty("friendly.name." + object, (String)object);
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                }
            };
            jComboBox.setRenderer(defaultListCellRenderer);
            this.setClickCountToStart(2);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string;
            Vector vector = null;
            JComboBox jComboBox = (JComboBox)this.editorComponent;
            if (jComboBox.getModel().getSize() != 0) {
                jComboBox.removeAllItems();
            }
            vector = (string = (String)CoordinationPanel.this.protocolModel.getValueAt(CoordinationPanel.this.protocolTable.getSelectedRow(), 0)).equals("Initiator") ? StrategyModel.INITIATOR_STRATEGY_LIST : StrategyModel.RESPONDENT_STRATEGY_LIST;
            int n3 = 0;
            while (n3 < vector.size()) {
                jComboBox.addItem(vector.elementAt(n3));
                ++n3;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    class SymItemAction
    implements ItemListener {
        SymItemAction() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            CoordinationPanel.this.strategyToolBar.setEnabled(itemEvent.getStateChange() == 1);
            CoordinationPanel.this.repaint();
        }
    }
}

