/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.AgentDescription;
import zeus.concepts.OntologyDb;
import zeus.generator.AgentGenerator;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.CoordinationPanel;
import zeus.generator.agent.DefinitionPanel;
import zeus.generator.agent.OrganisationPanel;
import zeus.generator.agent.RestrictionPanel;
import zeus.generator.util.Editor;
import zeus.gui.help.HelpWindow;
import zeus.util.SystemProps;

public class AgentEditor
extends JFrame
implements Editor {
    protected DefinitionPanel definitionPanel;
    protected OrganisationPanel organisationPanel;
    protected CoordinationPanel coordinationPanel;
    protected RestrictionPanel restrictionPanel;
    protected JTabbedPane tabbedPane;
    protected AgentGenerator generator;
    protected GeneratorModel genmodel;
    protected OntologyDb ontologyDb;
    protected HelpWindow helpWin;
    protected boolean changed;
    protected EventListenerList changeListeners = new EventListenerList();
    protected AgentDescription currentAgent;
    static final String[] MESSAGE = new String[]{"Save agent?", "Save needed", "Agent Editor: "};
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public AgentEditor(AgentGenerator agentGenerator, GeneratorModel generatorModel, OntologyDb ontologyDb, AgentDescription agentDescription) {
        this.generator = agentGenerator;
        this.genmodel = generatorModel;
        this.currentAgent = agentDescription;
        this.ontologyDb = ontologyDb;
        this.changed = false;
        generatorModel.addChangeListener(this);
        this.getContentPane().setBackground(Color.gray);
        this.getContentPane().setLayout(new BorderLayout());
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "edit.gif");
        this.setIconImage(imageIcon.getImage());
        this.tabbedPane = new JTabbedPane();
        this.definitionPanel = new DefinitionPanel(agentGenerator, generatorModel, ontologyDb, this, agentDescription);
        this.organisationPanel = new OrganisationPanel(agentGenerator, generatorModel, ontologyDb, this, agentDescription);
        this.coordinationPanel = new CoordinationPanel(agentGenerator, generatorModel, ontologyDb, this, agentDescription);
        this.restrictionPanel = new RestrictionPanel(agentGenerator, generatorModel, ontologyDb, this, agentDescription);
        this.tabbedPane.addTab("Agent Definition", this.definitionPanel);
        this.tabbedPane.addTab("Agent Organisation", this.organisationPanel);
        this.tabbedPane.addTab("Agent Coordination", this.coordinationPanel);
        this.tabbedPane.addTab("Value Restrictions", this.restrictionPanel);
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.setTabPlacement(3);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AgentEditor.this.closeDown();
            }
        });
        String string3 = generatorModel.getAgentName(agentDescription.getName());
        this.setTitle(MESSAGE[2] + string3);
        this.validate();
        this.pack();
    }

    public void previous() {
        if (this.tabbedPane.getSelectedIndex() > 0) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getSelectedIndex() - 1);
        }
    }

    public void next() {
        if (this.tabbedPane.getSelectedIndex() + 1 < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(this.tabbedPane.getSelectedIndex() + 1);
        }
    }

    public void help(AbstractButton abstractButton) {
        if (abstractButton.isSelected()) {
            Point point = this.getLocation();
            this.helpWin = new HelpWindow(this, point, "generator", "Agent Design Approach");
            this.helpWin.setSource(abstractButton);
        } else {
            this.helpWin.dispose();
        }
    }

    public void save() {
        this.definitionPanel.save();
        this.organisationPanel.save();
        this.coordinationPanel.save();
        this.restrictionPanel.save();
        this.genmodel.updateAgent(this.currentAgent);
        this.changed = false;
        this.fireChanged();
    }

    public AgentDescription getCurrentAgent() {
        return this.currentAgent;
    }

    public String getObjectName() {
        return this.genmodel.getAgentName(this.currentAgent.getName());
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() != this.genmodel) {
            this.changed = true;
        } else if (changeEvent.getSource() == this.genmodel) {
            String string = this.genmodel.getAgentName(this.currentAgent.getName());
            this.setTitle(MESSAGE[2] + string);
        }
        this.fireChanged();
    }

    public void closeDown() {
        if (this.changed) {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[0], MESSAGE[1], 1);
            if (n == 0) {
                this.save();
            } else if (n == 2) {
                return;
            }
        }
        this.generator.agentEditorClosed(this.currentAgent.getName());
        this.dispose();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AgentEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AgentEditor.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? AgentEditor.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

