/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator.agent;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.concepts.Acquaintance;
import zeus.concepts.OntologyDb;
import zeus.generator.GeneratorModel;
import zeus.generator.agent.AbilityModel;
import zeus.util.Core;
import zeus.util.SystemProps;

public class AcquaintanceModel
extends AbstractTableModel
implements ChangeListener {
    static final int ALL = 0;
    static final int PEERS = 1;
    static final int OTHERS = 2;
    static final int AGENT = 0;
    static final int RELATION = 1;
    static final int ID = 2;
    public static Vector RELATIONS_LIST;
    public static final String PEER_RELATION;
    protected String[] columnNames = new String[]{"Agent", "Relation"};
    protected Vector data = new Vector(100);
    protected int filter = 0;
    protected int selectedRow = -1;
    protected AbilityModel abilityModel;
    protected GeneratorModel genmodel;
    protected OntologyDb ontologyDb;
    protected EventListenerList changeListeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public AcquaintanceModel(GeneratorModel generatorModel, OntologyDb ontologyDb, AbilityModel abilityModel, Acquaintance[] acquaintanceArray) {
        this.abilityModel = abilityModel;
        this.genmodel = generatorModel;
        this.reset(acquaintanceArray);
        ontologyDb.addChangeListener(this);
        generatorModel.addChangeListener(this);
    }

    public void reset(Acquaintance[] acquaintanceArray) {
        int n = this.data.size();
        this.data.removeAllElements();
        if (n != 0) {
            this.fireTableRowsDeleted(0, n - 1);
        }
        this.filter = 0;
        this.selectRow(-1);
        if (acquaintanceArray == null || acquaintanceArray.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < acquaintanceArray.length) {
            this.data.addElement(acquaintanceArray[n2]);
            ++n2;
        }
        this.fireTableRowsInserted(0, acquaintanceArray.length - 1);
    }

    public void setFilter(int n) {
        if (this.filter == n) {
            return;
        }
        this.filter = n;
        this.selectRow(-1);
        this.fireTableDataChanged();
    }

    public void selectRow(int n) {
        this.selectedRow = n;
        if (this.abilityModel != null) {
            if (this.selectedRow != -1) {
                this.abilityModel.reset(this.getAcquaintanceAt(n));
            } else {
                this.abilityModel.reset(null);
            }
        }
    }

    public void addNewRow() {
        String string = this.genmodel.createNewAgentId();
        this.genmodel.createNewAgent(string);
        Acquaintance acquaintance = new Acquaintance(string, PEER_RELATION);
        this.data.addElement(acquaintance);
        this.selectRow(-1);
        int n = this.data.size();
        this.fireTableRowsInserted(n - 2, n - 1);
        this.fireChanged();
    }

    public void addNewRow(String string) {
        if (this.contains(string)) {
            return;
        }
        String string2 = this.genmodel.reverseAgentNameLookup(string);
        Acquaintance acquaintance = new Acquaintance(string2, PEER_RELATION);
        this.data.addElement(acquaintance);
        this.selectRow(-1);
        int n = this.data.size();
        this.fireTableRowsInserted(n - 2, n - 1);
        this.fireChanged();
    }

    public void removeRow(int n) {
        Acquaintance acquaintance = this.getAcquaintanceAt(n);
        this.data.removeElement(acquaintance);
        this.selectRow(-1);
        this.fireTableRowsDeleted(n, n);
        this.fireChanged();
    }

    public Acquaintance[] getData() {
        this.selectRow(this.selectedRow);
        Acquaintance[] acquaintanceArray = new Acquaintance[this.data.size()];
        int n = 0;
        while (n < acquaintanceArray.length) {
            acquaintanceArray[n] = (Acquaintance)this.data.elementAt(n);
            ++n;
        }
        return acquaintanceArray;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return true;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        int n = 0;
        switch (this.filter) {
            case 0: {
                return this.data.size();
            }
            case 1: {
                int n2 = 0;
                while (n2 < this.data.size()) {
                    Acquaintance acquaintance = (Acquaintance)this.data.elementAt(n2);
                    if (acquaintance.getRelation().equals(PEER_RELATION)) {
                        ++n;
                    }
                    ++n2;
                }
                return n;
            }
            case 2: {
                int n3 = 0;
                while (n3 < this.data.size()) {
                    Acquaintance acquaintance = (Acquaintance)this.data.elementAt(n3);
                    if (!acquaintance.getRelation().equals(PEER_RELATION)) {
                        ++n;
                    }
                    ++n3;
                }
                return n;
            }
        }
        return 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().equals("")) {
            return;
        }
        Acquaintance acquaintance = this.getAcquaintanceAt(n);
        String string = acquaintance.getName();
        String string2 = this.genmodel.getAgentName(string);
        String string3 = acquaintance.getRelation();
        switch (n2) {
            case 0: {
                String string4 = (String)object;
                if (string2.equals(string4)) {
                    return;
                }
                if (this.contains(string4)) {
                    return;
                }
                String string5 = this.genmodel.reverseAgentNameLookup(string4);
                if (string5 != null) {
                    acquaintance.setName(string5);
                } else {
                    this.genmodel.renameAgent(string, string4);
                }
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
                break;
            }
            case 1: {
                if (string3.equals(object)) {
                    return;
                }
                acquaintance.setRelation((String)object);
                this.fireTableCellUpdated(n, n2);
                this.fireChanged();
            }
        }
    }

    public Object getValueAt(int n, int n2) {
        Acquaintance acquaintance = this.getAcquaintanceAt(n);
        switch (n2) {
            case 0: {
                return this.genmodel.getAgentName(acquaintance.getName());
            }
            case 2: {
                return acquaintance.getName();
            }
            case 1: {
                return acquaintance.getRelation();
            }
        }
        return null;
    }

    protected Acquaintance getAcquaintanceAt(int n) {
        Acquaintance acquaintance = null;
        switch (this.filter) {
            case 0: {
                return (Acquaintance)this.data.elementAt(n);
            }
            case 1: {
                int n2 = -1;
                int n3 = 0;
                while (n3 < this.data.size()) {
                    acquaintance = (Acquaintance)this.data.elementAt(n3);
                    if (acquaintance.getRelation().equals(PEER_RELATION)) {
                        ++n2;
                    }
                    if (n2 == n) {
                        return acquaintance;
                    }
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = -1;
                int n5 = 0;
                while (n5 < this.data.size()) {
                    acquaintance = (Acquaintance)this.data.elementAt(n5);
                    if (!acquaintance.getRelation().equals(PEER_RELATION)) {
                        ++n4;
                    }
                    if (n4 == n) {
                        return acquaintance;
                    }
                    ++n5;
                }
                break;
            }
        }
        Core.ERROR(false, 1, (Object)this);
        return null;
    }

    protected boolean contains(String string) {
        int n = 0;
        while (n < this.data.size()) {
            Acquaintance acquaintance = (Acquaintance)this.data.elementAt(n);
            if (string.equals(this.genmodel.getAgentName(acquaintance.getName()))) {
                JOptionPane.showMessageDialog(null, "Attempting to add an already\nexisting agent", "Error", 0);
                return true;
            }
            ++n;
        }
        return false;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object != this.ontologyDb && object == this.genmodel) {
            this.fireTableDataChanged();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AcquaintanceModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = AcquaintanceModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? AcquaintanceModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        String string;
        RELATIONS_LIST = null;
        PEER_RELATION = SystemProps.getProperty("system.organisation.relations.default");
        String string2 = SystemProps.getProperty("system.organisation.relations");
        String string3 = SystemProps.getProperty("user.organisation.relations");
        String string4 = SystemProps.getProperty("file.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string4);
        RELATIONS_LIST = new Vector(100);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (RELATIONS_LIST.contains(string)) continue;
            RELATIONS_LIST.addElement(string);
        }
        if (string3 != null) {
            stringTokenizer = new StringTokenizer(string3, string4);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (RELATIONS_LIST.contains(string)) continue;
                RELATIONS_LIST.addElement(string);
            }
        }
        if (!RELATIONS_LIST.contains(PEER_RELATION)) {
            RELATIONS_LIST.addElement(PEER_RELATION);
        }
    }
}

