/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import zeus.concepts.AbstractTask;
import zeus.concepts.AgentDescription;
import zeus.concepts.OntologyDb;
import zeus.concepts.PlanScript;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ReteKB;
import zeus.concepts.SummaryTask;
import zeus.generator.event.AgentChangeEvent;
import zeus.generator.event.AgentListener;
import zeus.generator.event.TaskChangeEvent;
import zeus.generator.event.TaskListener;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.SystemProps;

public class GeneratorModel
implements ChangeListener {
    private int agentCount = 0;
    private int agentIdCount = 0;
    private int taskCount = 0;
    private int taskIdCount = 0;
    protected EventListenerList eventListeners = new EventListenerList();
    protected Hashtable agentTable;
    protected Hashtable taskTable;
    protected Hashtable agentNames;
    protected Hashtable taskNames;
    protected Hashtable iconTable;
    public OntologyDb ontology;
    public String dbName = "";
    public String dbDriver = "";
    public String dbUsername = "";
    public String dbPassword = "";
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;
    static /* synthetic */ Class class$zeus$generator$event$AgentListener;
    static /* synthetic */ Class class$zeus$generator$event$TaskListener;

    public GeneratorModel(OntologyDb ontologyDb) {
        this.ontology = ontologyDb;
        ontologyDb.addChangeListener(this);
        this.agentTable = new Hashtable();
        this.taskTable = new Hashtable();
        this.agentNames = new Hashtable();
        this.taskNames = new Hashtable();
        this.iconTable = new Hashtable();
    }

    public void clear() {
        Enumeration enumeration = this.agentTable.elements();
        while (enumeration.hasMoreElements()) {
            AgentDescription agentDescription = (AgentDescription)enumeration.nextElement();
            this.fireAgentChanged(agentDescription, 2);
        }
        enumeration = this.taskTable.elements();
        while (enumeration.hasMoreElements()) {
            AbstractTask abstractTask = (AbstractTask)enumeration.nextElement();
            this.fireTaskChanged(abstractTask, 2);
        }
        this.agentTable.clear();
        this.taskTable.clear();
        this.agentNames.clear();
        this.taskNames.clear();
        this.iconTable.clear();
    }

    public String getAgentIcon(String string) {
        Core.ERROR(this.agentNames.containsKey(string), 255, (Object)this);
        String string2 = (String)this.iconTable.get(string);
        if (string2 == null) {
            string2 = SystemProps.getProperty("gif.dir") + File.separator + "agent.gif";
            this.iconTable.put(string, string2);
        }
        return string2;
    }

    public void setAgentIcon(String string, String string2) {
        boolean bl;
        Core.ERROR(this.agentNames.containsKey(string), 255, (Object)this);
        String string3 = (String)this.iconTable.get(string);
        boolean bl2 = bl = string3 == null && string2 != null || string3 != null && string2 == null || string3 != null && string2 != null && !string2.equals(string3);
        if (string2 == null) {
            string2 = SystemProps.getProperty("gif.dir") + File.separator + "agent.gif";
        }
        this.iconTable.put(string, string2);
        if (bl && this.agentTable.containsKey(string)) {
            this.fireAgentChanged((AgentDescription)this.agentTable.get(string), 1);
        }
    }

    public AgentDescription[] getAgents() {
        AgentDescription[] agentDescriptionArray = new AgentDescription[this.agentTable.size()];
        Enumeration enumeration = this.agentTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            agentDescriptionArray[n] = (AgentDescription)enumeration.nextElement();
            ++n;
        }
        return agentDescriptionArray;
    }

    public Object[][] getAgentData() {
        Object[][] objectArray = new Object[this.agentTable.size()][3];
        Enumeration enumeration = this.agentTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            AgentDescription agentDescription = (AgentDescription)enumeration.nextElement();
            objectArray[n][0] = this.getAgentName(agentDescription.getName());
            String[] stringArray = agentDescription.getTasks();
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = this.getTaskName(stringArray[n2]);
                ++n2;
            }
            objectArray[n][1] = stringArray;
            objectArray[n][2] = agentDescription.getName();
            ++n;
        }
        return objectArray;
    }

    public void updateAgent(AgentDescription agentDescription) {
        String string = agentDescription.getName();
        AgentDescription agentDescription2 = this.agentTable.put(string, agentDescription);
        Core.ERROR(agentDescription2 != null, 7, (Object)this);
        this.fireAgentChanged(agentDescription, 1);
    }

    public void addAgent(AgentDescription agentDescription) {
        String string = agentDescription.getName();
        Core.ERROR(!this.agentTable.containsKey(string), 1, (Object)this);
        this.agentTable.put(string, new AgentDescription(agentDescription));
        if (this.agentNames.get(string) == null) {
            String string2 = "Agent" + this.agentCount++;
            while (this.reverseAgentNameLookup(string2) != null) {
                string2 = "Agent" + this.agentCount++;
            }
            this.agentNames.put(string, string2);
        }
        this.fireAgentChanged(agentDescription, 0);
    }

    public void modifyAgentTasks(String string, String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = this.reverseTaskNameLookup(stringArray[n]);
            ++n;
        }
        AgentDescription agentDescription = (AgentDescription)this.agentTable.get(string);
        agentDescription.setTasks(stringArray2);
        this.fireAgentChanged(agentDescription, 1);
    }

    public void addAgent(Vector vector) {
        int n = 0;
        while (vector != null && n < vector.size()) {
            this.addAgent((AgentDescription)vector.elementAt(n));
            ++n;
        }
    }

    public void removeAgent(String string) {
        AgentDescription agentDescription = (AgentDescription)this.agentTable.get(string);
        this.agentTable.remove(string);
        this.agentNames.remove(string);
        this.iconTable.remove(string);
        this.fireAgentChanged(agentDescription, 2);
    }

    public AgentDescription getAgent(String string) {
        AgentDescription agentDescription = (AgentDescription)this.agentTable.get(string);
        Assert.notNull(agentDescription);
        return new AgentDescription(agentDescription);
    }

    public void addAgentName(String string, String string2) {
        this.agentNames.put(string, string2);
    }

    public String createNewAgentId() {
        String string = "AgentId" + this.agentIdCount++;
        while (this.agentNames.containsKey(string)) {
            string = "AgentId" + this.agentIdCount++;
        }
        return string;
    }

    public void createNewAgent() {
        this.createNewAgent(this.createNewAgentId());
    }

    public void createNewAgent(String string) {
        Core.ERROR(this.agentNames.get(string) == null, 6, (Object)this);
        String string2 = "Agent" + this.agentCount++;
        while (this.reverseAgentNameLookup(string2) != null) {
            string2 = "Agent" + this.agentCount++;
        }
        this.agentNames.put(string, string2);
        AgentDescription agentDescription = new AgentDescription();
        agentDescription.setName(string);
        this.addAgent(agentDescription);
    }

    public void cloneAgent(String string) {
        String string2 = (String)this.agentNames.get(string);
        Core.ERROR(string2, 11, (Object)this);
        AgentDescription agentDescription = (AgentDescription)this.agentTable.get(string);
        String string3 = string2 + "$" + this.agentCount++;
        while (this.reverseAgentNameLookup(string3) != null) {
            string3 = string2 + "$" + this.agentCount++;
        }
        String string4 = this.createNewAgentId();
        this.agentNames.put(string4, string3);
        AgentDescription agentDescription2 = new AgentDescription(agentDescription);
        agentDescription2.setName(string4);
        this.agentTable.put(string4, agentDescription2);
        this.fireAgentChanged(agentDescription2, 0);
    }

    public String getAgentName(String string) {
        return (String)this.agentNames.get(string);
    }

    public String[] getAgentIds() {
        String[] stringArray = new String[this.agentNames.size()];
        Enumeration enumeration = this.agentNames.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getAgentNames() {
        String[] stringArray = new String[this.agentNames.size()];
        Enumeration enumeration = this.agentNames.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String reverseAgentNameLookup(String string) {
        Enumeration enumeration = this.agentNames.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.agentNames.get(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public void renameAgent(String string, String string2) {
        String string3 = string2;
        while (this.reverseAgentNameLookup(string2) != null) {
            string3 = string2 + this.agentIdCount++;
        }
        this.agentNames.put(string, string3);
        AgentDescription agentDescription = (AgentDescription)this.agentTable.get(string);
        this.fireAgentChanged(agentDescription, 1);
    }

    public boolean containsAgent(String string) {
        Assert.notNull(string);
        return this.agentNames.containsKey(string);
    }

    public void addTaskName(String string, String string2) {
        this.taskNames.put(string, string2);
    }

    public void addTask(AbstractTask abstractTask) {
        String string = abstractTask.getName();
        Core.ERROR(!this.taskTable.containsKey(string), 2, (Object)this);
        String string2 = this.getTaskName(string);
        Core.ERROR(string2, 3, (Object)this);
        this.taskNames.put(string, string2);
        switch (abstractTask.getType()) {
            case 0: {
                this.taskTable.put(string, new PrimitiveTask((PrimitiveTask)abstractTask));
                break;
            }
            case 1: {
                this.taskTable.put(string, new SummaryTask((SummaryTask)abstractTask));
                break;
            }
            case 2: {
                this.taskTable.put(string, new ReteKB((ReteKB)abstractTask));
                break;
            }
            case 3: {
                this.taskTable.put(string, new PlanScript((PlanScript)abstractTask));
            }
        }
        this.fireTaskChanged(abstractTask, 0);
    }

    public void updateTask(AbstractTask abstractTask) {
        String string = abstractTask.getName();
        AbstractTask abstractTask2 = this.taskTable.put(string, abstractTask);
        Core.ERROR(abstractTask2 != null, 4, (Object)this);
        this.fireTaskChanged(abstractTask, 1);
    }

    public void addTask(Vector vector) {
        int n = 0;
        while (vector != null && n < vector.size()) {
            this.addTask((AbstractTask)vector.elementAt(n));
            ++n;
        }
    }

    public void removeTask(String string) {
        AbstractTask abstractTask = (AbstractTask)this.taskTable.get(string);
        this.taskTable.remove(string);
        this.taskNames.remove(string);
        Enumeration enumeration = this.agentTable.elements();
        while (enumeration.hasMoreElements()) {
            AgentDescription agentDescription = (AgentDescription)enumeration.nextElement();
            if (!agentDescription.removeTask(string)) continue;
            this.fireAgentChanged(agentDescription, 1);
        }
        this.fireTaskChanged(abstractTask, 2);
    }

    public AbstractTask getTask(String string) {
        return (AbstractTask)this.taskTable.get(string);
    }

    public boolean containsTask(String string, int n) {
        AbstractTask abstractTask = (AbstractTask)this.taskTable.get(string);
        return abstractTask != null && abstractTask.getType() == n;
    }

    public int getTaskCount(int n) {
        Enumeration enumeration = this.taskTable.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AbstractTask abstractTask = (AbstractTask)enumeration.nextElement();
            if (abstractTask.getType() != n) continue;
            ++n2;
        }
        return n2;
    }

    public AbstractTask[] getTasks() {
        AbstractTask[] abstractTaskArray = new AbstractTask[this.taskTable.size()];
        Enumeration enumeration = this.taskTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            abstractTaskArray[n] = (AbstractTask)enumeration.nextElement();
            ++n;
        }
        return abstractTaskArray;
    }

    public AbstractTask[] getTasks(int n) {
        AbstractTask[] abstractTaskArray = new AbstractTask[this.getTaskCount(n)];
        Enumeration enumeration = this.taskTable.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AbstractTask abstractTask = (AbstractTask)enumeration.nextElement();
            if (abstractTask.getType() != n) continue;
            abstractTaskArray[n2++] = abstractTask;
        }
        return abstractTaskArray;
    }

    public String[] getTaskNames(int n) {
        String[] stringArray = new String[this.getTaskCount(n)];
        Enumeration enumeration = this.taskTable.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            AbstractTask abstractTask = (AbstractTask)enumeration.nextElement();
            if (abstractTask.getType() != n) continue;
            stringArray[n2++] = (String)this.taskNames.get(abstractTask.getName());
        }
        return stringArray;
    }

    public String getTaskType(String string) {
        AbstractTask abstractTask = (AbstractTask)this.taskTable.get(string);
        return abstractTask.getTypeName();
    }

    public String createNewTaskId() {
        String string = "AbstractTaskId" + this.taskIdCount++;
        while (this.taskNames.containsKey(string)) {
            string = "AbstractTaskId" + this.taskIdCount++;
        }
        return string;
    }

    public void createNewTask(String string) {
        this.createNewTask(this.createNewTaskId(), string);
    }

    public void createNewTask(String string, String string2) {
        Core.ERROR(this.taskNames.get(string) == null, 5, (Object)this);
        String string3 = "Task" + this.taskCount++;
        while (this.reverseTaskNameLookup(string3) != null) {
            string3 = "Task" + this.taskCount++;
        }
        this.taskNames.put(string, string3);
        AbstractTask abstractTask = null;
        switch (AbstractTask.getType(string2)) {
            case 0: {
                abstractTask = new PrimitiveTask();
                break;
            }
            case 1: {
                abstractTask = new SummaryTask();
                break;
            }
            case 2: {
                abstractTask = new ReteKB();
                break;
            }
            case 3: {
                abstractTask = new PlanScript();
            }
        }
        abstractTask.setName(string);
        this.taskTable.put(string, abstractTask);
        this.fireTaskChanged(abstractTask, 0);
    }

    public void cloneTask(String string) {
        String string2 = (String)this.taskNames.get(string);
        Core.ERROR(string2, 10, (Object)this);
        AbstractTask abstractTask = (AbstractTask)this.taskTable.get(string);
        String string3 = string2 + "$" + this.taskCount++;
        while (this.reverseTaskNameLookup(string3) != null) {
            string3 = string2 + "$" + this.taskCount++;
        }
        String string4 = this.createNewTaskId();
        this.taskNames.put(string4, string3);
        AbstractTask abstractTask2 = null;
        switch (abstractTask.getType()) {
            case 0: {
                abstractTask2 = new PrimitiveTask((PrimitiveTask)abstractTask);
                break;
            }
            case 1: {
                abstractTask2 = new SummaryTask((SummaryTask)abstractTask);
                break;
            }
            case 2: {
                abstractTask2 = new ReteKB((ReteKB)abstractTask);
                break;
            }
            case 3: {
                abstractTask2 = new PlanScript((PlanScript)abstractTask);
            }
        }
        abstractTask2.setName(string4);
        this.taskTable.put(string4, abstractTask2);
        this.fireTaskChanged(abstractTask2, 0);
    }

    public Object[][] getTaskData() {
        Object[][] objectArray = new Object[this.taskTable.size()][3];
        Enumeration enumeration = this.taskTable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            AbstractTask abstractTask = (AbstractTask)enumeration.nextElement();
            objectArray[n][0] = this.getTaskName(abstractTask.getName());
            objectArray[n][1] = abstractTask.getTypeName();
            objectArray[n][2] = abstractTask.getName();
            ++n;
        }
        return objectArray;
    }

    public String getTaskName(String string) {
        return (String)this.taskNames.get(string);
    }

    public String[] getTaskIds() {
        String[] stringArray = new String[this.taskNames.size()];
        Enumeration enumeration = this.taskNames.keys();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[] getTaskNames() {
        String[] stringArray = new String[this.taskNames.size()];
        Enumeration enumeration = this.taskNames.elements();
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String reverseTaskNameLookup(String string) {
        Enumeration enumeration = this.taskNames.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.taskNames.get(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        return null;
    }

    public void renameTask(String string, String string2) {
        String string3 = string2;
        while (this.reverseTaskNameLookup(string2) != null) {
            string3 = string2 + this.taskIdCount++;
        }
        this.taskNames.put(string, string3);
        AbstractTask abstractTask = (AbstractTask)this.taskTable.get(string);
        this.fireTaskChanged(abstractTask, 1);
    }

    public boolean containsTask(String string) {
        return this.taskNames.containsKey(string);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.eventListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = GeneratorModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.eventListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = GeneratorModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void addAgentListener(AgentListener agentListener) {
        this.eventListeners.add(class$zeus$generator$event$AgentListener == null ? (class$zeus$generator$event$AgentListener = GeneratorModel.class$("zeus.generator.event.AgentListener")) : class$zeus$generator$event$AgentListener, agentListener);
    }

    public void removeAgentListener(AgentListener agentListener) {
        this.eventListeners.remove(class$zeus$generator$event$AgentListener == null ? (class$zeus$generator$event$AgentListener = GeneratorModel.class$("zeus.generator.event.AgentListener")) : class$zeus$generator$event$AgentListener, agentListener);
    }

    public void addTaskListener(TaskListener taskListener) {
        this.eventListeners.add(class$zeus$generator$event$TaskListener == null ? (class$zeus$generator$event$TaskListener = GeneratorModel.class$("zeus.generator.event.TaskListener")) : class$zeus$generator$event$TaskListener, taskListener);
    }

    public void removeTaskListener(TaskListener taskListener) {
        this.eventListeners.remove(class$zeus$generator$event$TaskListener == null ? (class$zeus$generator$event$TaskListener = GeneratorModel.class$("zeus.generator.event.TaskListener")) : class$zeus$generator$event$TaskListener, taskListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.eventListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? GeneratorModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    protected void fireAgentChanged(AgentDescription agentDescription, int n) {
        AgentChangeEvent agentChangeEvent = new AgentChangeEvent(this, agentDescription, n);
        Object[] objectArray = this.eventListeners.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$zeus$generator$event$AgentListener == null ? GeneratorModel.class$("zeus.generator.event.AgentListener") : class$zeus$generator$event$AgentListener)) {
                AgentListener agentListener = (AgentListener)objectArray[n2 + 1];
                agentListener.agentStateChanged(agentChangeEvent);
            }
            n2 -= 2;
        }
        this.fireChanged();
    }

    protected void fireTaskChanged(AbstractTask abstractTask, int n) {
        TaskChangeEvent taskChangeEvent = new TaskChangeEvent(this, abstractTask, n);
        Object[] objectArray = this.eventListeners.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$zeus$generator$event$TaskListener == null ? GeneratorModel.class$("zeus.generator.event.TaskListener") : class$zeus$generator$event$TaskListener)) {
                TaskListener taskListener = (TaskListener)objectArray[n2 + 1];
                taskListener.taskStateChanged(taskChangeEvent);
            }
            n2 -= 2;
        }
        this.fireChanged();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

