/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.generator.AgentGenerator;
import zeus.generator.AgentTableModel;
import zeus.generator.GeneratorModel;
import zeus.gui.MultipleSelectionDialog;
import zeus.gui.fields.NameField;
import zeus.util.Misc;

public class AgentTableUI
extends JPanel {
    protected JTable table;
    protected AgentTableModel model;
    protected AgentGenerator generator;
    static final String[] ERROR_MESSAGE = new String[]{"Please select a row before\ncalling this operation"};

    public AgentTableUI(AgentGenerator agentGenerator, GeneratorModel generatorModel) {
        this.generator = agentGenerator;
        this.model = new AgentTableModel(generatorModel);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12, new DefaultTableCellRenderer(), new DefaultCellEditor(new NameField()));
        tableColumn.setHeaderValue(this.model.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24, new AgentTableCellRenderer(), new AgentTableCellEditor(generatorModel));
        tableColumn.setHeaderValue(this.model.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.model, defaultTableColumnModel);
        this.setPreferredSize(new Dimension(240, 120));
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(new BevelBorder(1));
        this.table.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = AgentTableUI.this.table.rowAtPoint(mouseEvent.getPoint());
                if (n != -1 && AgentTableUI.this.table.isRowSelected(n) && mouseEvent.getClickCount() == 2) {
                    AgentTableUI.this.editAgent();
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
    }

    void errorMsg(int n) {
        JOptionPane.showMessageDialog(this, ERROR_MESSAGE[n], "Error", 0);
    }

    protected String getSelectedAgentName() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return null;
        }
        return (String)this.model.getValueAt(n, 0);
    }

    protected String getSelectedAgentId() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return null;
        }
        return (String)this.model.getValueAt(n, 2);
    }

    public void addNewAgent() {
        this.model.addNewRow();
    }

    public void editAgent() {
        String string = this.getSelectedAgentId();
        if (string == null) {
            return;
        }
        this.generator.editAgent(string);
    }

    public void removeAgent() {
        String string = this.getSelectedAgentId();
        if (string == null) {
            return;
        }
        this.generator.removeAgent(string);
    }

    public void cloneAgent() {
        String string = this.getSelectedAgentId();
        if (string == null) {
            return;
        }
        this.generator.cloneAgent(string);
    }

    public void renameAgent() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return;
        }
        this.model.setEditable(true);
        this.table.editCellAt(n, 0);
        this.model.setEditable(false);
    }

    public void modifyTaskList() {
        int n = this.table.getSelectedRow();
        if (n == -1) {
            this.errorMsg(0);
            return;
        }
        this.model.setEditable(true);
        this.table.editCellAt(n, 1);
        this.model.setEditable(false);
    }

    class AgentTableCellRenderer
    extends DefaultTableCellRenderer {
        AgentTableCellRenderer() {
        }

        public void setValue(Object object) {
            Object[] objectArray = (String[])object;
            String string = Misc.concat(objectArray);
            super.setValue(string);
        }
    }

    class AgentTableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        protected JButton button = new JButton("");
        protected GeneratorModel genmodel;
        protected int row;
        protected int column;
        protected MultipleSelectionDialog dialog;

        public AgentTableCellEditor(GeneratorModel generatorModel) {
            super(new JTextField());
            this.genmodel = generatorModel;
            this.setClickCountToStart(1);
            this.dialog = new MultipleSelectionDialog((Frame)SwingUtilities.getRoot(AgentTableUI.this.table), "Select Tasks");
            this.button.setBackground(Color.white);
            this.button.setBorderPainted(false);
            this.button.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.button) {
                this.dialog.setLocationRelativeTo(this.button);
                this.fireEditingCanceled();
                Object[] objectArray = this.dialog.getSelection();
                AgentTableUI.this.model.setValueAt(Misc.stringArray(objectArray), this.row, this.column);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            Object[] objectArray = this.genmodel.getTaskNames();
            this.dialog.setListData(objectArray);
            this.dialog.setSelection((String[])object);
            this.button.setText("Click to edit");
            return this.button;
        }
    }
}

