/*
 * Decompiled with CFR 0.152.
 */
package zeus.generator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import zeus.concepts.AbstractTask;
import zeus.concepts.AgentDescription;
import zeus.concepts.OntologyDb;
import zeus.generator.AgentTableUI;
import zeus.generator.FileHandler;
import zeus.generator.GeneratorModel;
import zeus.generator.SocietyEditor;
import zeus.generator.TaskTableUI;
import zeus.generator.agent.AgentEditor;
import zeus.generator.code.CodeGenerator;
import zeus.generator.code.GenerationPlan;
import zeus.generator.task.TaskEditor;
import zeus.gui.help.HelpWindow;
import zeus.ontology.OntologyEditor;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.SystemProps;

public class AgentGenerator
extends JFrame
implements ChangeListener,
ActionListener {
    protected FileHandler filer;
    protected CodeGenerator codeUI = null;
    protected File projectFile = null;
    protected boolean projectSaveNeeded = false;
    protected Hashtable agentEditorList = new Hashtable();
    protected Hashtable taskEditorList = new Hashtable();
    protected OntologyDb ontology;
    protected GeneratorModel genmodel;
    protected GenerationPlan genplan;
    protected OntologyEditor ontologyEditor = null;
    protected SocietyEditor societyEditor = null;
    protected JMenuBar mainMenuBar;
    protected JMenu menu1;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenuItem miGen;
    protected JMenuItem miExit;
    protected JMenu menu2;
    protected JMenuItem miNewOnt;
    protected JMenuItem miEditOnt;
    protected JMenuItem miLoadOnt;
    protected JMenuItem miSaveOnt;
    protected JMenu menu3;
    protected JMenuItem miAbout;
    protected JLabel projectInfoLabel;
    protected JLabel ontologyInfoLabel;
    static final String PROJECT_FILE_EXT = "*.def";
    static final String[] MESSAGE = new String[]{"Save file?", "Save needed", "File already exists.\nOverwrite saved file?", "Save file as", "Error", "Warning", "Agent is currently being edited.\nClose agent editor?", "Remove agent", "Are you sure?", "FREE SLOT", "Project: ", "Using ontology: ", "FREE SLOT", "FREE SLOT", "FREE SLOT", "FREE SLOT", "FREE SLOT", "FREE SLOT", "FREE SLOT", "ZEUS Agent Generator v1.1\nOriginal by BT Labs 1999-2001\n 1.2.2,1.2.1,1.2,1.1,1.04, 1.03b developed in the Zeus Open Source Community & The Intelligent Systems Lab (BT Exact)\nConsult the ZEUS Realisation Guide for instructions\n For more info on Zeus Open Source effort see http://www.sourceforge.net/projects/zeusagent\n For more on the IS Lab see http://www.labs.bt.com/projects/agents.htm", "About ZEUS", "No project loaded", "Task is currently being edited.\nClose task editor?", "Remove task", "Task is currently being edited.\nSave task?", "Clone Task", "Agent is currently being edited.\nSave agent?", "Clone Agent", " is currently being edited.\nSave agent?", " is currently being edited.\nSave task?", "New Project"};

    public AgentGenerator() {
        Object object;
        try {
            object = Class.forName("java.lang.Object");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Java cannot find java.lang.Object.\n This indicates that the rt.jar file is not in your classpath.\n Ensure that $java_install_dir\\jre\\rt.jar is present in the classpath and then continue");
            classNotFoundException.printStackTrace();
        }
        try {
            object = Class.forName("zeus.gui.help.HelpWindow");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("Java cannot find a zeus class.\n This indicates that the zeus.jar file is not in your classpath.\n Ensure that zeus_install_dir\\lib\\zeus.jar is present in the classpath and then continue");
            classNotFoundException.printStackTrace();
        }
        object = new GenSym("AgentGenerator");
        this.ontology = new OntologyDb((GenSym)object);
        this.genmodel = new GeneratorModel(this.ontology);
        this.genplan = new GenerationPlan(this.genmodel, this.ontology);
        this.filer = new FileHandler(this.ontology, this.genmodel, this.genplan);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "tool.gif");
        this.setIconImage(imageIcon.getImage());
        this.getContentPane().setBackground(Color.lightGray);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        this.genmodel.addChangeListener(this);
        this.genplan.addChangeListener(this);
        jPanel.setBackground(Color.lightGray);
        CompoundBorder compoundBorder = new CompoundBorder(new BevelBorder(1), new EmptyBorder(15, 15, 15, 15));
        jPanel.setBorder(compoundBorder);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 8);
        JLabel jLabel = new JLabel(new ImageIcon(string2 + "zeus.gif"));
        jLabel.setBorder(new BevelBorder(0));
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        JPanel jPanel2 = new JPanel();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel4 = new JPanel();
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        jPanel.add(jPanel5);
        jPanel2.setBackground(Color.lightGray);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Project Options");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel2.setBorder(titledBorder);
        JToolBar jToolBar = new ProjectToolBar();
        this.projectInfoLabel = new JLabel();
        this.projectInfoLabel.setFont(new Font("Helvetica", 1, 12));
        this.projectInfoLabel.setText(MESSAGE[21]);
        gridBagLayout = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jToolBar, gridBagConstraints);
        jPanel2.add(jToolBar);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagLayout.setConstraints(this.projectInfoLabel, gridBagConstraints);
        jPanel2.add(this.projectInfoLabel);
        jPanel3.setBackground(Color.lightGray);
        titledBorder = BorderFactory.createTitledBorder("Ontology Options");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel3.setBorder(titledBorder);
        jToolBar = new OntologyToolBar();
        this.ontologyInfoLabel = new JLabel();
        this.ontologyInfoLabel.setText(MESSAGE[16]);
        this.ontologyInfoLabel.setFont(new Font("Helvetica", 1, 12));
        gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        gridBagLayout.setConstraints(jToolBar, gridBagConstraints);
        jPanel3.add(jToolBar);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagLayout.setConstraints(this.ontologyInfoLabel, gridBagConstraints);
        jPanel3.add(this.ontologyInfoLabel);
        jPanel4.setBackground(Color.lightGray);
        titledBorder = BorderFactory.createTitledBorder("Agent Options");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel4.setBorder(titledBorder);
        AgentTableUI agentTableUI = new AgentTableUI(this, this.genmodel);
        jToolBar = new AgentToolBar(agentTableUI);
        gridBagLayout = new GridBagLayout();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        gridBagLayout.setConstraints(jToolBar, gridBagConstraints);
        jPanel4.add(jToolBar);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagLayout.setConstraints(agentTableUI, gridBagConstraints);
        jPanel4.add(agentTableUI);
        jPanel5.setBackground(Color.lightGray);
        titledBorder = BorderFactory.createTitledBorder("Task Options");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        titledBorder.setTitleColor(Color.blue);
        jPanel5.setBorder(titledBorder);
        TaskTableUI taskTableUI = new TaskTableUI(this, this.genmodel);
        jToolBar = new TaskToolBar(taskTableUI);
        gridBagLayout = new GridBagLayout();
        jPanel5.setLayout(gridBagLayout);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 8, 0);
        gridBagLayout.setConstraints(jToolBar, gridBagConstraints);
        jPanel5.add(jToolBar);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 8, 4, 8);
        gridBagLayout.setConstraints(taskTableUI, gridBagConstraints);
        jPanel5.add(taskTableUI);
        this.ontologyEditor = new OntologyEditor(this.ontology, this, this.genmodel, this.ontologyInfoLabel);
        this.setTitle("ZEUS Agent Generator " + SystemProps.getProperty("version.id"));
        this.initMenus();
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        this.setDefaultCloseOperation(0);
        this.setBackground(Color.lightGray);
        this.setVisible(true);
        this.pack();
    }

    protected void initMenus() {
        this.mainMenuBar = new JMenuBar();
        this.menu1 = new JMenu("Project");
        this.miNew = new JMenuItem("New Project");
        this.miNew.addActionListener(this);
        this.menu1.add(this.miNew);
        this.miOpen = new JMenuItem("Load Project...");
        this.miOpen.addActionListener(this);
        this.menu1.add(this.miOpen);
        this.miSave = new JMenuItem("Save Project...");
        this.miSave.addActionListener(this);
        this.menu1.add(this.miSave);
        this.miSaveAs = new JMenuItem("Save Project As...");
        this.miSaveAs.addActionListener(this);
        this.menu1.add(this.miSaveAs);
        this.menu1.addSeparator();
        this.miGen = new JMenuItem("Generate Code");
        this.miGen.addActionListener(this);
        this.menu1.add(this.miGen);
        this.menu1.addSeparator();
        this.miExit = new JMenuItem("Exit");
        this.miExit.addActionListener(this);
        this.menu1.add(this.miExit);
        this.mainMenuBar.add(this.menu1);
        this.menu2 = new JMenu("Ontology");
        this.miNewOnt = new JMenuItem("New Ontology");
        this.miNewOnt.addActionListener(this);
        this.menu2.add(this.miNewOnt);
        this.miLoadOnt = new JMenuItem("Load Ontology");
        this.miLoadOnt.addActionListener(this);
        this.menu2.add(this.miLoadOnt);
        this.miSaveOnt = new JMenuItem("Save Ontology");
        this.miSaveOnt.addActionListener(this);
        this.menu2.add(this.miSaveOnt);
        this.miEditOnt = new JMenuItem("Edit Ontology");
        this.miEditOnt.addActionListener(this);
        this.menu2.add(this.miEditOnt);
        this.mainMenuBar.add(this.menu2);
        this.menu3 = new JMenu("Help");
        this.miAbout = new JMenuItem("About..");
        this.miAbout.addActionListener(this);
        this.menu3.add(this.miAbout);
        this.mainMenuBar.add(this.menu3);
        this.setJMenuBar(this.mainMenuBar);
    }

    public boolean openFile(File file) {
        Assert.notNull(file);
        Frame frame = (Frame)SwingUtilities.getRoot(this);
        Cursor cursor = frame.getCursor();
        frame.setCursor(new Cursor(3));
        int n = this.filer.openFile(file);
        frame.setCursor(cursor);
        if ((n & 2) != 0) {
            JOptionPane.showMessageDialog(this, this.filer.getError(), MESSAGE[4], 0);
            this.projectSaveNeeded = false;
            return this.newProject();
        }
        if ((n & 1) != 0) {
            JOptionPane.showMessageDialog(this, this.filer.getWarning(), MESSAGE[5], 2);
            this.projectSaveNeeded = true;
        } else {
            this.projectSaveNeeded = false;
        }
        this.projectFile = file;
        this.projectInfoLabel.setText(MESSAGE[10] + file.getName());
        this.ontologyInfoLabel.setText(MESSAGE[11] + this.ontology.getFilename());
        return true;
    }

    public boolean saveFile(File file) {
        Assert.notNull(file);
        Frame frame = (Frame)SwingUtilities.getRoot(this);
        Cursor cursor = frame.getCursor();
        frame.setCursor(new Cursor(3));
        if (!this.ontologyEditor.Save()) {
            frame.setCursor(cursor);
            return false;
        }
        int n = this.filer.saveFile(file);
        frame.setCursor(cursor);
        if ((n & 2) != 0) {
            JOptionPane.showMessageDialog(this, this.filer.getError(), MESSAGE[4], 0);
            return false;
        }
        if ((n & 1) != 0) {
            JOptionPane.showMessageDialog(this, this.filer.getWarning(), MESSAGE[5], 2);
        }
        this.projectInfoLabel.setText(MESSAGE[10] + file.getName());
        this.projectSaveNeeded = false;
        this.projectFile = file;
        return true;
    }

    protected void resetProject() {
        JFrame jFrame;
        this.genmodel.clear();
        this.genplan.reset();
        this.ontologyEditor.closeFile();
        this.projectFile = null;
        this.projectInfoLabel.setText(MESSAGE[21]);
        this.projectSaveNeeded = false;
        Enumeration enumeration = this.agentEditorList.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (JFrame)enumeration.nextElement();
            jFrame.dispose();
        }
        this.agentEditorList.clear();
        enumeration = this.taskEditorList.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (JFrame)enumeration.nextElement();
            jFrame.dispose();
        }
        this.taskEditorList.clear();
    }

    public void loadProject() {
        if (!this.newProject()) {
            return;
        }
        File file = this.getFile(0, this.projectFile, PROJECT_FILE_EXT);
        if (file != null) {
            this.openFile(file);
        }
    }

    protected boolean editorsHaveChanged() {
        JFrame jFrame;
        Enumeration enumeration = this.agentEditorList.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (AgentEditor)enumeration.nextElement();
            if (!((AgentEditor)jFrame).hasChanged()) continue;
            return true;
        }
        enumeration = this.taskEditorList.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (TaskEditor)enumeration.nextElement();
            if (!((TaskEditor)jFrame).hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean saveProject() {
        int n;
        JFrame jFrame;
        Enumeration enumeration = this.agentEditorList.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (AgentEditor)enumeration.nextElement();
            if (!((AgentEditor)jFrame).hasChanged()) continue;
            n = JOptionPane.showConfirmDialog(this, "Agent " + ((AgentEditor)jFrame).getObjectName() + MESSAGE[28], MESSAGE[30], 1);
            if (n == 0) {
                ((AgentEditor)jFrame).save();
                continue;
            }
            if (n != 2) continue;
            return false;
        }
        enumeration = this.taskEditorList.elements();
        while (enumeration.hasMoreElements()) {
            jFrame = (TaskEditor)enumeration.nextElement();
            if (!((TaskEditor)jFrame).hasChanged()) continue;
            n = JOptionPane.showConfirmDialog(this, "Task " + ((TaskEditor)jFrame).getObjectName() + MESSAGE[29], MESSAGE[30], 1);
            if (n == 0) {
                ((TaskEditor)jFrame).save();
                continue;
            }
            if (n != 2) continue;
            return false;
        }
        if (this.projectFile == null) {
            return this.saveProjectAs();
        }
        return this.saveFile(this.projectFile);
    }

    protected boolean saveProjectAs() {
        File file = this.getFile(1, this.projectFile, PROJECT_FILE_EXT);
        if (file != null) {
            int n;
            if (file.exists() && this.projectFile != null && !file.equals(this.projectFile) && (n = JOptionPane.showConfirmDialog(this, MESSAGE[2], MESSAGE[3], 0)) == 1) {
                return false;
            }
            return this.saveFile(file);
        }
        return false;
    }

    protected boolean newProject() {
        if (this.projectSaveNeeded || this.editorsHaveChanged()) {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[0], MESSAGE[1], 1);
            if (n == 0 && !this.saveProject()) {
                return false;
            }
            if (n == 2) {
                return false;
            }
        }
        this.resetProject();
        return true;
    }

    public void generateCode() {
        if (this.codeUI == null) {
            this.codeUI = new CodeGenerator(this.genmodel, this.genplan, true);
        }
        if (this.codeUI.isShowing()) {
            this.codeUI.toFront();
        } else {
            this.codeUI.setVisible(true);
        }
    }

    public void showSociety() {
        if (this.societyEditor == null) {
            this.societyEditor = new SocietyEditor(this, this.genmodel);
        }
        if (this.societyEditor.isShowing()) {
            this.societyEditor.toFront();
        } else {
            this.societyEditor.setVisible(true);
        }
    }

    public void exitGenerator() {
        if (!this.newProject()) {
            return;
        }
        this.dispose();
        if (this.codeUI != null) {
            this.codeUI.dispose();
        }
        if (this.societyEditor != null) {
            this.societyEditor.dispose();
        }
        System.exit(0);
    }

    public boolean newOntology() {
        return this.ontologyEditor.Close();
    }

    public void loadOntology() {
        this.ontologyEditor.Open();
    }

    public boolean saveOntology() {
        return this.ontologyEditor.Save();
    }

    public void editOntology() {
        this.ontologyEditor.showFrame();
    }

    public void about() {
        JOptionPane.showMessageDialog(this, MESSAGE[19], MESSAGE[20], 1);
    }

    public void editAgent(String string) {
        if (this.agentEditorList.containsKey(string)) {
            AgentEditor agentEditor = (AgentEditor)this.agentEditorList.get(string);
            agentEditor.toFront();
        } else {
            AgentDescription agentDescription = this.genmodel.getAgent(string);
            AgentEditor agentEditor = new AgentEditor(this, this.genmodel, this.ontology, agentDescription);
            this.agentEditorList.put(string, agentEditor);
            agentEditor.show();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeAgent(String string) {
        if (this.agentEditorList.containsKey(string)) {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[6], MESSAGE[7], 1);
            if (n != 0) return;
            AgentEditor agentEditor = (AgentEditor)this.agentEditorList.get(string);
            agentEditor.dispose();
            this.genmodel.removeAgent(string);
            return;
        } else {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[8], MESSAGE[7], 1);
            if (n != 0) return;
            this.genmodel.removeAgent(string);
        }
    }

    public void cloneAgent(String string) {
        if (this.agentEditorList.containsKey(string)) {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[26], MESSAGE[27], 1);
            if (n == 0) {
                AgentEditor agentEditor = (AgentEditor)this.agentEditorList.get(string);
                agentEditor.save();
            } else if (n == 2) {
                return;
            }
        }
        this.genmodel.cloneAgent(string);
    }

    public void agentEditorClosed(String string) {
        this.agentEditorList.remove(string);
    }

    public void editTask(String string) {
        if (this.taskEditorList.containsKey(string)) {
            TaskEditor taskEditor = (TaskEditor)this.taskEditorList.get(string);
            taskEditor.toFront();
        } else {
            AbstractTask abstractTask = this.genmodel.getTask(string);
            TaskEditor taskEditor = new TaskEditor(this, this.genmodel, this.ontology, abstractTask);
            this.taskEditorList.put(string, taskEditor);
            taskEditor.show();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeTask(String string) {
        if (this.taskEditorList.containsKey(string)) {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[22], MESSAGE[23], 1);
            if (n != 0) return;
            TaskEditor taskEditor = (TaskEditor)this.taskEditorList.get(string);
            taskEditor.dispose();
            this.genmodel.removeTask(string);
            return;
        } else {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[8], MESSAGE[23], 1);
            if (n != 0) return;
            this.genmodel.removeTask(string);
        }
    }

    public void cloneTask(String string) {
        if (this.taskEditorList.containsKey(string)) {
            int n = JOptionPane.showConfirmDialog(this, MESSAGE[24], MESSAGE[25], 1);
            if (n == 0) {
                TaskEditor taskEditor = (TaskEditor)this.taskEditorList.get(string);
                taskEditor.save();
            } else if (n == 2) {
                return;
            }
        }
        this.genmodel.cloneTask(string);
    }

    public void taskEditorClosed(String string) {
        this.taskEditorList.remove(string);
    }

    protected File getFile(int n, File file, String string) {
        FileDialog fileDialog = new FileDialog((Frame)this, "AgentGenerator: Select File", n);
        if (file != null) {
            fileDialog.setFile(file.getName());
            fileDialog.setDirectory(file.getParent());
        } else {
            fileDialog.setFile(string);
        }
        fileDialog.pack();
        fileDialog.setVisible(true);
        return fileDialog.getFile() == null ? null : new File(fileDialog.getDirectory(), fileDialog.getFile());
    }

    protected static void usage() {
        System.err.println("Usage: java AgentGenerator [-f <file>] [-h] [-v]");
        System.exit(0);
    }

    protected static void version() {
        System.err.println("Zeus Agent Generator version: " + SystemProps.getProperty("version.id"));
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-f") && ++n < stringArray.length) {
                string = stringArray[n];
            } else if (stringArray[n].equals("-h")) {
                AgentGenerator.usage();
            } else if (stringArray[n].equals("-v")) {
                AgentGenerator.version();
            } else {
                AgentGenerator.usage();
            }
            ++n;
        }
        AgentGenerator agentGenerator = new AgentGenerator();
        if (string != null) {
            String string2 = System.getProperty("user.dir") + System.getProperty("file.separator");
            agentGenerator.openFile(new File(string2 + string));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.projectSaveNeeded = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.miNew) {
            this.newProject();
        } else if (object == this.miOpen) {
            this.loadProject();
        } else if (object == this.miSave) {
            this.saveProject();
        } else if (object == this.miSaveAs) {
            this.saveProjectAs();
        } else if (object == this.miGen) {
            this.generateCode();
        } else if (object == this.miExit) {
            this.exitGenerator();
        } else if (object == this.miNewOnt) {
            this.newOntology();
        } else if (object == this.miLoadOnt) {
            this.loadOntology();
        } else if (object == this.miSaveOnt) {
            this.saveOntology();
        } else if (object == this.miEditOnt) {
            this.editOntology();
        } else if (object == this.miAbout) {
            this.about();
        }
        this.repaint();
    }

    class TaskToolBar
    extends JToolBar
    implements ActionListener {
        protected JButton newBtn;
        protected JButton editBtn;
        protected JButton cloneBtn;
        protected JButton deleteBtn;
        protected JButton renameBtn;
        protected JToggleButton helpBtn;
        protected HelpWindow helpWin;
        protected TaskTableUI taskTable;
        protected JPopupMenu popup;
        protected JMenuItem primitiveMenuItem;
        protected JMenuItem summaryMenuItem;
        protected JMenuItem behaviourMenuItem;
        protected JMenuItem scriptMenuItem;

        public TaskToolBar(TaskTableUI taskTableUI) {
            this.taskTable = taskTableUI;
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new.gif"));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("Create new task");
            this.newBtn.addActionListener(this);
            this.renameBtn = new JButton(new ImageIcon(string2 + "rename.gif"));
            this.add(this.renameBtn);
            this.renameBtn.setToolTipText("Rename task");
            this.renameBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete.gif"));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete this task");
            this.deleteBtn.addActionListener(this);
            this.cloneBtn = new JButton(new ImageIcon(string2 + "clone.gif"));
            this.add(this.cloneBtn);
            this.cloneBtn.setToolTipText("Clone this task");
            this.cloneBtn.addActionListener(this);
            this.addSeparator();
            this.editBtn = new JButton(new ImageIcon(string2 + "edit.gif"));
            this.add(this.editBtn);
            this.editBtn.setToolTipText("Edit this task");
            this.editBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "info.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.popup = new JPopupMenu();
            this.popup.add(new JLabel("Task Type"));
            this.popup.addSeparator();
            this.primitiveMenuItem = new JMenuItem(AbstractTask.getTypeName(0));
            this.primitiveMenuItem.addActionListener(this);
            this.popup.add(this.primitiveMenuItem);
            this.summaryMenuItem = new JMenuItem(AbstractTask.getTypeName(1));
            this.summaryMenuItem.addActionListener(this);
            this.popup.add(this.summaryMenuItem);
            this.behaviourMenuItem = new JMenuItem(AbstractTask.getTypeName(2));
            this.behaviourMenuItem.addActionListener(this);
            this.popup.add(this.behaviourMenuItem);
            this.scriptMenuItem = new JMenuItem(AbstractTask.getTypeName(3));
            this.scriptMenuItem.addActionListener(this);
            this.popup.add(this.scriptMenuItem);
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
            this.popup.setBorder(compoundBorder);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.popup.pack();
                this.popup.show(this.newBtn, 0, 0);
            } else if (object == this.primitiveMenuItem) {
                this.taskTable.addNewTask(0);
            } else if (object == this.summaryMenuItem) {
                this.taskTable.addNewTask(1);
            } else if (object == this.behaviourMenuItem) {
                this.taskTable.addNewTask(2);
            } else if (object == this.scriptMenuItem) {
                this.taskTable.addNewTask(3);
            } else if (object == this.editBtn) {
                this.taskTable.editTask();
            } else if (object == this.deleteBtn) {
                this.taskTable.removeTask();
            } else if (object == this.cloneBtn) {
                this.taskTable.cloneTask();
            } else if (object == this.renameBtn) {
                this.taskTable.renameTask();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Task Options");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class AgentToolBar
    extends JToolBar
    implements ActionListener {
        protected JButton newBtn;
        protected JButton editBtn;
        protected JButton deleteBtn;
        protected JButton cloneBtn;
        protected JButton renameBtn;
        protected JToggleButton helpBtn;
        protected HelpWindow helpWin;
        protected AgentTableUI agentTable;
        protected JPopupMenu popup;
        protected JMenuItem renameAgentMenuItem;
        protected JMenuItem modifyTaskListMenuItem;

        public AgentToolBar(AgentTableUI agentTableUI) {
            this.agentTable = agentTableUI;
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new.gif"));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("Create new agent");
            this.newBtn.addActionListener(this);
            this.renameBtn = new JButton(new ImageIcon(string2 + "rename.gif"));
            this.add(this.renameBtn);
            this.renameBtn.setToolTipText("Modify this agent's name or its task list");
            this.renameBtn.addActionListener(this);
            this.deleteBtn = new JButton(new ImageIcon(string2 + "delete.gif"));
            this.add(this.deleteBtn);
            this.deleteBtn.setToolTipText("Delete this agent");
            this.deleteBtn.addActionListener(this);
            this.cloneBtn = new JButton(new ImageIcon(string2 + "clone.gif"));
            this.add(this.cloneBtn);
            this.cloneBtn.setToolTipText("Clone this agent");
            this.cloneBtn.addActionListener(this);
            this.addSeparator();
            this.editBtn = new JButton(new ImageIcon(string2 + "edit.gif"));
            this.add(this.editBtn);
            this.editBtn.setToolTipText("Edit this agent");
            this.editBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "info.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
            this.popup = new JPopupMenu();
            this.popup.add(new JLabel("Modify"));
            this.popup.addSeparator();
            this.renameAgentMenuItem = new JMenuItem("Rename agent");
            this.renameAgentMenuItem.addActionListener(this);
            this.popup.add(this.renameAgentMenuItem);
            this.modifyTaskListMenuItem = new JMenuItem("Modify task list");
            this.modifyTaskListMenuItem.addActionListener(this);
            this.popup.add(this.modifyTaskListMenuItem);
            CompoundBorder compoundBorder = new CompoundBorder(new EtchedBorder(), new EmptyBorder(5, 5, 5, 5));
            this.popup.setBorder(compoundBorder);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                this.agentTable.addNewAgent();
            } else if (object == this.editBtn) {
                this.agentTable.editAgent();
            } else if (object == this.deleteBtn) {
                this.agentTable.removeAgent();
            } else if (object == this.cloneBtn) {
                this.agentTable.cloneAgent();
            } else if (object == this.renameBtn) {
                this.popup.pack();
                this.popup.show(this.renameBtn, 0, 0);
            } else if (object == this.renameAgentMenuItem) {
                this.agentTable.renameAgent();
            } else if (object == this.modifyTaskListMenuItem) {
                this.agentTable.modifyTaskList();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Agent Options");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class OntologyToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JButton newBtn;
        protected JButton loadBtn;
        protected JButton editBtn;
        protected JButton saveBtn;
        protected JToggleButton helpBtn;

        public OntologyToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new.gif"));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("Create New Ontology");
            this.newBtn.addActionListener(this);
            this.loadBtn = new JButton(new ImageIcon(string2 + "load.gif"));
            this.add(this.loadBtn);
            this.loadBtn.setToolTipText("Load Existing Ontology");
            this.loadBtn.addActionListener(this);
            this.saveBtn = new JButton(new ImageIcon(string2 + "savedisk.gif"));
            this.add(this.saveBtn);
            this.saveBtn.setToolTipText("Save current Ontology to disk");
            this.saveBtn.addActionListener(this);
            this.addSeparator();
            this.editBtn = new JButton(new ImageIcon(string2 + "edit.gif"));
            this.add(this.editBtn);
            this.editBtn.setToolTipText("Edit Current Ontology");
            this.editBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "info.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                AgentGenerator.this.newOntology();
            } else if (object == this.loadBtn) {
                AgentGenerator.this.loadOntology();
            } else if (object == this.editBtn) {
                AgentGenerator.this.editOntology();
            } else if (object == this.saveBtn) {
                AgentGenerator.this.saveOntology();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Ontology Options");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class ProjectToolBar
    extends JToolBar
    implements ActionListener {
        protected HelpWindow helpWin;
        protected JButton newBtn;
        protected JButton loadBtn;
        protected JButton saveBtn;
        protected JButton viewBtn;
        protected JButton genBtn;
        protected JToggleButton helpBtn;

        public ProjectToolBar() {
            this.setBackground(Color.lightGray);
            this.setBorder(new BevelBorder(1));
            this.setFloatable(false);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "generator" + string;
            this.newBtn = new JButton(new ImageIcon(string2 + "new.gif"));
            this.add(this.newBtn);
            this.newBtn.setToolTipText("Create New Project");
            this.newBtn.addActionListener(this);
            this.loadBtn = new JButton(new ImageIcon(string2 + "load.gif"));
            this.add(this.loadBtn);
            this.loadBtn.setToolTipText("Load Existing Project");
            this.loadBtn.addActionListener(this);
            this.saveBtn = new JButton(new ImageIcon(string2 + "savedisk.gif"));
            this.add(this.saveBtn);
            this.saveBtn.setToolTipText("Save current Project to disk");
            this.saveBtn.addActionListener(this);
            this.addSeparator();
            this.viewBtn = new JButton(new ImageIcon(string2 + "view.gif"));
            this.add(this.viewBtn);
            this.viewBtn.setToolTipText("View Agent Society");
            this.viewBtn.addActionListener(this);
            this.addSeparator();
            this.genBtn = new JButton(new ImageIcon(string2 + "code.gif"));
            this.add(this.genBtn);
            this.genBtn.setToolTipText("Generate Agent Code");
            this.genBtn.addActionListener(this);
            this.addSeparator();
            this.helpBtn = new JToggleButton(new ImageIcon(string2 + "info.gif"));
            this.helpBtn.setMargin(new Insets(0, 0, 0, 0));
            this.add(this.helpBtn);
            this.helpBtn.setToolTipText("Help");
            this.helpBtn.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.newBtn) {
                AgentGenerator.this.newProject();
            } else if (object == this.loadBtn) {
                AgentGenerator.this.loadProject();
            } else if (object == this.saveBtn) {
                AgentGenerator.this.saveProject();
            } else if (object == this.viewBtn) {
                AgentGenerator.this.showSociety();
            } else if (object == this.genBtn) {
                AgentGenerator.this.generateCode();
            } else if (object == this.helpBtn) {
                if (this.helpBtn.isSelected()) {
                    Point point = this.getLocation();
                    this.helpWin = new HelpWindow(SwingUtilities.getRoot(this), point, "generator", "Project Options");
                    this.helpWin.setSource(this.helpBtn);
                } else {
                    this.helpWin.dispose();
                }
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            AgentGenerator.this.exitGenerator();
        }
    }
}

