/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.IdFn;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.Misc;

public abstract class ValueFunction {
    static final int ID_MIN = 0;
    static final int ID_MAX = 23;
    public static final int CONSB = 0;
    public static final int LVAR = 1;
    public static final int ID = 2;
    public static final int TYPE = 3;
    public static final int FIELD = 4;
    public static final int AND = 5;
    public static final int OR = 6;
    public static final int CONS = 7;
    public static final int IMPLY = 8;
    public static final int ELSE = 9;
    public static final int LOR = 10;
    public static final int LAND = 11;
    public static final int LNOT = 12;
    public static final int COMP = 13;
    public static final int INT = 14;
    public static final int REAL = 15;
    public static final int DATE = 16;
    public static final int TIME = 17;
    public static final int BOOL = 18;
    public static final int ARITH = 19;
    public static final int FACT = 20;
    public static final int FUNC = 21;
    public static final int METH = 22;
    public static final int VECT = 23;
    static final int PD_MIN = 0;
    static final int PD_MAX = 10;
    protected int type = -1;
    protected int precedence = -1;
    static final String[] METHOD_LIST = new String[]{"isDeterminate", "0", "toString", "0"};
    static final int IS_DETERMINATE = 0;
    static final int TO_STRING = 2;

    public ValueFunction(int n, int n2) {
        Assert.notFalse(n >= 0 && n <= 23);
        Assert.notFalse(n2 >= 0 && n2 <= 10);
        this.type = n;
        this.precedence = n2;
    }

    public final int getID() {
        return this.type;
    }

    public final int getPD() {
        return this.precedence;
    }

    public abstract boolean isDeterminate();

    public abstract boolean references(ValueFunction var1);

    public final ValueFunction unifiesWith(ValueFunction valueFunction, Bindings bindings) {
        ValueFunction valueFunction2;
        ValueFunction valueFunction3 = this.resolve(bindings);
        ValueFunction valueFunction4 = valueFunction.resolve(bindings);
        if (valueFunction3 == null || valueFunction4 == null) {
            return null;
        }
        if ((valueFunction3 = valueFunction3.normalize()).equals(valueFunction4 = valueFunction4.normalize())) {
            return valueFunction4;
        }
        ValueFunction valueFunction5 = valueFunction2 = valueFunction4.getPD() < valueFunction3.getPD() ? valueFunction4.unify(valueFunction3, bindings) : valueFunction3.unify(valueFunction4, bindings);
        if (valueFunction2 == null) {
            return null;
        }
        valueFunction2 = valueFunction2.simplify();
        bindings.set(valueFunction3, valueFunction2);
        bindings.set(valueFunction4, valueFunction2);
        return valueFunction2;
    }

    public ValueFunction resolve(Bindings bindings) {
        return this.resolve(new ResolutionContext(), bindings);
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        return bindings.lookUp(this);
    }

    public Vector variables() {
        return new Vector();
    }

    public ValueFunction duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return this;
    }

    public ValueFunction evaluationFn() {
        return this;
    }

    public int baseID() {
        return this.type;
    }

    abstract Object getArg(int var1);

    abstract ValueFunction unify(ValueFunction var1, Bindings var2);

    public abstract ValueFunction mirror();

    ValueFunction normalize() {
        return this;
    }

    ValueFunction simplify() {
        return this;
    }

    final Object getArg() {
        return this.getArg(0);
    }

    ValueFunction invokeMethod(String string, Vector vector) {
        int n = Misc.whichPosition(string, METHOD_LIST);
        if (n != -1) {
            int n2 = Integer.parseInt(METHOD_LIST[n + 1]);
            if (vector.size() != n2) {
                throw new IllegalArgumentException("Wrong number of arguments in method '" + string + "/" + n2 + "'.");
            }
        } else {
            throw new IllegalArgumentException("Unknown method '" + string + "' invoked on '" + this + "'");
        }
        switch (n) {
            case 0: {
                return this.isDeterminate() ? BoolFn.trueFn : BoolFn.falseFn;
            }
            case 2: {
                return new IdFn(this.toString());
            }
        }
        throw new IllegalArgumentException("Unknown method '" + string + "' invoked on '" + this + "'");
    }
}

