/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class OrFn
extends ValueFunction {
    protected ValueFunction[] args = new ValueFunction[2];

    public OrFn(ValueFunction valueFunction, ValueFunction valueFunction2) {
        super(6, 6);
        this.args[0] = valueFunction;
        this.args[1] = valueFunction2;
    }

    public String toString() {
        String string = "(" + this.args[0] + "|" + this.args[1] + ")";
        return string;
    }

    ValueFunction simplify() {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        this.expand(vector, hashtable);
        Misc.sort(vector);
        return this.concatenate(vector, hashtable);
    }

    protected ValueFunction concatenate(Vector vector, Hashtable hashtable) {
        return this.concatenate(vector, 0, hashtable);
    }

    protected ValueFunction concatenate(Vector vector, int n, Hashtable hashtable) {
        if (n + 1 == vector.size()) {
            return (ValueFunction)hashtable.get(vector.elementAt(n));
        }
        if (n + 2 == vector.size()) {
            return new OrFn((ValueFunction)hashtable.get(vector.elementAt(n)), (ValueFunction)hashtable.get(vector.elementAt(n + 1)));
        }
        return new OrFn((ValueFunction)hashtable.get(vector.elementAt(n)), this.concatenate(vector, n + 1, hashtable));
    }

    protected void expand(Vector vector, Hashtable hashtable) {
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].getID() == 6) {
                ((OrFn)this.args[n]).expand(vector, hashtable);
            } else {
                ValueFunction valueFunction = this.args[n].simplify();
                String string = valueFunction.toString();
                if (!vector.contains(string)) {
                    vector.addElement(string);
                    hashtable.put(string, valueFunction);
                }
            }
            ++n;
        }
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean references(ValueFunction valueFunction) {
        return this.args[0].references(valueFunction) || this.args[1].references(valueFunction);
    }

    public Vector variables() {
        return Misc.union(this.args[0].variables(), this.args[1].variables());
    }

    public boolean isDeterminate() {
        return this.args[0].isDeterminate() && this.args[1].isDeterminate();
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new OrFn(this.args[0].duplicate(duplicationTable), this.args[1].duplicate(duplicationTable));
    }

    ValueFunction normalize() {
        return new OrFn(this.args[0].normalize(), this.args[1].normalize());
    }

    public ValueFunction mirror() {
        return new OrFn(this.args[0].mirror(), this.args[1].mirror());
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.args[0].resolve(resolutionContext, bindings);
        ValueFunction valueFunction2 = this.args[1].resolve(resolutionContext, bindings);
        return new OrFn(valueFunction, valueFunction2).evaluationFn();
    }

    public boolean equals(Object object) {
        if (!(object instanceof OrFn)) {
            return false;
        }
        OrFn orFn = (OrFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = orFn.simplify();
        return ((ValueFunction)valueFunction.getArg(0)).equals((ValueFunction)valueFunction2.getArg(0)) && ((ValueFunction)valueFunction.getArg(1)).equals((ValueFunction)valueFunction2.getArg(1));
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        ValueFunction valueFunction2 = null;
        ValueFunction valueFunction3 = null;
        valueFunction2 = this.args[0].unifiesWith(valueFunction, bindings);
        if (valueFunction2 != null) {
            valueFunction3 = this.args[1].unifiesWith(valueFunction, bindings);
            if (valueFunction3 != null) {
                if (valueFunction2.equals(valueFunction3)) {
                    return valueFunction2;
                }
                return new OrFn(valueFunction2, valueFunction3);
            }
            return valueFunction2;
        }
        valueFunction3 = this.args[1].unifiesWith(valueFunction, bindings);
        if (valueFunction3 != null) {
            return valueFunction3;
        }
        return null;
    }

    public int baseID() {
        int n;
        int n2 = this.args[0].baseID();
        if (n2 != (n = this.args[1].baseID())) {
            throw new IllegalArgumentException("Incompatible types in " + this);
        }
        return n2;
    }
}

