/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.StringTokenizer;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.fn.BoolFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.PrimitiveFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Core;
import zeus.util.Misc;

public class IdFn
extends ValueFunction
implements PrimitiveFn {
    protected String arg = null;
    static final String[] METHOD_LIST = new String[]{"charAt", "1", "compareTo", "1", "compareToIgnoreCase", "1", "concat", "1", "endsWith", "1", "equals", "1", "equalsIgnoreCase", "1", "indexOf", "1,2", "lastIndexOf", "1,2", "length", "0", "regionMatches", "4,5", "replace", "2", "startsWith", "1,2", "substring", "1,2", "toLowerCase", "0", "toUpperCase", "0", "trim", "0"};
    static final int CHAR_AT = 0;
    static final int COMPARE_TO = 2;
    static final int COMPARE_TO_IGNORE_CASE = 4;
    static final int CONCAT = 6;
    static final int ENDS_WITH = 8;
    static final int EQUALS = 10;
    static final int EQUALS_IGNORE_CASE = 12;
    static final int INDEX_OF = 14;
    static final int LAST_INDEX_OF = 16;
    static final int LENGTH = 18;
    static final int REGION_MATCHES = 20;
    static final int REPLACE = 22;
    static final int STARTS_WITH = 24;
    static final int SUBSTRING = 26;
    static final int TO_LOWER_CASE = 28;
    static final int TO_UPPER_CASE = 30;
    static final int TRIM = 32;

    public IdFn(String string) {
        super(2, 10);
        this.arg = string;
    }

    public ValueFunction mirror() {
        return new IdFn(this.arg);
    }

    public String toString() {
        char[] cArray = this.arg.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (!Character.isLetterOrDigit(cArray[n]) && cArray[n] != '_' && cArray[n] != '$') {
                return "\"" + this.arg + "\"";
            }
            ++n;
        }
        return this.arg;
    }

    Object getArg(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return Misc.literalToString(this.arg);
    }

    public boolean isDeterminate() {
        return true;
    }

    public String getValue() {
        return Misc.literalToString(this.arg);
    }

    public boolean equals(Object object) {
        if (!(object instanceof IdFn)) {
            return false;
        }
        IdFn idFn = (IdFn)object;
        return this.arg.equals(idFn.getArg());
    }

    public boolean less(Object object) {
        if (!(object instanceof IdFn)) {
            return false;
        }
        IdFn idFn = (IdFn)object;
        return this.arg.compareTo((String)idFn.getArg()) < 0;
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        return null;
    }

    public boolean references(ValueFunction valueFunction) {
        return false;
    }

    ValueFunction invokeMethod(String string, Vector vector) {
        int n = Misc.whichPosition(string, METHOD_LIST);
        if (n == -1) {
            return super.invokeMethod(string, vector);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(METHOD_LIST[n + 1], ",");
        boolean bl = false;
        int n2 = -1;
        while (!bl && stringTokenizer.hasMoreTokens()) {
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            boolean bl2 = bl = vector.size() == n2;
        }
        if (!bl) {
            throw new IllegalArgumentException("Wrong number of arguments in method IdFn.'" + string + "/" + n2 + "'.");
        }
        try {
            switch (n) {
                case 0: {
                    IntFn intFn = (IntFn)vector.elementAt(0);
                    char c = this.arg.charAt(intFn.intValue());
                    return new IdFn(String.valueOf(c));
                }
                case 2: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    String string2 = Misc.literalToString(valueFunction.toString());
                    return new IntFn(this.arg.compareTo(string2));
                }
                case 4: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    String string3 = Misc.literalToString(valueFunction.toString());
                    return new IntFn(this.arg.compareToIgnoreCase(string3));
                }
                case 6: {
                    ValueFunction valueFunction = (ValueFunction)vector.elementAt(0);
                    String string4 = Misc.literalToString(valueFunction.toString());
                    return new IdFn(this.arg.concat(string4));
                }
                case 8: {
                    IdFn idFn = (IdFn)vector.elementAt(0);
                    return BoolFn.newBoolFn(this.arg.endsWith(idFn.getValue()));
                }
                case 10: {
                    IdFn idFn = (IdFn)vector.elementAt(0);
                    return this.arg.equals(idFn.getValue()) ? BoolFn.trueFn : BoolFn.falseFn;
                }
                case 12: {
                    IdFn idFn = (IdFn)vector.elementAt(0);
                    return this.arg.equalsIgnoreCase(idFn.getValue()) ? BoolFn.trueFn : BoolFn.falseFn;
                }
                case 14: {
                    switch (n2) {
                        case 1: {
                            IdFn idFn = (IdFn)vector.elementAt(0);
                            return new IntFn(this.arg.indexOf(idFn.getValue()));
                        }
                        case 2: {
                            IdFn idFn = (IdFn)vector.elementAt(0);
                            IntFn intFn = (IntFn)vector.elementAt(1);
                            return new IntFn(this.arg.indexOf(idFn.getValue(), intFn.intValue()));
                        }
                    }
                    break;
                }
                case 16: {
                    switch (n2) {
                        case 1: {
                            IdFn idFn = (IdFn)vector.elementAt(0);
                            return new IntFn(this.arg.lastIndexOf(idFn.getValue()));
                        }
                        case 2: {
                            IdFn idFn = (IdFn)vector.elementAt(0);
                            IntFn intFn = (IntFn)vector.elementAt(1);
                            return new IntFn(this.arg.lastIndexOf(idFn.getValue(), intFn.intValue()));
                        }
                    }
                    break;
                }
                case 18: {
                    return new IntFn(this.arg.length());
                }
                case 20: {
                    switch (n2) {
                        case 4: {
                            IntFn intFn = (IntFn)vector.elementAt(0);
                            IdFn idFn = (IdFn)vector.elementAt(1);
                            IntFn intFn2 = (IntFn)vector.elementAt(2);
                            IntFn intFn3 = (IntFn)vector.elementAt(3);
                            return BoolFn.newBoolFn(this.arg.regionMatches(intFn.intValue(), idFn.getValue(), intFn2.intValue(), intFn3.intValue()));
                        }
                        case 5: {
                            BoolFn boolFn = (BoolFn)vector.elementAt(0);
                            IntFn intFn = (IntFn)vector.elementAt(1);
                            IdFn idFn = (IdFn)vector.elementAt(2);
                            IntFn intFn4 = (IntFn)vector.elementAt(3);
                            IntFn intFn5 = (IntFn)vector.elementAt(4);
                            return BoolFn.newBoolFn(this.arg.regionMatches(boolFn.getValue(), intFn.intValue(), idFn.getValue(), intFn4.intValue(), intFn5.intValue()));
                        }
                    }
                    break;
                }
                case 22: {
                    IdFn idFn = (IdFn)vector.elementAt(0);
                    IdFn idFn2 = (IdFn)vector.elementAt(1);
                    return new IdFn(this.arg.replace(idFn.getValue().charAt(0), idFn2.getValue().charAt(0)));
                }
                case 24: {
                    switch (n2) {
                        case 1: {
                            IdFn idFn = (IdFn)vector.elementAt(0);
                            return BoolFn.newBoolFn(this.arg.startsWith(idFn.getValue()));
                        }
                        case 2: {
                            IdFn idFn = (IdFn)vector.elementAt(0);
                            IntFn intFn = (IntFn)vector.elementAt(1);
                            return BoolFn.newBoolFn(this.arg.startsWith(idFn.getValue(), intFn.intValue()));
                        }
                    }
                    break;
                }
                case 26: {
                    switch (n2) {
                        case 1: {
                            IntFn intFn = (IntFn)vector.elementAt(0);
                            return new IdFn(this.arg.substring(intFn.intValue()));
                        }
                        case 2: {
                            IntFn intFn = (IntFn)vector.elementAt(0);
                            IntFn intFn6 = (IntFn)vector.elementAt(1);
                            return new IdFn(this.arg.substring(intFn.intValue(), intFn6.intValue()));
                        }
                    }
                    break;
                }
                case 28: {
                    return new IdFn(this.arg.toLowerCase());
                }
                case 30: {
                    return new IdFn(this.arg.toUpperCase());
                }
                case 32: {
                    return new IdFn(this.arg.trim());
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Type mismatch in method '" + this + '.' + string + "(...)'");
        }
        Core.ERROR(null, 1, (Object)this);
        return null;
    }
}

