/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.fn.IdFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.PrimitiveFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Core;
import zeus.util.Misc;

public class DateFn
extends ValueFunction
implements PrimitiveFn {
    protected String arg = null;
    protected Calendar calendar = null;
    static final String[] METHOD_LIST = new String[]{"day", "0", "dayOfWeek", "0", "month", "0", "nameOfMonth", "0", "year", "0", "interval", "1"};
    static final int DAY = 0;
    static final int DAY_OF_WEEK = 2;
    static final int MONTH = 4;
    static final int NAME_OF_MONTH = 6;
    static final int YEAR = 8;
    static final int INTERVAL = 10;
    protected static final String[] DAY_LIST = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    protected static final String[] MONTH_LIST = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public DateFn(String string) {
        super(16, 10);
        this.arg = string;
        int n = string.indexOf(45);
        if (n == -1) {
            n = string.indexOf(47);
        }
        if (n == 1) {
            this.arg = "0" + this.arg;
        }
    }

    public ValueFunction mirror() {
        return new DateFn(this.arg);
    }

    public String toString() {
        return this.arg;
    }

    Object getArg(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.arg;
    }

    public boolean isDeterminate() {
        return true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateFn)) {
            return false;
        }
        DateFn dateFn = (DateFn)object;
        Calendar calendar = this.getCalendar();
        Calendar calendar2 = dateFn.getCalendar();
        return calendar.get(5) == calendar2.get(5) && calendar.get(2) == calendar2.get(2) && calendar.get(1) == calendar2.get(1);
    }

    public boolean less(Object object) {
        DateFn dateFn = (DateFn)object;
        Calendar calendar = this.getCalendar();
        Calendar calendar2 = dateFn.getCalendar();
        return calendar.before(calendar2);
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        return null;
    }

    public boolean references(ValueFunction valueFunction) {
        return false;
    }

    Calendar getCalendar() {
        if (this.calendar != null) {
            return this.calendar;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.arg, "-/");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        this.calendar = new GregorianCalendar(n3, n2 - 1, n);
        return this.calendar;
    }

    ValueFunction invokeMethod(String string, Vector vector) {
        int n = Misc.whichPosition(string, METHOD_LIST);
        if (n == -1) {
            return super.invokeMethod(string, vector);
        }
        int n2 = Integer.parseInt(METHOD_LIST[n + 1]);
        if (vector.size() != n2) {
            throw new IllegalArgumentException("Wrong number of arguments in method '" + string + "/" + n2 + "'.");
        }
        try {
            this.getCalendar();
            switch (n) {
                case 0: {
                    return new IntFn(this.calendar.get(5));
                }
                case 4: {
                    return new IntFn(this.calendar.get(2) + 1);
                }
                case 8: {
                    return new IntFn(this.calendar.get(1));
                }
                case 2: {
                    return new IdFn(DAY_LIST[this.calendar.get(7) - 1]);
                }
                case 6: {
                    return new IdFn(MONTH_LIST[this.calendar.get(2)]);
                }
                case 10: {
                    DateFn dateFn = (DateFn)vector.elementAt(0);
                    Calendar calendar = dateFn.getCalendar();
                    int n3 = this.calendar.get(6);
                    int n4 = calendar.get(6);
                    return new IntFn(Math.abs(n3 - n4));
                }
            }
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Type mismatch in method '" + this + '.' + string + "(...)'");
        }
        Core.ERROR(null, 1, (Object)this);
        return null;
    }
}

