/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.AndFn;
import zeus.concepts.fn.PrimitiveFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Assert;
import zeus.util.Misc;

public class ConstraintFn
extends ValueFunction {
    static final int LE = 0;
    static final int LT = 1;
    static final int GE = 2;
    static final int GT = 3;
    static final int UN = 4;
    static final int NE = 5;
    public static final String[] operators = new String[]{"<=", "<", ">=", ">", "~", "!="};
    public ValueFunction arg = null;
    protected int op = -1;

    public ConstraintFn(String string, ValueFunction valueFunction) {
        super(7, 7);
        this.op = Misc.whichPosition(string, operators);
        if (this.op == -1) {
            throw new IllegalArgumentException("Unknown operator '" + string + "' in constraint expression");
        }
        this.arg = valueFunction;
        block0 : switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                switch (valueFunction.getID()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 21: 
                    case 22: {
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Illegal operand in '" + this + "'");
            }
            case 4: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal operand in '" + this + "'");
            }
        }
    }

    public String toString() {
        String string = operators[this.op] + this.arg;
        return string;
    }

    public int getOperator() {
        return this.op;
    }

    Object getArg(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.arg;
    }

    public boolean references(ValueFunction valueFunction) {
        return this.arg.references(valueFunction);
    }

    public Vector variables() {
        return this.arg.variables();
    }

    public boolean isDeterminate() {
        return this.arg.isDeterminate();
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction = this.arg.resolve(resolutionContext, bindings);
        return new ConstraintFn(operators[this.op], valueFunction).evaluationFn();
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new ConstraintFn(operators[this.op], this.arg.duplicate(duplicationTable));
    }

    public ValueFunction mirror() {
        return new ConstraintFn(operators[this.op], this.arg.mirror());
    }

    ValueFunction normalize() {
        ValueFunction valueFunction = this.arg.normalize();
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                switch (valueFunction.getID()) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 21: 
                    case 22: {
                        return new ConstraintFn(operators[this.op], valueFunction);
                    }
                }
                throw new IllegalArgumentException("Illegal operand in '" + this + "'");
            }
            case 4: 
            case 5: {
                switch (valueFunction.getID()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: {
                        return new ConstraintFn(operators[this.op], valueFunction);
                    }
                    case 12: {
                        return (ValueFunction)valueFunction.getArg();
                    }
                    case 7: {
                        switch (((ConstraintFn)valueFunction).getOperator()) {
                            case 0: {
                                return new ConstraintFn(operators[3], (ValueFunction)valueFunction.getArg());
                            }
                            case 2: {
                                return new ConstraintFn(operators[1], (ValueFunction)valueFunction.getArg());
                            }
                            case 1: {
                                return new ConstraintFn(operators[2], (ValueFunction)valueFunction.getArg());
                            }
                            case 3: {
                                return new ConstraintFn(operators[0], (ValueFunction)valueFunction.getArg());
                            }
                            case 4: 
                            case 5: {
                                return (ValueFunction)valueFunction.getArg();
                            }
                        }
                        throw new IllegalArgumentException("Illegal operand in '" + this + "'");
                    }
                    case 6: {
                        ValueFunction valueFunction2 = (ValueFunction)valueFunction.getArg(0);
                        ValueFunction valueFunction3 = (ValueFunction)valueFunction.getArg(1);
                        valueFunction2 = new ConstraintFn(operators[5], valueFunction2).normalize();
                        valueFunction3 = new ConstraintFn(operators[5], valueFunction3).normalize();
                        return new AndFn(valueFunction2, valueFunction3);
                    }
                    case 5: {
                        return new ConstraintFn(operators[this.op], valueFunction);
                    }
                    case 1: {
                        return new ConstraintFn(operators[this.op], valueFunction);
                    }
                }
                throw new IllegalArgumentException("Illegal operand in '" + this + "'");
            }
        }
        throw new IllegalArgumentException("Illegal operand in '" + this + "'");
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstraintFn)) {
            return false;
        }
        ConstraintFn constraintFn = (ConstraintFn)object;
        return this.arg.equals(constraintFn.getArg());
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        if (!this.isDeterminate() || !valueFunction.isDeterminate()) {
            return new AndFn(this, valueFunction);
        }
        ValueFunction valueFunction2 = this.evaluationFn();
        ValueFunction valueFunction3 = valueFunction.evaluationFn();
        int n = valueFunction2.baseID();
        int n2 = valueFunction3.baseID();
        if (n == 14 || n == 15 ? n2 != 14 && n2 != 15 : n != n2) {
            throw new IllegalArgumentException("Illegal operand in '" + this + "'");
        }
        switch (this.op) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                switch (valueFunction3.getID()) {
                    case 2: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: {
                        return ConstraintFn.compare((ConstraintFn)valueFunction2, (PrimitiveFn)((Object)valueFunction3));
                    }
                    case 7: {
                        return ConstraintFn.checkRange((ConstraintFn)valueFunction2, (ConstraintFn)valueFunction3);
                    }
                }
                throw new IllegalArgumentException("Illegal operand in '" + this + "'");
            }
            case 4: 
            case 5: {
                switch (valueFunction3.getID()) {
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 23: {
                        if (((ValueFunction)valueFunction2.getArg()).unifiesWith(valueFunction3, bindings) == null) {
                            return valueFunction3;
                        }
                        return null;
                    }
                    case 7: {
                        switch (((ConstraintFn)valueFunction3).getOperator()) {
                            case 4: 
                            case 5: {
                                if (valueFunction2.equals(valueFunction3)) {
                                    return valueFunction2;
                                }
                                return new AndFn(valueFunction2, valueFunction3);
                            }
                        }
                        return ConstraintFn.checkRange((ConstraintFn)valueFunction2, (ConstraintFn)valueFunction3);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal operand in '" + this + "'");
            }
        }
        return null;
    }

    public int baseID() {
        return this.arg.baseID();
    }

    static ValueFunction compare(ConstraintFn constraintFn, PrimitiveFn primitiveFn) {
        PrimitiveFn primitiveFn2 = (PrimitiveFn)constraintFn.getArg();
        switch (constraintFn.getOperator()) {
            case 0: {
                if (primitiveFn.less(primitiveFn2) || primitiveFn.equals(primitiveFn2)) {
                    return (ValueFunction)((Object)primitiveFn);
                }
                return null;
            }
            case 2: {
                if (primitiveFn2.less(primitiveFn) || primitiveFn2.equals(primitiveFn)) {
                    return (ValueFunction)((Object)primitiveFn);
                }
                return null;
            }
            case 1: {
                if (primitiveFn.less(primitiveFn2)) {
                    return (ValueFunction)((Object)primitiveFn);
                }
                return null;
            }
            case 3: {
                if (primitiveFn2.less(primitiveFn)) {
                    return (ValueFunction)((Object)primitiveFn);
                }
                return null;
            }
        }
        Assert.notNull(null);
        return null;
    }

    static ValueFunction checkRange(ConstraintFn constraintFn, ConstraintFn constraintFn2) {
        if (constraintFn.getOperator() > constraintFn2.getOperator()) {
            return ConstraintFn.checkRange(constraintFn2, constraintFn);
        }
        PrimitiveFn primitiveFn = (PrimitiveFn)constraintFn.getArg();
        PrimitiveFn primitiveFn2 = (PrimitiveFn)constraintFn2.getArg();
        switch (constraintFn.getOperator()) {
            case 0: {
                switch (constraintFn2.getOperator()) {
                    case 0: {
                        return primitiveFn.less(primitiveFn2) ? constraintFn : constraintFn2;
                    }
                    case 1: {
                        if (primitiveFn.equals(primitiveFn2)) {
                            return null;
                        }
                        if (primitiveFn.less(primitiveFn2)) {
                            return constraintFn;
                        }
                        return constraintFn2;
                    }
                    case 2: {
                        if (primitiveFn.equals(primitiveFn2)) {
                            return (ValueFunction)((Object)primitiveFn);
                        }
                        if (primitiveFn2.less(primitiveFn)) {
                            return new AndFn(constraintFn, constraintFn2);
                        }
                        return null;
                    }
                    case 3: {
                        if (primitiveFn2.less(primitiveFn)) {
                            return new AndFn(constraintFn, constraintFn2);
                        }
                        return null;
                    }
                    case 4: 
                    case 5: {
                        if (primitiveFn.equals(primitiveFn2)) {
                            return new ConstraintFn(operators[1], (ValueFunction)((Object)primitiveFn));
                        }
                        if (primitiveFn.less(primitiveFn2)) {
                            return constraintFn;
                        }
                        return new AndFn(constraintFn, constraintFn2);
                    }
                }
                break;
            }
            case 1: {
                switch (constraintFn2.getOperator()) {
                    case 1: {
                        return primitiveFn.less(primitiveFn2) ? constraintFn : constraintFn2;
                    }
                    case 2: 
                    case 3: {
                        if (primitiveFn2.less(primitiveFn)) {
                            return new AndFn(constraintFn, constraintFn2);
                        }
                        return null;
                    }
                    case 4: 
                    case 5: {
                        if (primitiveFn2.less(primitiveFn)) {
                            return new AndFn(constraintFn, constraintFn2);
                        }
                        return constraintFn;
                    }
                }
                break;
            }
            case 2: {
                switch (constraintFn2.getOperator()) {
                    case 2: {
                        return primitiveFn.less(primitiveFn2) ? (ValueFunction)((Object)primitiveFn2) : (ValueFunction)((Object)primitiveFn);
                    }
                    case 3: {
                        if (primitiveFn.equals(primitiveFn2)) {
                            return null;
                        }
                        if (primitiveFn.less(primitiveFn2)) {
                            return constraintFn2;
                        }
                        return constraintFn;
                    }
                    case 4: 
                    case 5: {
                        if (primitiveFn.equals(primitiveFn2)) {
                            return new ConstraintFn(operators[3], (ValueFunction)((Object)primitiveFn));
                        }
                        if (primitiveFn.less(primitiveFn2)) {
                            return new AndFn(constraintFn, constraintFn2);
                        }
                        return constraintFn;
                    }
                }
                break;
            }
            case 3: {
                switch (constraintFn2.getOperator()) {
                    case 3: {
                        return primitiveFn.less(primitiveFn2) ? constraintFn2 : constraintFn;
                    }
                    case 4: 
                    case 5: {
                        if (primitiveFn.less(primitiveFn2)) {
                            return new AndFn(constraintFn, constraintFn2);
                        }
                        return constraintFn;
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                switch (constraintFn2.getOperator()) {
                    case 4: 
                    case 5: {
                        return primitiveFn.equals(primitiveFn2) ? constraintFn : new AndFn(constraintFn, constraintFn2);
                    }
                }
            }
        }
        Assert.notNull(null);
        return null;
    }
}

