/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.PrimitiveFn;
import zeus.concepts.fn.ValueFunction;

public class BoolFn
extends LogicalFn
implements PrimitiveFn {
    protected boolean arg;
    public static final BoolFn trueFn = new BoolFn("true");
    public static final BoolFn falseFn = new BoolFn("false");

    public static final BoolFn newBoolFn(boolean bl) {
        return bl ? trueFn : falseFn;
    }

    public static final BoolFn newBoolFn(String string) {
        if (string.equals("true")) {
            return trueFn;
        }
        if (string.equals("false")) {
            return falseFn;
        }
        throw new IllegalArgumentException("Unknown operand '" + string + "' in boolean function");
    }

    public ValueFunction mirror() {
        return new BoolFn(this.toString());
    }

    private BoolFn(String string) {
        super(18, 10);
        this.arg = Boolean.valueOf(string);
    }

    public String toString() {
        return new Boolean(this.arg).toString();
    }

    Object getArg(int n) {
        if (n != 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return new Boolean(this.arg);
    }

    public boolean getValue() {
        return this.arg;
    }

    public boolean isDeterminate() {
        return true;
    }

    public int evaluate() {
        return this.arg ? 0 : 1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BoolFn)) {
            return false;
        }
        BoolFn boolFn = (BoolFn)object;
        return this.arg == boolFn.getValue();
    }

    public boolean less(Object object) {
        return false;
    }

    public boolean references(ValueFunction valueFunction) {
        return false;
    }
}

