/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts.fn;

import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class AndFn
extends ValueFunction {
    protected ValueFunction[] args = new ValueFunction[2];

    public AndFn(ValueFunction valueFunction, ValueFunction valueFunction2) {
        super(5, 5);
        this.args[0] = valueFunction;
        this.args[1] = valueFunction2;
    }

    public String toString() {
        String string = "(" + this.args[0] + "&" + this.args[1] + ")";
        return string;
    }

    ValueFunction simplify() {
        Hashtable hashtable = new Hashtable();
        Vector vector = new Vector();
        this.expand(vector, hashtable);
        Misc.sort(vector);
        return this.concatenate(vector, hashtable);
    }

    protected ValueFunction concatenate(Vector vector, Hashtable hashtable) {
        return this.concatenate(vector, 0, hashtable);
    }

    protected ValueFunction concatenate(Vector vector, int n, Hashtable hashtable) {
        if (n + 1 == vector.size()) {
            return (ValueFunction)hashtable.get(vector.elementAt(n));
        }
        if (n + 2 == vector.size()) {
            return new AndFn((ValueFunction)hashtable.get(vector.elementAt(n)), (ValueFunction)hashtable.get(vector.elementAt(n + 1)));
        }
        return new AndFn((ValueFunction)hashtable.get(vector.elementAt(n)), this.concatenate(vector, n + 1, hashtable));
    }

    void expand(Vector vector) {
        Hashtable hashtable = new Hashtable();
        this.expand(vector, hashtable);
    }

    protected void expand(Vector vector, Hashtable hashtable) {
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].getID() == 5) {
                ((AndFn)this.args[n]).expand(vector, hashtable);
            } else {
                ValueFunction valueFunction = this.args[n].simplify();
                String string = valueFunction.toString();
                if (!vector.contains(string)) {
                    vector.addElement(string);
                    hashtable.put(string, valueFunction);
                }
            }
            ++n;
        }
    }

    boolean subsumes(AndFn andFn) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.expand(vector);
        andFn.expand(vector2);
        return Misc.isSubset(vector2, vector);
    }

    Object getArg(int n) {
        return this.args[n];
    }

    public boolean isDeterminate() {
        return this.args[0].isDeterminate() && this.args[1].isDeterminate();
    }

    ValueFunction normalize() {
        return new AndFn(this.args[0].normalize(), this.args[1].normalize());
    }

    public boolean references(ValueFunction valueFunction) {
        return this.args[0].references(valueFunction) || this.args[1].references(valueFunction);
    }

    public Vector variables() {
        return Misc.union(this.args[0].variables(), this.args[1].variables());
    }

    public ValueFunction mirror() {
        return new AndFn(this.args[0].mirror(), this.args[1].mirror());
    }

    public ValueFunction resolve(ResolutionContext resolutionContext, Bindings bindings) {
        ValueFunction valueFunction;
        ValueFunction valueFunction2 = this.args[0].resolve(resolutionContext, bindings);
        return valueFunction2.equals(valueFunction = this.args[1].resolve(resolutionContext, bindings)) ? valueFunction2 : new AndFn(valueFunction2, valueFunction);
    }

    public ValueFunction duplicate(DuplicationTable duplicationTable) {
        return new AndFn(this.args[0].duplicate(duplicationTable), this.args[1].duplicate(duplicationTable));
    }

    public boolean equals(Object object) {
        if (!(object instanceof AndFn)) {
            return false;
        }
        AndFn andFn = (AndFn)object;
        ValueFunction valueFunction = this.simplify();
        ValueFunction valueFunction2 = andFn.simplify();
        return ((ValueFunction)valueFunction.getArg(0)).equals((ValueFunction)valueFunction2.getArg(0)) && ((ValueFunction)valueFunction.getArg(1)).equals((ValueFunction)valueFunction2.getArg(1));
    }

    ValueFunction unify(ValueFunction valueFunction, Bindings bindings) {
        ValueFunction valueFunction2 = null;
        ValueFunction valueFunction3 = null;
        if (valueFunction instanceof AndFn && ((AndFn)valueFunction).subsumes(this)) {
            return valueFunction;
        }
        valueFunction2 = this.args[0].unifiesWith(valueFunction, bindings);
        if (valueFunction2 != null && (valueFunction3 = this.args[1].unifiesWith(valueFunction, bindings)) != null) {
            if (valueFunction2.equals(valueFunction3)) {
                return valueFunction2;
            }
            return new AndFn(valueFunction2, valueFunction3);
        }
        return null;
    }

    public int baseID() {
        int n;
        int n2 = this.args[0].baseID();
        if (n2 != (n = this.args[1].baseID())) {
            throw new IllegalArgumentException("Incompatible types in " + this);
        }
        return n2;
    }
}

