/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import zeus.concepts.AbstractTask;
import zeus.concepts.Summary;
import zeus.util.Assert;
import zeus.util.Misc;

public class TaskSummary
extends Summary {
    protected AbstractTask task;

    public TaskSummary(AbstractTask abstractTask, String string) {
        this.setTask(abstractTask);
        this.setStatus(string);
    }

    public TaskSummary(TaskSummary taskSummary) {
        this.setTask(taskSummary.getTask());
        this.setStatus(taskSummary.getStatus());
    }

    public String getId() {
        return this.task.getName();
    }

    public AbstractTask getTask() {
        return this.task;
    }

    public String[] summarize() {
        String[] stringArray = new String[]{this.task.getName(), this.status};
        return stringArray;
    }

    public void setStatus(String string) {
        Assert.notNull(string);
        Assert.notFalse(string.equals("OK") || string.equals("UNKNOWN"));
        this.status = string;
    }

    public void setTask(AbstractTask abstractTask) {
        Assert.notNull(abstractTask);
        this.task = abstractTask;
    }

    public boolean equals(TaskSummary taskSummary) {
        return this.task.equals(taskSummary.getTask()) && this.status.equals(taskSummary.getStatus());
    }

    public String toString() {
        return "(:task " + this.task.toString() + " " + ":status " + this.status + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = "(:task ";
        String string4 = string3 + this.task.pprint(n + string3.length()) + string2 + ":status " + this.status + string2;
        return string4.trim() + "\n" + string + ")";
    }
}

