/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import zeus.concepts.DuplicationTable;
import zeus.concepts.Reference;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;
import zeus.util.Assert;
import zeus.util.GenSym;
import zeus.util.Misc;

public class TaskLink
implements Reference {
    protected String leftNode;
    protected String rightNode;
    protected String leftArg;
    protected String rightArg;
    protected String leftGroup;
    protected String rightGroup;

    public TaskLink(String string, String string2, String string3, String string4, String string5, String string6) {
        Assert.notNull(string);
        Assert.notNull(string2);
        Assert.notNull(string3);
        Assert.notNull(string4);
        Assert.notNull(string5);
        Assert.notNull(string6);
        this.leftNode = string;
        this.leftGroup = string2;
        this.leftArg = string3;
        this.rightNode = string4;
        this.rightGroup = string5;
        this.rightArg = string6;
    }

    public TaskLink(TaskLink taskLink) {
        this.leftNode = taskLink.getLeftNode();
        this.rightNode = taskLink.getRightNode();
        this.leftGroup = taskLink.getLeftGroup();
        this.rightGroup = taskLink.getRightGroup();
        this.leftArg = taskLink.getLeftArg();
        this.rightArg = taskLink.getRightArg();
    }

    public void setLeftNode(String string) {
        Assert.notNull(string);
        this.leftNode = string;
    }

    public void setRightNode(String string) {
        Assert.notNull(string);
        this.rightNode = string;
    }

    public void setLeftArg(String string) {
        Assert.notNull(string);
        this.leftArg = string;
    }

    public void setRightArg(String string) {
        Assert.notNull(string);
        this.rightArg = string;
    }

    public void setLeftGroup(String string) {
        Assert.notNull(string);
        this.leftGroup = string;
    }

    public void setRightGroup(String string) {
        Assert.notNull(string);
        this.rightGroup = string;
    }

    public String getLeftNode() {
        return this.leftNode;
    }

    public String getRightNode() {
        return this.rightNode;
    }

    public String getLeftGroup() {
        return this.leftGroup;
    }

    public String getRightGroup() {
        return this.rightGroup;
    }

    public String getLeftArg() {
        return this.leftArg;
    }

    public String getRightArg() {
        return this.rightArg;
    }

    public boolean isFromBeginNode() {
        return this.leftNode.equals("begin");
    }

    public boolean isToEndNode() {
        return this.rightNode.equals("end");
    }

    public String getId() {
        return this.leftNode + ":" + this.leftGroup + ":" + this.leftArg + "==" + this.rightNode + ":" + this.rightGroup + ":" + this.rightArg;
    }

    public boolean equals(TaskLink taskLink) {
        return this.getId().equals(taskLink.getId());
    }

    public String toString() {
        return "(:left_node " + this.leftNode + " " + ":left_group " + this.leftGroup + " " + ":left_arg " + this.leftArg + " " + ":right_node " + this.rightNode + " " + ":right_group " + this.rightGroup + " " + ":right_arg " + this.rightArg + ")";
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = "(:left_node " + this.leftNode + string2 + ":left_group " + this.leftGroup + string2 + ":left_arg " + this.leftArg + string2 + ":right_node " + this.rightNode + string2 + ":right_group " + this.rightGroup + string2 + ":right_arg " + this.rightArg + string2;
        return string3.trim() + "\n" + string + ")";
    }

    public boolean referencesNode(String string) {
        return this.leftNode.equals(string) || this.rightNode.equals(string);
    }

    public boolean references(String string) {
        return this.leftArg.equals(string) || this.rightArg.equals(string);
    }

    public TaskLink duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public TaskLink duplicate(DuplicationTable duplicationTable) {
        VarFn varFn = new VarFn(this.leftArg);
        VarFn varFn2 = new VarFn(this.rightArg);
        String string = ((ValueFunction)varFn).duplicate(duplicationTable).toString();
        String string2 = ((ValueFunction)varFn2).duplicate(duplicationTable).toString();
        return new TaskLink(this.leftNode, this.leftGroup, string, this.rightNode, this.rightGroup, string2);
    }
}

