/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.concepts.AbstractTask;
import zeus.concepts.Bindings;
import zeus.concepts.Fact;
import zeus.concepts.ResolutionContext;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.ArithmeticFn;
import zeus.concepts.fn.ElseFn;
import zeus.concepts.fn.IntFn;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.PrimitiveNumericFn;
import zeus.concepts.fn.RealFn;
import zeus.concepts.fn.ValueFunction;
import zeus.ontology.service.InstanceRenderer;
import zeus.ontology.service.ProcessRenderer;
import zeus.ontology.service.ProfileRenderer;
import zeus.ontology.service.RangeRenderer;
import zeus.ontology.service.RendererFactory;
import zeus.ontology.service.UnknownRendererTypeException;
import zeus.util.Core;
import zeus.util.SystemProps;

public abstract class Task
extends AbstractTask {
    protected Vector constraints = new Vector();
    protected ValueFunction time = ZeusParser.Expression(SystemProps.getProperty("task.default.time"));
    protected ValueFunction cost = ZeusParser.Expression(SystemProps.getProperty("task.default.cost"));
    transient ResolutionContext resolution_context = null;

    public void setTimeFn(String string) {
        ValueFunction valueFunction = ZeusParser.Expression(string);
        if (valueFunction != null) {
            this.time = valueFunction;
        }
    }

    public void setTimeFn(ValueFunction valueFunction) {
        this.time = valueFunction;
    }

    public void setCostFn(String string) {
        ValueFunction valueFunction = ZeusParser.Expression(string);
        if (valueFunction != null) {
            this.cost = valueFunction;
        }
    }

    public void setCostFn(ValueFunction valueFunction) {
        this.cost = valueFunction;
    }

    public ValueFunction getTimeFn() {
        return this.time;
    }

    public ValueFunction getCostFn() {
        return this.cost;
    }

    public int getTime() {
        ValueFunction valueFunction;
        int n = SystemProps.getInt("task.default.time");
        if (this.time instanceof ElseFn) {
            this.time = valueFunction = this.time.evaluationFn();
        }
        if (this.time instanceof ArithmeticFn) {
            valueFunction = ((ArithmeticFn)this.time).evaluationFn();
            if (valueFunction instanceof IntFn) {
                n = ((IntFn)this.time).getValue();
            } else if (valueFunction instanceof RealFn) {
                double d = ((RealFn)this.time).getValue();
                Double d3 = new Double(d);
                n = d3.intValue();
            }
        }
        if (!this.time.isDeterminate() || !(this.time instanceof IntFn)) {
            Core.USER_ERROR("Task " + this.name + " is improperly defined.\nCannot evaluates its " + " duration given required effect.\nCurrent value: '" + this.time + "'\nSetting duration to " + n);
        } else {
            n = ((IntFn)this.time).getValue();
        }
        return n;
    }

    public double getCost() {
        ValueFunction valueFunction;
        double d = SystemProps.getDouble("task.default.cost");
        this.debug("cost= " + this.cost.toString());
        Fact[] factArray = this.getPostconditions();
        int n = 0;
        while (n < factArray.length) {
            this.debug("post  = " + factArray[n].toString());
            ++n;
        }
        if (this.cost instanceof ElseFn) {
            valueFunction = this.cost.evaluationFn();
            this.debug("elseed" + valueFunction.toString());
            this.cost = valueFunction;
        }
        if (this.cost instanceof ArithmeticFn) {
            valueFunction = ((ArithmeticFn)this.cost).evaluationFn();
            if (valueFunction instanceof IntFn) {
                d = ((IntFn)this.time).getValue();
                this.debug("arith then int");
                return d;
            }
            if (valueFunction instanceof RealFn) {
                d = ((RealFn)this.time).getValue();
                this.debug("arith then real");
                return d;
            }
        }
        if (!this.cost.isDeterminate() || !(this.cost instanceof PrimitiveNumericFn)) {
            Core.USER_ERROR("Task " + this.name + " is improperly defined.\nCannot evaluates its " + " cost given required effect.\nCurrent value: '" + this.cost + "'\nSetting cost to " + d);
        } else {
            d = ((PrimitiveNumericFn)((Object)this.cost)).doubleValue();
        }
        return d;
    }

    public abstract Fact[] getPostconditions();

    public abstract Fact[] getPreconditions();

    public abstract ResolutionContext getContext();

    public boolean applyConstraints(Bindings bindings) {
        Bindings bindings2 = new Bindings(bindings);
        ResolutionContext resolutionContext = this.getContext();
        int n = 0;
        while (n < this.constraints.size()) {
            LogicalFn logicalFn = (LogicalFn)this.constraints.elementAt(n);
            if ((logicalFn = (LogicalFn)logicalFn.resolve(resolutionContext, bindings2)) == null) {
                return false;
            }
            if (logicalFn.evaluate() != 0) {
                return false;
            }
            ++n;
        }
        return bindings.add(bindings2);
    }

    public void setConstraints(Vector vector) {
        this.constraints.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this.constraints.addElement((LogicalFn)vector.elementAt(n));
            ++n;
        }
    }

    public void setConstraints(LogicalFn[] logicalFnArray) {
        this.constraints.removeAllElements();
        int n = 0;
        while (n < logicalFnArray.length) {
            this.constraints.addElement(logicalFnArray[n]);
            ++n;
        }
    }

    public LogicalFn[] getConstraints() {
        LogicalFn[] logicalFnArray = new LogicalFn[this.constraints.size()];
        int n = 0;
        while (n < this.constraints.size()) {
            logicalFnArray[n] = (LogicalFn)this.constraints.elementAt(n);
            ++n;
        }
        return logicalFnArray;
    }

    public String getServiceDesc(AgentContext agentContext) {
        try {
            ProfileRenderer profileRenderer = RendererFactory.getProfileRenderer("DAML-S");
            return profileRenderer.renderProfile(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public String getInstanceDetails(AgentContext agentContext) {
        try {
            InstanceRenderer instanceRenderer = RendererFactory.getInstanceRenderer("DAML-S");
            return instanceRenderer.renderInstance(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public String getInstanceRange(AgentContext agentContext) {
        try {
            RangeRenderer rangeRenderer = RendererFactory.getRangeRenderer("XSD");
            return rangeRenderer.renderRange(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public String getProcessModel(AgentContext agentContext) {
        try {
            ProcessRenderer processRenderer = RendererFactory.getProcessRenderer("DAML-S");
            return processRenderer.renderProcess(this, agentContext);
        }
        catch (UnknownRendererTypeException unknownRendererTypeException) {
            return null;
        }
    }

    public void debug(String string) {
    }
}

