/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.PrimitiveTask;
import zeus.concepts.ReservationEntry;
import zeus.concepts.SuppliedItem;
import zeus.concepts.SuppliedRequester;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.GenSym;

public class SuppliedDb
extends Hashtable {
    protected OntologyDb ontology;

    public SuppliedDb(OntologyDb ontologyDb) {
        Assert.notNull(ontologyDb);
        this.ontology = ontologyDb;
    }

    public SuppliedDb(SuppliedDb suppliedDb) {
        this.ontology = suppliedDb.getOntology();
        this.add(suppliedDb);
    }

    OntologyDb getOntology() {
        return this.ontology;
    }

    public synchronized boolean add(SuppliedDb suppliedDb) {
        boolean bl = true;
        Enumeration enumeration = suppliedDb.elements();
        while (bl && enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (bl && enumeration2.hasMoreElements()) {
                SuppliedItem suppliedItem = (SuppliedItem)enumeration2.nextElement();
                bl &= this.add(suppliedItem);
            }
        }
        return bl;
    }

    public synchronized boolean add(Vector vector) {
        boolean bl = true;
        int n = 0;
        while (bl && n < vector.size()) {
            bl &= this.add((SuppliedItem)vector.elementAt(n));
            ++n;
        }
        return bl;
    }

    public synchronized boolean add(SuppliedItem[] suppliedItemArray) {
        boolean bl = true;
        int n = 0;
        while (bl && n < suppliedItemArray.length) {
            bl &= this.add(suppliedItemArray[n]);
            ++n;
        }
        return bl;
    }

    public synchronized boolean add(SuppliedItem suppliedItem) {
        SuppliedItem suppliedItem2;
        Assert.notNull(suppliedItem);
        String string = suppliedItem.getFact().getType();
        Hashtable<String, SuppliedItem> hashtable = (Hashtable<String, SuppliedItem>)this.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, SuppliedItem>();
            this.put(string, hashtable);
        }
        if ((suppliedItem2 = (SuppliedItem)hashtable.get(suppliedItem.getId())) == null) {
            hashtable.put(suppliedItem.getId(), suppliedItem);
            return true;
        }
        ReservationEntry[] reservationEntryArray = suppliedItem.getReservations();
        boolean bl = true;
        int n = 0;
        while (bl && n < reservationEntryArray.length) {
            bl &= suppliedItem2.reserve(reservationEntryArray[n].id, reservationEntryArray[n].start, reservationEntryArray[n].consumed, reservationEntryArray[n].amount, reservationEntryArray[n].agent, reservationEntryArray[n].goalId, reservationEntryArray[n].comms_key);
            ++n;
        }
        return bl;
    }

    public synchronized void del(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            this.del((SuppliedItem)vector.elementAt(n));
            ++n;
        }
    }

    public synchronized void del(SuppliedItem[] suppliedItemArray) {
        int n = 0;
        while (n < suppliedItemArray.length) {
            this.del(suppliedItemArray[n]);
            ++n;
        }
    }

    public synchronized void del(SuppliedItem suppliedItem) {
        Assert.notNull(suppliedItem);
        String string = suppliedItem.getFact().getType();
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            SuppliedItem suppliedItem2 = (SuppliedItem)enumeration.nextElement();
            if (!suppliedItem2.equals(suppliedItem)) continue;
            hashtable.remove(suppliedItem2.getId());
            break;
        }
        if (hashtable.isEmpty()) {
            this.remove(string);
        }
    }

    public synchronized int findAll(SuppliedRequester suppliedRequester, Fact fact, int n, int n2) {
        Assert.notFalse(n2 > 0);
        Hashtable hashtable = (Hashtable)this.get(fact.getType());
        if (hashtable == null) {
            return n2;
        }
        int n3 = suppliedRequester.getStartTime();
        boolean bl = !fact.isReadOnly();
        Enumeration enumeration = hashtable.elements();
        Bindings bindings = new Bindings();
        while (n2 > 0 && enumeration.hasMoreElements()) {
            SuppliedItem suppliedItem = (SuppliedItem)enumeration.nextElement();
            Fact fact2 = suppliedItem.getFact();
            bindings.clear();
            int n4 = suppliedItem.unreservedAmount(n3, bl);
            if (n4 <= 0 || !fact2.unifiesWith(fact, bindings) || !suppliedRequester.applyConstraints(bindings)) continue;
            Assert.notFalse(suppliedRequester.setSupplier(n, Math.min(n4, n2), suppliedItem));
            n2 -= Math.min(n4, n2);
            Core.DEBUG(3, "SRDb Required to find Fact:\n" + fact);
            Core.DEBUG(3, "SRDb Supplied Item:\n" + suppliedItem + "\nassigned to rec " + suppliedRequester);
        }
        return n2;
    }

    public synchronized void allocateResources(SuppliedRequester suppliedRequester) {
        PrimitiveTask primitiveTask = suppliedRequester.getTask();
        Fact[][] factArray = primitiveTask.orderPreconditions();
        boolean bl = true;
        int n = 0;
        while (bl && n < factArray.length) {
            int n2 = 0;
            while (n2 < factArray[n].length) {
                int n3;
                int n4;
                if (!factArray[n][n2].isNegative() && (n4 = suppliedRequester.noRequiredItems(n3 = primitiveTask.getConsumedPos(factArray[n][n2]))) > 0) {
                    bl &= this.findAll(suppliedRequester, factArray[n][n2], n3, n4) == 0;
                }
                ++n2;
            }
            ++n;
        }
    }

    public synchronized int allocateResource(SuppliedRequester suppliedRequester, int n, int n2) {
        PrimitiveTask primitiveTask = suppliedRequester.getTask();
        Fact fact = primitiveTask.getPrecondition(n);
        return this.findAll(suppliedRequester, fact, n, n2);
    }

    public synchronized Fact evalLocal(Fact fact) {
        Fact[] factArray = this.all(fact);
        if (factArray == null || factArray.length == 0) {
            return null;
        }
        Fact fact2 = new Fact(factArray[0]);
        int n = 1;
        while (n < factArray.length) {
            Assert.notFalse(fact2.disjoin(factArray[n]));
            ++n;
        }
        return fact2;
    }

    public synchronized Fact[] all(Fact fact) {
        Hashtable hashtable = (Hashtable)this.get(fact.getType());
        if (hashtable == null) {
            return null;
        }
        Vector<Fact> vector = new Vector<Fact>();
        Bindings bindings = new Bindings();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            SuppliedItem suppliedItem = (SuppliedItem)enumeration.nextElement();
            Fact fact2 = suppliedItem.getFact();
            bindings.clear();
            if (!fact2.unifiesWith(fact, bindings)) continue;
            vector.addElement(fact2);
        }
        Fact[] factArray = new Fact[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            factArray[n] = (Fact)vector.elementAt(n);
            ++n;
        }
        return factArray;
    }

    public synchronized Fact any(Fact fact) {
        Fact[] factArray = this.all(fact);
        if (factArray == null) {
            return null;
        }
        int n = (int)(Math.random() * (double)factArray.length);
        return factArray[n];
    }

    public synchronized boolean contains(Fact fact, int n) {
        Hashtable hashtable = (Hashtable)this.get(fact.getType());
        if (hashtable == null) {
            return false;
        }
        Bindings bindings = new Bindings();
        int n2 = fact.getNumber();
        boolean bl = !fact.isReadOnly();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements() && n2 > 0) {
            SuppliedItem suppliedItem = (SuppliedItem)enumeration.nextElement();
            bindings.clear();
            Fact fact2 = suppliedItem.getFact();
            int n3 = suppliedItem.unreservedAmount(n, bl);
            if (n3 <= 0 || !fact2.unifiesWith(fact, bindings)) continue;
            n2 -= Math.min(n3, n2);
        }
        return n2 <= 0;
    }

    public boolean cancelReservation(String string) {
        boolean bl = false;
        Enumeration enumeration = this.elements();
        while (!bl && enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (!bl && enumeration2.hasMoreElements()) {
                SuppliedItem suppliedItem = (SuppliedItem)enumeration2.nextElement();
                bl = suppliedItem.cancelReservation(string);
            }
        }
        return bl;
    }

    public synchronized SuppliedItem getSuppliedItem(String string) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                SuppliedItem suppliedItem = (SuppliedItem)enumeration2.nextElement();
                if (!suppliedItem.getId().equals(string)) continue;
                return suppliedItem;
            }
        }
        return null;
    }

    public synchronized boolean isReserved(String string) {
        SuppliedItem suppliedItem = this.getSuppliedItem(string);
        return suppliedItem.isReserved();
    }

    public synchronized ReservationEntry[] getReservations(String string, String string2) {
        Vector<ReservationEntry> vector = new Vector<ReservationEntry>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                SuppliedItem suppliedItem = (SuppliedItem)enumeration2.nextElement();
                if (!suppliedItem.getSupplier().equals(string)) continue;
                ReservationEntry[] reservationEntryArray = suppliedItem.getReservations(string2);
                int n = 0;
                while (n < reservationEntryArray.length) {
                    vector.addElement(reservationEntryArray[n]);
                    ++n;
                }
            }
        }
        ReservationEntry[] reservationEntryArray = new ReservationEntry[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            reservationEntryArray[n] = (ReservationEntry)vector.elementAt(n);
            ++n;
        }
        return reservationEntryArray;
    }

    public String toString() {
        String string = "";
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                string = string + enumeration2.nextElement();
            }
        }
        return string;
    }

    public SuppliedDb duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    public SuppliedDb duplicate(DuplicationTable duplicationTable) {
        SuppliedDb suppliedDb = new SuppliedDb(this.ontology);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)enumeration.nextElement();
            Enumeration enumeration2 = hashtable.elements();
            while (enumeration2.hasMoreElements()) {
                SuppliedItem suppliedItem = (SuppliedItem)enumeration2.nextElement();
                suppliedDb.add(suppliedItem.duplicate(duplicationTable));
            }
        }
        return suppliedDb;
    }
}

