/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.AbstractTask;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.ResolutionContext;
import zeus.concepts.Task;
import zeus.concepts.TaskLink;
import zeus.concepts.TaskNode;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Misc;

public class SummaryTask
extends Task {
    protected Vector nodes = new Vector();
    protected Vector links = new Vector();
    protected boolean autorun = false;

    public SummaryTask() {
        this.type = 1;
        TaskNode taskNode = new TaskNode("begin");
        this.nodes.addElement(taskNode);
        taskNode = new TaskNode("end");
        this.nodes.addElement(taskNode);
    }

    public SummaryTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, TaskNode[] taskNodeArray, TaskLink[] taskLinkArray, LogicalFn[] logicalFnArray) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setNodes(taskNodeArray);
        this.setLinks(taskLinkArray);
        this.setConstraints(logicalFnArray);
    }

    public SummaryTask(String string, String string2, String string3, TaskNode[] taskNodeArray, TaskLink[] taskLinkArray, LogicalFn[] logicalFnArray) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(string2);
        this.setCostFn(string3);
        this.setNodes(taskNodeArray);
        this.setLinks(taskLinkArray);
        this.setConstraints(logicalFnArray);
    }

    public SummaryTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, Vector vector, Vector vector2, Vector vector3) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setNodes(vector);
        this.setLinks(vector2);
        this.setConstraints(vector3);
    }

    public SummaryTask(String string, String string2, String string3, Vector vector, Vector vector2, Vector vector3) {
        this.type = 1;
        this.setName(string);
        this.setTimeFn(string2);
        this.setCostFn(string3);
        this.setNodes(vector);
        this.setLinks(vector2);
        this.setConstraints(vector3);
    }

    public SummaryTask(SummaryTask summaryTask) {
        this.type = 1;
        this.name = summaryTask.getName();
        this.cost = summaryTask.getCostFn();
        this.time = summaryTask.getTimeFn();
        this.setNodes(summaryTask.getNodes());
        this.setLinks(summaryTask.getLinks());
        this.setConstraints(summaryTask.getConstraints());
    }

    public Vector links() {
        return this.links;
    }

    public Vector constraints() {
        return this.constraints;
    }

    public Fact[] getPostconditions() {
        TaskNode taskNode = this.getNode("end");
        return taskNode.getPreconditions();
    }

    public Fact[] getPreconditions() {
        TaskNode taskNode = this.getNode("begin");
        return taskNode.getPostconditions();
    }

    public TaskNode getNode(String string) {
        TaskNode taskNode = null;
        int n = 0;
        while (n < this.nodes.size()) {
            taskNode = (TaskNode)this.nodes.elementAt(n);
            if (taskNode.getName().equals(string)) {
                return taskNode;
            }
            ++n;
        }
        return null;
    }

    public Fact[] allFacts() {
        int n;
        Fact[] factArray;
        Vector<Fact> vector = new Vector<Fact>();
        int n2 = 0;
        while (n2 < this.nodes.size()) {
            TaskNode taskNode = (TaskNode)this.nodes.elementAt(n2);
            if (!taskNode.getName().equals("begin") && !taskNode.getName().equals("end")) {
                factArray = taskNode.getPreconditions();
                n = 0;
                while (n < factArray.length) {
                    vector.addElement(factArray[n]);
                    ++n;
                }
                if (!taskNode.isConditionalNode()) {
                    factArray = taskNode.getPostconditions();
                    int n3 = 0;
                    while (n3 < factArray.length) {
                        vector.addElement(factArray[n3]);
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        factArray = new Fact[vector.size()];
        n = 0;
        while (n < vector.size()) {
            factArray[n] = new Fact((Fact)vector.elementAt(n));
            ++n;
        }
        vector = null;
        return factArray;
    }

    public boolean applyConstraints(Bindings bindings) {
        Bindings bindings2 = new Bindings(bindings);
        if (!super.applyConstraints(bindings2)) {
            return false;
        }
        int n = 0;
        while (n < this.links.size()) {
            TaskLink taskLink = (TaskLink)this.links.elementAt(n);
            String string = taskLink.getLeftNode();
            String string2 = taskLink.getRightNode();
            if (!string.equals("begin") && !string2.equals("end")) {
                Fact fact;
                TaskNode taskNode = this.getNode(string);
                TaskNode taskNode2 = this.getNode(string2);
                Fact fact2 = taskNode.getPostcondition(taskLink.getLeftGroup(), taskLink.getLeftArg());
                if (!fact2.unifiesWith(fact = taskNode2.getPrecondition(taskLink.getRightGroup(), taskLink.getRightArg()), bindings2)) {
                    return false;
                }
            }
            ++n;
        }
        if (this.resolve(bindings2)) {
            bindings.set(bindings2);
            return true;
        }
        return false;
    }

    public ResolutionContext getContext() {
        if (this.resolution_context != null) {
            return this.resolution_context;
        }
        this.resolution_context = new ResolutionContext();
        int n = 0;
        while (n < this.nodes.size()) {
            TaskNode taskNode = (TaskNode)this.nodes.elementAt(n);
            this.resolution_context.add(taskNode.produced());
            this.resolution_context.add(taskNode.consumed());
            ++n;
        }
        return this.resolution_context;
    }

    public boolean resolve(Bindings bindings) {
        ResolutionContext resolutionContext = this.getContext();
        this.time = this.time.resolve(resolutionContext, bindings);
        if (this.time == null) {
            return false;
        }
        this.cost = this.cost.resolve(resolutionContext, bindings);
        if (this.cost == null) {
            return false;
        }
        int n = 0;
        while (n < this.nodes.size()) {
            TaskNode taskNode = (TaskNode)this.nodes.elementAt(n);
            if (!taskNode.resolve(resolutionContext, bindings)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TaskNode[] getNodes() {
        TaskNode[] taskNodeArray = new TaskNode[this.nodes.size()];
        int n = 0;
        while (n < this.nodes.size()) {
            taskNodeArray[n] = new TaskNode((TaskNode)this.nodes.elementAt(n));
            ++n;
        }
        return taskNodeArray;
    }

    public void setNodes(Vector vector) {
        this.nodes.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this.nodes.addElement(new TaskNode((TaskNode)vector.elementAt(n)));
            ++n;
        }
    }

    public void setNodes(TaskNode[] taskNodeArray) {
        this.nodes.removeAllElements();
        int n = 0;
        while (n < taskNodeArray.length) {
            this.nodes.addElement(new TaskNode(taskNodeArray[n]));
            ++n;
        }
    }

    public TaskLink[] getLinks() {
        TaskLink[] taskLinkArray = new TaskLink[this.links.size()];
        int n = 0;
        while (n < this.links.size()) {
            taskLinkArray[n] = new TaskLink((TaskLink)this.links.elementAt(n));
            ++n;
        }
        return taskLinkArray;
    }

    public void setLinks(Vector vector) {
        this.links.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this.links.addElement(new TaskLink((TaskLink)vector.elementAt(n)));
            ++n;
        }
    }

    public void setLinks(TaskLink[] taskLinkArray) {
        this.links.removeAllElements();
        int n = 0;
        while (n < taskLinkArray.length) {
            this.links.addElement(new TaskLink(taskLinkArray[n]));
            ++n;
        }
    }

    public boolean isValid() {
        return true;
    }

    public String toString() {
        int n;
        String string = "(:" + AbstractTask.TaskTypes[this.type] + " " + this.name + " ";
        string = string + ":is_autorun " + this.autorun + " ";
        string = string + ":time (" + this.time + ") ";
        string = string + ":cost (" + this.cost + ") ";
        if (!this.nodes.isEmpty()) {
            string = string + ":nodes (";
            n = 0;
            while (n < this.nodes.size()) {
                string = string + this.nodes.elementAt(n);
                ++n;
            }
            string = string + ") ";
        }
        if (!this.links.isEmpty()) {
            string = string + ":links (";
            n = 0;
            while (n < this.links.size()) {
                string = string + this.links.elementAt(n);
                ++n;
            }
            string = string + ") ";
        }
        if (!this.constraints.isEmpty()) {
            string = string + ":constraints (";
            n = 0;
            while (n < this.constraints.size()) {
                string = string + "(" + this.constraints.elementAt(n) + ")";
                ++n;
            }
            string = string + ") ";
        }
        return string.trim() + ")";
    }

    public String pprint(int n) {
        int n2;
        String string;
        String string2;
        String string3 = Misc.spaces(n);
        String string4 = "\n" + string3 + " ";
        String string5 = "(:" + AbstractTask.TaskTypes[this.type] + " " + this.name + string4;
        string5 = string5 + ":is_autorun " + this.autorun + string4;
        string5 = string5 + ":time (" + this.time + ")" + string4;
        string5 = string5 + ":cost (" + this.cost + ")" + string4;
        if (!this.nodes.isEmpty()) {
            string2 = ":nodes ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            n2 = 0;
            while (n2 < this.nodes.size()) {
                string5 = string5 + ((TaskNode)this.nodes.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
                ++n2;
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.links.isEmpty()) {
            string2 = ":links ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            n2 = 0;
            while (n2 < this.links.size()) {
                string5 = string5 + ((TaskLink)this.links.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
                ++n2;
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.constraints.isEmpty()) {
            string2 = ":constraints ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(" + "\n" + string + " ";
            n2 = 0;
            while (n2 < this.constraints.size()) {
                string5 = string5 + "(" + (LogicalFn)this.constraints.elementAt(n2) + ")" + "\n" + string + " ";
                ++n2;
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        return string3 + string5.trim() + "\n" + string3 + ")";
    }

    public AbstractTask duplicate(DuplicationTable duplicationTable) {
        TaskNode[] taskNodeArray = new TaskNode[this.nodes.size()];
        TaskLink[] taskLinkArray = new TaskLink[this.links.size()];
        LogicalFn[] logicalFnArray = new LogicalFn[this.constraints.size()];
        ValueFunction valueFunction = this.time.duplicate(duplicationTable);
        ValueFunction valueFunction2 = this.cost.duplicate(duplicationTable);
        int n = 0;
        while (n < this.nodes.size()) {
            taskNodeArray[n] = ((TaskNode)this.nodes.elementAt(n)).duplicate(duplicationTable);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.links.size()) {
            taskLinkArray[n2] = ((TaskLink)this.links.elementAt(n2)).duplicate(duplicationTable);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.constraints.size()) {
            logicalFnArray[n3] = (LogicalFn)((LogicalFn)this.constraints.elementAt(n3)).duplicate(duplicationTable);
            ++n3;
        }
        return new SummaryTask(this.name, valueFunction, valueFunction2, taskNodeArray, taskLinkArray, logicalFnArray);
    }
}

