/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Summary;
import zeus.util.Assert;

public class SummaryTable
extends Hashtable {
    public void add(String string) {
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.put(string, hashtable);
        }
    }

    public void del(String string) {
        this.remove(string);
    }

    public String[] listAgents() {
        String[] stringArray = new String[this.size()];
        Enumeration enumeration = this.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String[][] getData(String string) {
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null || hashtable.isEmpty()) {
            return null;
        }
        String[][] stringArray = new String[hashtable.size()][];
        Enumeration enumeration = hashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Summary summary = (Summary)enumeration.nextElement();
            stringArray[n] = summary.summarize();
            ++n;
        }
        return stringArray;
    }

    public Summary getData(String string, String string2) {
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null || hashtable.isEmpty()) {
            return null;
        }
        return (Summary)hashtable.get(string2);
    }

    public void add(String string, Summary summary) {
        String string2 = summary.getId();
        Hashtable<String, Summary> hashtable = (Hashtable<String, Summary>)this.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Summary>();
            this.put(string, hashtable);
        }
        hashtable.put(string2, summary);
    }

    public void add(String string, Vector vector) {
        Hashtable<String, Summary> hashtable = (Hashtable<String, Summary>)this.get(string);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Summary>();
            this.put(string, hashtable);
        }
        int n = 0;
        while (n < vector.size()) {
            Summary summary = (Summary)vector.elementAt(n);
            String string2 = summary.getId();
            hashtable.put(string2, summary);
            ++n;
        }
    }

    public void del(String string, Summary summary) {
        String string2 = summary.getId();
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null) {
            Assert.notNull(null);
            return;
        }
        Assert.notNull(hashtable.remove(string2));
    }

    public void del(String string, Vector vector) {
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null) {
            Assert.notNull(null);
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Summary summary = (Summary)vector.elementAt(n);
            String string2 = summary.getId();
            Assert.notNull(hashtable.remove(string2));
            ++n;
        }
    }

    public void modify(String string, Summary summary) {
        String string2 = summary.getId();
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null) {
            Assert.notNull(null);
            return;
        }
        Assert.notNull(hashtable.put(string2, summary));
    }

    public void modify(String string, Vector vector) {
        Hashtable hashtable = (Hashtable)this.get(string);
        if (hashtable == null) {
            Assert.notNull(null);
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Summary summary = (Summary)vector.elementAt(n);
            String string2 = summary.getId();
            Assert.notNull(hashtable.put(string2, summary));
            ++n;
        }
    }
}

