/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.AbstractTask;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.Fact;
import zeus.concepts.Ordering;
import zeus.concepts.ResolutionContext;
import zeus.concepts.Task;
import zeus.concepts.fn.LogicalFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Assert;
import zeus.util.Misc;

public class PrimitiveTask
extends Task {
    protected Vector consumed = new Vector();
    protected Vector produced = new Vector();
    protected Vector ordering = new Vector();
    public transient Vector _produced = null;
    protected int active_effect = -1;
    protected String external = null;

    public PrimitiveTask() {
        this.type = 0;
    }

    public PrimitiveTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, Fact[] factArray, Fact[] factArray2, LogicalFn[] logicalFnArray, Ordering[] orderingArray) {
        this();
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setPostconditions(factArray);
        this.setPreconditions(factArray2);
        this.setConstraints(logicalFnArray);
        this.setOrdering(orderingArray);
    }

    public PrimitiveTask(String string, String string2, String string3, Fact[] factArray, Fact[] factArray2, LogicalFn[] logicalFnArray, Ordering[] orderingArray) {
        this();
        this.setName(string);
        this.setTimeFn(string2);
        this.setCostFn(string3);
        this.setPostconditions(factArray);
        this.setPreconditions(factArray2);
        this.setConstraints(logicalFnArray);
        this.setOrdering(orderingArray);
    }

    public PrimitiveTask(String string, ValueFunction valueFunction, ValueFunction valueFunction2, Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        this();
        this.setName(string);
        this.setTimeFn(valueFunction);
        this.setCostFn(valueFunction2);
        this.setPostconditions(vector);
        this.setPreconditions(vector2);
        this.setConstraints(vector3);
        this.setOrdering(vector4);
    }

    public PrimitiveTask(PrimitiveTask primitiveTask) {
        this();
        this.name = primitiveTask.getName();
        this.cost = primitiveTask.getCostFn();
        this.time = primitiveTask.getTimeFn();
        this.setPostconditions(primitiveTask.getPostconditions());
        this.setPreconditions(primitiveTask.getPreconditions());
        this.setConstraints(primitiveTask.getConstraints());
        this.setOrdering(primitiveTask.getOrdering());
        this.setActiveEffect(primitiveTask.getActiveEffectPos());
    }

    public boolean hasExternal() {
        return this.external != null;
    }

    public String getExternal() {
        return this.external;
    }

    public void setExternal(String string) {
        this.external = string;
    }

    public void setPostconditions(Vector vector) {
        this.produced.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this.produced.addElement(new Fact((Fact)vector.elementAt(n)));
            ++n;
        }
    }

    public void setPostconditions(Fact[] factArray) {
        this.produced.removeAllElements();
        int n = 0;
        while (n < factArray.length) {
            this.produced.addElement(new Fact(factArray[n]));
            ++n;
        }
    }

    public void setPreconditions(Vector vector) {
        this.consumed.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this.consumed.addElement(new Fact((Fact)vector.elementAt(n)));
            ++n;
        }
    }

    public void setPreconditions(Fact[] factArray) {
        this.consumed.removeAllElements();
        int n = 0;
        while (n < factArray.length) {
            this.consumed.addElement(new Fact(factArray[n]));
            ++n;
        }
    }

    public Fact[] getPostconditions() {
        Fact[] factArray = new Fact[this.produced.size()];
        int n = 0;
        while (n < this.produced.size()) {
            factArray[n] = new Fact((Fact)this.produced.elementAt(n));
            ++n;
        }
        return factArray;
    }

    public Fact[] getOriginalPostconditions() {
        if (this._produced == null) {
            return this.getPostconditions();
        }
        Fact[] factArray = new Fact[this._produced.size()];
        int n = 0;
        while (n < this._produced.size()) {
            factArray[n] = new Fact((Fact)this._produced.elementAt(n));
            ++n;
        }
        return factArray;
    }

    public void preprocess() {
        Fact fact;
        boolean bl = false;
        int n = 0;
        while (!bl && n < this.consumed.size()) {
            fact = (Fact)this.consumed.elementAt(n);
            bl = fact.isReplaced();
            ++n;
        }
        if (!bl) {
            return;
        }
        this._produced = Misc.copyVector(this.produced);
        int n2 = 0;
        while (n2 < this.consumed.size()) {
            fact = (Fact)this.consumed.elementAt(n2);
            if (fact.isReplaced()) {
                this.produced.addElement(fact);
            }
            ++n2;
        }
    }

    public int countPreconditions() {
        return this.consumed.size();
    }

    public int countPostconditions() {
        return this.produced.size();
    }

    public int[] numPreconditions() {
        int[] nArray = new int[this.consumed.size()];
        int n = 0;
        while (n < this.consumed.size()) {
            nArray[n] = ((Fact)this.consumed.elementAt(n)).getNumber();
            ++n;
        }
        return nArray;
    }

    public int[] numPostconditions() {
        int[] nArray = new int[this.produced.size()];
        int n = 0;
        while (n < this.produced.size()) {
            nArray[n] = ((Fact)this.produced.elementAt(n)).getNumber();
            ++n;
        }
        return nArray;
    }

    public Fact[] getPreconditions() {
        Fact[] factArray = new Fact[this.consumed.size()];
        int n = 0;
        while (n < this.consumed.size()) {
            factArray[n] = new Fact((Fact)this.consumed.elementAt(n));
            ++n;
        }
        return factArray;
    }

    public Fact getPrecondition(String string) {
        int n = 0;
        while (n < this.consumed.size()) {
            Fact fact = (Fact)this.consumed.elementAt(n);
            if (string.equals(fact.getId())) {
                return fact;
            }
            ++n;
        }
        return null;
    }

    public Fact getPostcondition(String string) {
        int n = 0;
        while (n < this.produced.size()) {
            Fact fact = (Fact)this.produced.elementAt(n);
            if (string.equals(fact.getId())) {
                return fact;
            }
            ++n;
        }
        return null;
    }

    public Fact getPrecondition(int n) {
        return (Fact)this.consumed.elementAt(n);
    }

    public Fact getPostcondition(int n) {
        return (Fact)this.produced.elementAt(n);
    }

    public int getConsumedPos(Fact fact) {
        String string = fact.getId();
        int n = 0;
        while (n < this.consumed.size()) {
            Fact fact2 = (Fact)this.consumed.elementAt(n);
            if (string.equals(fact2.getId())) {
                return n;
            }
            ++n;
        }
        Assert.notNull(null);
        return -1;
    }

    public int getProducedPos(Fact fact) {
        String string = fact.getId();
        int n = 0;
        while (n < this.produced.size()) {
            Fact fact2 = (Fact)this.produced.elementAt(n);
            if (string.equals(fact2.getId())) {
                return n;
            }
            ++n;
        }
        Assert.notNull(null);
        return -1;
    }

    public void relaxNumberFields() {
        ValueFunction valueFunction;
        Fact fact;
        int n = 0;
        while (n < this.consumed.size()) {
            fact = (Fact)this.consumed.elementAt(n);
            if (fact.isa("Entity") && (valueFunction = fact.getFn("number")).getID() == 14) {
                fact.setValue("number", fact.newVar());
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.produced.size()) {
            fact = (Fact)this.produced.elementAt(n2);
            if (fact.isa("Entity") && (valueFunction = fact.getFn("number")).getID() == 14) {
                fact.setValue("number", fact.newVar());
            }
            ++n2;
        }
    }

    public void setOrdering(Vector vector) {
        this.ordering.removeAllElements();
        int n = 0;
        while (n < vector.size()) {
            this.ordering.addElement(new Ordering((Ordering)vector.elementAt(n)));
            ++n;
        }
    }

    public void setOrdering(Ordering[] orderingArray) {
        this.ordering.removeAllElements();
        int n = 0;
        while (n < orderingArray.length) {
            this.ordering.addElement(new Ordering(orderingArray[n]));
            ++n;
        }
    }

    public Ordering[] getOrdering() {
        Ordering[] orderingArray = new Ordering[this.ordering.size()];
        int n = 0;
        while (n < this.ordering.size()) {
            orderingArray[n] = new Ordering((Ordering)this.ordering.elementAt(n));
            ++n;
        }
        return orderingArray;
    }

    public boolean resolve(Bindings bindings) {
        boolean bl = true;
        ResolutionContext resolutionContext = this.getContext();
        this.time = this.time.resolve(resolutionContext, bindings);
        if (this.time == null) {
            return false;
        }
        this.cost = this.cost.resolve(resolutionContext, bindings);
        if (this.cost == null) {
            return false;
        }
        int n = 0;
        while (bl && n < this.consumed.size()) {
            bl &= ((Fact)this.consumed.elementAt(n)).resolve(resolutionContext, bindings);
            ++n;
        }
        if (!bl) {
            return bl;
        }
        int n2 = 0;
        while (bl && n2 < this.produced.size()) {
            bl &= ((Fact)this.produced.elementAt(n2)).resolve(resolutionContext, bindings);
            ++n2;
        }
        return bl;
    }

    public ResolutionContext getContext() {
        if (this.resolution_context != null) {
            return this.resolution_context;
        }
        this.resolution_context = new ResolutionContext();
        this.resolution_context.add(this.produced);
        this.resolution_context.add(this.consumed);
        return this.resolution_context;
    }

    public boolean applyConstraints(Bindings bindings) {
        Bindings bindings2 = new Bindings(bindings);
        if (!super.applyConstraints(bindings2)) {
            return false;
        }
        return this.resolve(bindings2) && bindings.add(bindings2);
    }

    public Fact[][] orderPreconditions() {
        int n;
        int n2;
        if (this.ordering.isEmpty()) {
            Fact[][] factArray = new Fact[1][this.consumed.size()];
            int n3 = 0;
            while (n3 < this.consumed.size()) {
                factArray[0][n3] = (Fact)this.consumed.elementAt(n3);
                ++n3;
            }
            return factArray;
        }
        Vector vector = new Vector();
        Vector<Fact> vector2 = new Vector<Fact>();
        Vector<Fact> vector3 = new Vector<Fact>();
        Vector vector4 = new Vector();
        int n4 = 0;
        while (n4 < this.consumed.size()) {
            vector2.addElement((Fact)this.consumed.elementAt(n4));
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.ordering.size()) {
            vector4.addElement(this.ordering.elementAt(n5));
            ++n5;
        }
        while (!vector4.isEmpty()) {
            Ordering ordering;
            String string;
            Fact fact;
            int n6 = 0;
            while (n6 < vector2.size()) {
                fact = (Fact)vector2.elementAt(n6);
                string = fact.getId();
                n2 = 0;
                while (n2 < vector4.size()) {
                    ordering = (Ordering)vector4.elementAt(n2);
                    if (string.equals(ordering.getRHS())) {
                        vector3.addElement(fact);
                        vector2.removeElementAt(n6--);
                        break;
                    }
                    ++n2;
                }
                ++n6;
            }
            n2 = 0;
            while (n2 < vector2.size()) {
                fact = (Fact)vector2.elementAt(n2);
                string = fact.getId();
                n = 0;
                while (n < vector4.size()) {
                    ordering = (Ordering)vector4.elementAt(n);
                    if (string.equals(ordering.getLHS())) {
                        vector4.removeElementAt(n--);
                    }
                    ++n;
                }
                ++n2;
            }
            vector.addElement(vector2);
            vector2 = vector3;
            vector3 = new Vector();
        }
        if (!vector2.isEmpty()) {
            vector.addElement(vector2);
        }
        Fact[][] factArray = new Fact[vector.size()][];
        n2 = 0;
        while (n2 < vector.size()) {
            vector2 = (Vector<Fact>)vector.elementAt(n2);
            factArray[n2] = new Fact[vector2.size()];
            n = 0;
            while (n < vector2.size()) {
                factArray[n2][n] = (Fact)vector2.elementAt(n);
                ++n;
            }
            ++n2;
        }
        return factArray;
    }

    public String toString() {
        int n;
        String string = "(:" + AbstractTask.TaskTypes[this.type] + " " + this.name + " ";
        string = string + ":time (" + this.time + ") ";
        string = string + ":cost (" + this.cost + ") ";
        if (!this.consumed.isEmpty()) {
            string = string + ":consumed_facts (";
            n = 0;
            while (n < this.consumed.size()) {
                string = string + this.consumed.elementAt(n);
                ++n;
            }
            string = string + ") ";
        }
        if (!this.produced.isEmpty()) {
            string = string + ":produced_facts (";
            n = 0;
            while (n < this.produced.size()) {
                string = string + this.produced.elementAt(n);
                ++n;
            }
            string = string + ") ";
        }
        if (!this.constraints.isEmpty()) {
            string = string + ":constraints (";
            n = 0;
            while (n < this.constraints.size()) {
                string = string + "(" + this.constraints.elementAt(n) + ")";
                ++n;
            }
            string = string + ") ";
        }
        if (!this.ordering.isEmpty()) {
            string = string + ":ordering (";
            n = 0;
            while (n < this.ordering.size()) {
                string = string + this.ordering.elementAt(n);
                ++n;
            }
            string = string + ") ";
        }
        return string.trim() + ")";
    }

    public String pprint(int n) {
        int n2;
        String string;
        String string2;
        String string3 = Misc.spaces(n);
        String string4 = "\n" + string3 + " ";
        String string5 = "(:" + AbstractTask.TaskTypes[this.type] + " " + this.name + string4;
        string5 = string5 + ":time (" + this.time + ")" + string4;
        string5 = string5 + ":cost (" + this.cost + ")" + string4;
        if (!this.consumed.isEmpty()) {
            string2 = ":consumed_facts ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            n2 = 0;
            while (n2 < this.consumed.size()) {
                string5 = string5 + ((Fact)this.consumed.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
                ++n2;
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.produced.isEmpty()) {
            string2 = ":produced_facts ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            n2 = 0;
            while (n2 < this.produced.size()) {
                string5 = string5 + ((Fact)this.produced.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
                ++n2;
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.constraints.isEmpty()) {
            string2 = ":constraints ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(" + "\n" + string + " ";
            n2 = 0;
            while (n2 < this.constraints.size()) {
                string5 = string5 + "(" + this.constraints.elementAt(n2) + ")" + "\n" + string + " ";
                ++n2;
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        if (!this.ordering.isEmpty()) {
            string2 = ":ordering ";
            string = Misc.spaces(1 + n + string2.length());
            string5 = string5 + string2 + "(";
            n2 = 0;
            while (n2 < this.ordering.size()) {
                string5 = string5 + ((Ordering)this.ordering.elementAt(n2)).pprint(1 + string.length()) + "\n" + string + " ";
                ++n2;
            }
            string5 = string5.trim() + "\n" + string + ")" + string4;
        }
        return string3 + string5.trim() + "\n" + string3 + ")";
    }

    public boolean isValid() {
        return true;
    }

    public void setActiveEffect(int n) {
        Assert.notFalse(n >= -1 && n < this.produced.size());
        this.active_effect = n;
    }

    public Fact getActiveEffect() {
        return this.getPostcondition(this.active_effect);
    }

    public int getActiveEffectPos() {
        return this.active_effect;
    }

    public AbstractTask duplicate(DuplicationTable duplicationTable) {
        Fact[] factArray = new Fact[this.consumed.size()];
        Fact[] factArray2 = new Fact[this.produced.size()];
        LogicalFn[] logicalFnArray = new LogicalFn[this.constraints.size()];
        Ordering[] orderingArray = new Ordering[this.ordering.size()];
        ValueFunction valueFunction = this.time.duplicate(duplicationTable);
        ValueFunction valueFunction2 = this.cost.duplicate(duplicationTable);
        int n = 0;
        while (n < this.consumed.size()) {
            factArray[n] = ((Fact)this.consumed.elementAt(n)).duplicate(duplicationTable);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.produced.size()) {
            factArray2[n2] = ((Fact)this.produced.elementAt(n2)).duplicate(duplicationTable);
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.constraints.size()) {
            logicalFnArray[n3] = (LogicalFn)((LogicalFn)this.constraints.elementAt(n3)).duplicate(duplicationTable);
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.ordering.size()) {
            orderingArray[n4] = ((Ordering)this.ordering.elementAt(n4)).duplicate(duplicationTable);
            ++n4;
        }
        PrimitiveTask primitiveTask = new PrimitiveTask(this.name, valueFunction, valueFunction2, factArray2, factArray, logicalFnArray, orderingArray);
        primitiveTask.setActiveEffect(this.active_effect);
        return primitiveTask;
    }
}

