/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.OutTray;
import zeus.actors.factories.TransportFactory;
import zeus.concepts.Address;
import zeus.concepts.ZeusParser;
import zeus.util.Core;
import zeus.util.HSet;
import zeus.util.Misc;
import zeus.util.Time;

public class Performative {
    public static final String[] MESSAGE_TYPES = new String[]{"accept-proposal", "agree", "cancel", "cfp", "confirm", "disconfirm", "failure", "inform", "inform-if", "inform-ref", "not-understood", "propose", "query-if", "query-ref", "refuse", "reject-proposal", "request", "request-when", "request-whenever", "subscribe", "request-forward"};
    public static final String[] MESSAGE_TYPES_UPPER = new String[]{"ACCEPT-PROPOSAL", "AGREE", "CANCEL", "CFP", "CONFIRM", "DISCONFIRM", "FAILURE", "INFORM", "INFORM-IF", "INFORM-REF", "NOT-UNDERSTOOD", "PROPOSE", "QUERY-IF", "QUERY-REF", "REFUSE", "REJECT-PROPOSAL", "REQUEST", "REQUEST-WHEN", "REQUEST-WHENEVER", "SUBSCRIBE", "REQUEST-FORWARD"};
    public static final String[] ATTRIBUTE_TYPES = new String[]{"type", "sender", "receiver", "content", "reply-with", "in-reply-to", "reply-by", "ontology", "language", "protocol", "conversation-id", "reply-to"};
    private static final int TYPE = 0;
    private static final int SENDER = 1;
    private static final int RECEIVER = 2;
    private static final int CONTENT = 3;
    private static final int REPLY_WITH = 4;
    private static final int IN_REPLY_TO = 5;
    private static final int REPLY_BY = 6;
    private static final int ONTOLOGY = 7;
    private static final int LANGUAGE = 8;
    private static final int PROTOCOL = 9;
    private static final int CONVERSATION_ID = 10;
    private static final int REPLY_TO = 11;
    protected String type;
    protected String sender;
    protected HSet receivers = new HSet();
    protected String content;
    protected String replyWith;
    protected String inReplyTo;
    protected String replyBy;
    protected String ontology;
    protected String language;
    protected String protocol;
    protected String conversationId;
    protected Hashtable envelope = new Hashtable();
    protected String replyTo;
    StringBuffer sb;

    public Performative() {
    }

    public Performative(String string) {
        this.setType(string);
    }

    public Performative(Performative performative) {
        Hashtable hashtable;
        Enumeration enumeration;
        String string = performative.getType();
        if (string != null) {
            this.setType(string);
        }
        if ((string = performative.getSender()) != null) {
            this.setSender(string);
        }
        if ((enumeration = performative.getReceivers()) != null) {
            this.setReceivers(enumeration);
        }
        if ((string = performative.getReplyWith()) != null) {
            this.setReplyWith(string);
        }
        if ((string = performative.getInReplyTo()) != null) {
            this.setInReplyTo(string);
        }
        if ((string = performative.getReplyBy()) != null) {
            this.setReplyBy(string);
        }
        if ((string = performative.getOntology()) != null) {
            this.setOntology(string);
        }
        if ((string = performative.getLanguage()) != null) {
            this.setLanguage(string);
        }
        if ((string = performative.getContent()) != null) {
            this.setContent(string);
        }
        if ((string = performative.getProtocol()) != null) {
            this.setProtocol(string);
        }
        if ((string = performative.getConversationId()) != null) {
            this.setConversationId(string);
        }
        if ((hashtable = performative.getEnvelope()) != null) {
            this.setEnvelope(hashtable);
        }
        if ((string = performative.getReplyTo()) != null) {
            this.setReplyTo(string);
        }
    }

    public void setType(String string) {
        if (Misc.member(string = string.trim(), MESSAGE_TYPES)) {
            this.type = string;
        } else if (Misc.member(string, MESSAGE_TYPES_UPPER)) {
            this.type = string;
        } else {
            Core.ERROR(null, 1, (Object)("Invalid Performative type: " + string));
        }
    }

    public void setSender(String string) {
        this.sender = string;
    }

    public void setReceiver(String string) {
        this.receivers.add(string);
    }

    public void setReplyWith(String string) {
        this.replyWith = string;
    }

    public void setInReplyTo(String string) {
        this.inReplyTo = string;
    }

    public void setReplyBy(String string) {
        this.replyBy = string;
    }

    public void setReplyTo(String string) {
        this.replyTo = string;
    }

    public void setOntology(String string) {
        this.ontology = string;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setProtocol(String string) {
        this.protocol = string;
    }

    public void setConversationId(String string) {
        this.conversationId = string;
    }

    public void setReceivers(Vector vector) {
        this.receivers.clear();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.receivers.add(enumeration.nextElement());
        }
    }

    public void setReceivers(HSet hSet) {
        this.receivers.clear();
        Enumeration enumeration = hSet.elements();
        while (enumeration.hasMoreElements()) {
            this.receivers.add(enumeration.nextElement());
        }
    }

    public void setReceivers(Enumeration enumeration) {
        this.receivers.clear();
        while (enumeration.hasMoreElements()) {
            this.receivers.add(enumeration.nextElement());
        }
    }

    public void setAddress(Address address) {
        this.envelope.put("address", address);
    }

    public void setSendTime(Time time) {
        this.envelope.put("sendTime", time);
    }

    public void setReceiveTime(Time time) {
        this.envelope.put("receiveTime", time);
    }

    public void setEnvelopeItem(String string, Object object) {
        this.envelope.put(string, object);
    }

    public Object getEnvelopeItem(String string) {
        return this.envelope.get(string);
    }

    public void setEnvelope(Hashtable hashtable) {
        this.envelope.clear();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            this.envelope.put(k, v);
        }
    }

    public Hashtable getEnvelope() {
        return this.envelope;
    }

    public String getType() {
        return this.type;
    }

    public String getSender() {
        return this.sender;
    }

    public String getReplyWith() {
        return this.replyWith;
    }

    public String getInReplyTo() {
        return this.inReplyTo;
    }

    public String getReplyBy() {
        return this.replyBy;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public String getOntology() {
        return this.ontology;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getContent() {
        return this.content;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getReceiver() {
        Enumeration enumeration = this.receivers.elements();
        try {
            return (String)enumeration.nextElement();
        }
        catch (Exception exception) {
            return enumeration.nextElement().toString();
        }
    }

    public Enumeration getReceivers() {
        return this.receivers.elements();
    }

    public Address getAddress() {
        Object v = this.envelope.get("address");
        if (v instanceof String) {
            Address address = ZeusParser.address((String)v);
            this.envelope.put("address", address);
            return address;
        }
        return (Address)v;
    }

    public Time getSendTime() {
        Object v = this.envelope.get("sendTime");
        if (v instanceof String) {
            Time time = new Time((String)v);
            this.envelope.put("sendTime", time);
            return time;
        }
        return (Time)v;
    }

    public Time getReceiveTime() {
        Object v = this.envelope.get("receiveTime");
        if (v instanceof String) {
            Time time = new Time((String)v);
            this.envelope.put("receiveTime", time);
            return time;
        }
        return (Time)v;
    }

    public boolean isValid() {
        return this.type != null && this.sender != null && !this.receivers.isEmpty();
    }

    public final String toString() {
        Object object;
        this.sb = new StringBuffer(300);
        this.sb.append("(");
        this.sb.append(this.type);
        this.sb.append("\n");
        if (this.sender != null) {
            this.sb.append(" :sender ");
            this.sb.append(this.sender);
            this.sb.append("\n");
        }
        if (this.receivers != null && !this.receivers.isEmpty()) {
            this.sb.append(" :receiver ");
            if (this.receivers.size() > 1) {
                this.sb.append("(");
                this.sb.append(Misc.concat(this.receivers));
                this.sb.append(")");
            } else {
                this.sb.append(Misc.concat(this.receivers));
            }
            this.sb.append("\n");
        }
        if (this.replyWith != null) {
            this.sb.append(" :reply-with ");
            this.sb.append(this.replyWith);
            this.sb.append("\n");
        }
        if (this.inReplyTo != null) {
            this.sb.append(" :in-reply-to ");
            this.sb.append(this.inReplyTo);
            this.sb.append("\n");
        }
        if (this.replyBy != null) {
            this.sb.append(" :reply-by ");
            this.sb.append(this.replyBy);
            this.sb.append("\n");
        }
        if (this.ontology != null) {
            this.sb.append(" :ontology ");
            this.sb.append(this.ontology);
            this.sb.append("\n");
        }
        if (this.language != null) {
            this.sb.append(" :language ");
            this.sb.append(this.language);
            this.sb.append("\n");
        }
        if (this.content != null) {
            this.sb.append(" :content ");
            this.sb.append("\"");
            object = Misc.escape(this.content);
            this.sb.append((String)object);
            object = null;
            this.sb.append("\"");
            this.sb.append("\n");
        }
        if (this.protocol != null) {
            this.sb.append(" :protocol ");
            this.sb.append(this.protocol);
            this.sb.append("\n");
        }
        if (this.conversationId != null) {
            this.sb.append(" :conversation-id ");
            this.sb.append(this.conversationId);
            this.sb.append("\n");
        }
        if (this.replyTo != null) {
            this.sb.append(" :reply-to ");
            this.sb.append(this.replyTo);
            this.sb.append("\n");
        }
        if (this.envelope != null && !this.envelope.isEmpty()) {
            this.sb.append(" :envelope (");
            object = this.envelope.keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Object v = this.envelope.get(string);
                this.sb.append("(");
                this.sb.append(string);
                this.sb.append(" \"");
                this.sb.append(Misc.escape(v.toString()));
                this.sb.append("\")");
            }
            this.sb.append(")");
        }
        this.sb.append(")\n");
        return this.sb.toString();
    }

    public Object getAttribute(String string) {
        switch (Misc.whichPosition(string, ATTRIBUTE_TYPES)) {
            case 0: {
                return this.type;
            }
            case 1: {
                return this.sender;
            }
            case 2: {
                return this.getReceiver();
            }
            case 3: {
                return this.content;
            }
            case 4: {
                return this.replyWith;
            }
            case 5: {
                return this.inReplyTo;
            }
            case 6: {
                return this.replyBy;
            }
            case 7: {
                return this.ontology;
            }
            case 8: {
                return this.language;
            }
            case 9: {
                return this.protocol;
            }
            case 10: {
                return this.conversationId;
            }
            case 11: {
                return this.replyTo;
            }
        }
        return this.envelope.get(string);
    }

    public void setAttribute(String string, Object object) {
        switch (Misc.whichPosition(string, ATTRIBUTE_TYPES)) {
            case 0: {
                this.setType((String)object);
                break;
            }
            case 1: {
                this.setSender((String)object);
                break;
            }
            case 2: {
                this.setReceiver((String)object);
                break;
            }
            case 3: {
                this.setContent((String)object);
                break;
            }
            case 4: {
                this.setReplyWith((String)object);
                break;
            }
            case 5: {
                this.setInReplyTo((String)object);
                break;
            }
            case 6: {
                this.setReplyBy((String)object);
                break;
            }
            case 7: {
                this.setOntology((String)object);
                break;
            }
            case 8: {
                this.setLanguage((String)object);
                break;
            }
            case 9: {
                this.setProtocol((String)object);
                break;
            }
            case 10: {
                this.setConversationId((String)object);
                break;
            }
            case 11: {
                this.setReplyTo((String)object);
                break;
            }
            default: {
                this.envelope.put(string, object);
            }
        }
    }

    public void send(AgentContext agentContext) {
        TransportFactory transportFactory = agentContext.getTransportFactory();
        try {
            OutTray outTray = transportFactory.getTransport(this.getReceiver());
            agentContext.MailBox().sendMsg(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

