/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import zeus.concepts.Summary;
import zeus.util.Assert;

public class GoalSummary
extends Summary {
    public static String DISCRETE = "Discrete";
    public static String CONTINUOUS = "Continuous";
    public static String ENACTMENT = "Enactment";
    public static String RUNNING = "Running";
    public static String SUSPENDED = "Suspended";
    public static String CANCELLED = "Cancelled";
    public static String FAILED = "Failed";
    public static String COMPLETED = "Completed";
    protected String id;
    protected String type;
    protected String owner;
    protected String item;

    public GoalSummary(String string, String string2, String string3, String string4, String string5) {
        this.setId(string);
        this.setType(string2);
        this.setStatus(string3);
        this.setOwner(string4);
        this.setItem(string5);
    }

    public GoalSummary(GoalSummary goalSummary) {
        this.id = goalSummary.getId();
        this.type = goalSummary.getType();
        this.status = goalSummary.getStatus();
        this.owner = goalSummary.getOwner();
        this.item = goalSummary.getItem();
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getItem() {
        return this.item;
    }

    public String[] summarize() {
        String[] stringArray = new String[]{this.item, this.owner, this.id, this.type, this.status};
        return stringArray;
    }

    public void setId(String string) {
        Assert.notNull(string);
        this.id = string;
    }

    public void setType(String string) {
        Assert.notNull(string);
        Assert.notFalse(string.equals(DISCRETE) || string.equals(CONTINUOUS) || string.equals(ENACTMENT));
        this.type = string;
    }

    public void setStatus(String string) {
        Assert.notNull(string);
        Assert.notFalse(string.equals(RUNNING) || string.equals(SUSPENDED) || string.equals(CANCELLED) || string.equals(FAILED) || string.equals(COMPLETED) || string.equals("UNKNOWN"));
        this.status = string;
    }

    public void setOwner(String string) {
        Assert.notNull(string);
        this.owner = string;
    }

    public void setItem(String string) {
        Assert.notNull(string);
        this.item = string;
    }

    public boolean equals(GoalSummary goalSummary) {
        return this.id.equals(goalSummary.getId()) && this.type.equals(goalSummary.getType()) && this.status.equals(goalSummary.getStatus()) && this.owner.equals(goalSummary.getOwner()) && this.item.equals(goalSummary.getItem());
    }

    public String toString() {
        return "(:id " + this.id + " " + ":type " + this.type + " " + ":status " + this.status + ":owner " + this.owner + ":item " + this.item + ")";
    }
}

