/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import FIPA.AgentID;
import FIPA.Property;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import zeus.concepts.Address;
import zeus.concepts.ZeusParser;
import zeus.util.SystemProps;

public class FIPA_AID_Address
implements Address {
    private String name = null;
    private String host = null;
    private String port = new String("900");
    private String type = new String("FIPA_AID");
    private Vector addresses = new Vector();
    private String alias = null;
    private boolean forwardSet = false;

    public FIPA_AID_Address(FIPA_AID_Address fIPA_AID_Address) {
        this.name = fIPA_AID_Address.getName();
        this.host = fIPA_AID_Address.getHost();
        this.port = String.valueOf(fIPA_AID_Address.getPort());
        this.type = fIPA_AID_Address.getType();
        this.addresses = fIPA_AID_Address.getAddresses();
        this.alias = fIPA_AID_Address.getAlias();
        this.forwardSet = fIPA_AID_Address.getForwardingRuleSet();
    }

    public FIPA_AID_Address(String string) {
        this(ZeusParser.fipaAddress(string));
    }

    public FIPA_AID_Address(String string, String string2) {
        this.host = string2;
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public String getType() {
        return "FIPA_AID";
    }

    public int getPort() {
        return 900;
    }

    public String setAlias(String string) {
        if (this.alias == null) {
            this.alias = string;
        }
        return this.alias;
    }

    public void resetAlias(String string) {
        this.alias = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean equals(Address address) {
        return this.name.equals(address.getName()) && this.host.equals(address.getHost());
    }

    public boolean sameAddress(Address address) {
        return this.host.equals(address.getHost());
    }

    public String toString() {
        return "(:name " + this.name + " " + ":host \"" + this.host + "\" " + ":port " + this.port + " " + ":type " + this.type + ")";
    }

    public String toFIPAString() {
        return "agent-identifier   :name " + this.getName() + "@" + this.getHost() + " :addresses (sequence " + this.allAddresses() + ")";
    }

    public void addAddress(String string) {
        this.addresses.addElement(string);
    }

    private String allAddresses() {
        Enumeration enumeration = this.addresses.elements();
        String string = new String();
        while (enumeration.hasMoreElements()) {
            string = string + (String)enumeration.nextElement() + " ";
        }
        return string;
    }

    public Iterator iterator() {
        return this.addresses.iterator();
    }

    protected Vector getAddresses() {
        return this.addresses;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public boolean getForwardingRuleSet() {
        return this.forwardSet;
    }

    public void setForwardingRuleSet(boolean bl) {
        this.forwardSet = bl;
    }

    public AgentID getAgentID() {
        AgentID agentID = new AgentID();
        agentID.name = this.name + "@" + this.host;
        agentID.addresses = new String[this.addresses.size() + 1];
        agentID.resolvers = new AgentID[0];
        agentID.userDefinedProperties = new Property[0];
        int n = 0;
        Enumeration enumeration = this.addresses.elements();
        while (enumeration.hasMoreElements()) {
            agentID.addresses[n] = (String)enumeration.nextElement();
            ++n;
        }
        return agentID;
    }

    public String toXML() {
        String string = new String("\t\t\t<agent-identifier>\n");
        string = string + "\t\t\t\t<name>" + this.getName() + "@" + this.getHost() + "</name>\n";
        string = string + "\t\t\t\t<addresses>\n";
        Iterator iterator = this.iterator();
        if (SystemProps.FIPA_IMPLEMENTED_TIGHTLY) {
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                string = string + "\t\t\t\t\t<url>";
                string = string + string2 + "</url>\n";
            }
        } else {
            String string3 = new String();
            while (iterator.hasNext()) {
                string3 = (String)iterator.next();
            }
            string = string + "\t\t\t\t\t <url>" + string3 + "</url>";
            string = string + "\n\t\t\t\t</addresses>\n";
            string = string + "\t\t\t</agent-identifier>\n";
        }
        return string;
    }

    public void setType(String string) {
        this.type = string;
    }
}

