/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Vector;
import zeus.concepts.ContentElement;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.FIPA_Service_Description;
import zeus.concepts.SL_Util;

public class DF_Description {
    private FIPA_AID_Address name = null;
    private Vector services = new Vector();
    private Vector protocol = null;
    private Vector ontology = null;
    private Vector language = null;

    public void setName(FIPA_AID_Address fIPA_AID_Address) {
        this.name = fIPA_AID_Address;
    }

    public FIPA_AID_Address getName() {
        return this.name;
    }

    public void addService(FIPA_Service_Description fIPA_Service_Description) {
        this.services.addElement(fIPA_Service_Description);
    }

    public Vector getServices() {
        return this.services;
    }

    public void setProtocol(Vector vector) {
        this.protocol = vector;
    }

    public Vector getProtocol() {
        return this.protocol;
    }

    public void setOntology(Vector vector) {
        this.ontology = vector;
    }

    public Vector getOntology() {
        return this.ontology;
    }

    public void setLanguage(Vector vector) {
        this.language = vector;
    }

    public Vector getLanguage() {
        return this.language;
    }

    public String toString() {
        String string = new String("(df-agent-description ");
        if (this.name != null) {
            string = string + ":name (" + this.name.toFIPAString() + ") ";
        }
        if (this.services != null) {
            string = string + SL_Util.makeSet(":services", this.services);
        }
        if (this.protocol != null) {
            string = string + SL_Util.makeSet(":protocol", this.protocol);
        }
        if (this.ontology != null) {
            string = string + SL_Util.makeSet(":ontology", this.ontology);
        }
        if (this.language != null) {
            string = string + SL_Util.makeSet(":language", this.language);
        }
        string = string + ")";
        return string;
    }

    public static void main(String[] stringArray) {
        DF_Description dF_Description = new DF_Description();
        System.out.println(dF_Description.toString());
    }

    public boolean match(DF_Description dF_Description) {
        this.debug("in match");
        if (this.name != null && !dF_Description.getName().equals(this.name)) {
            this.debug("name doesnt match " + dF_Description.getName() + " " + this.name);
            return false;
        }
        if (this.services != null && !this.vecMatch(this.services, dF_Description.getServices())) {
            this.debug("services don't match ");
            return false;
        }
        if (this.protocol != null && !this.vecMatch(this.protocol, dF_Description.getProtocol())) {
            this.debug("protocols don't match");
            return false;
        }
        if (this.ontology != null && !this.vecMatch(this.ontology, dF_Description.getOntology())) {
            this.debug("ontologies don't match ");
            return false;
        }
        if (this.language != null && !this.vecMatch(this.language, dF_Description.getLanguage())) {
            this.debug("languages don't match ");
            return false;
        }
        return true;
    }

    public boolean vecMatch(Vector vector, Vector vector2) {
        this.debug("in vecMatch");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = vector2.elements();
            boolean bl = false;
            Object e = enumeration.nextElement();
            while (enumeration2.hasMoreElements() && !bl) {
                Object e2 = enumeration2.nextElement();
                if (e instanceof Vector && e2 instanceof Vector) {
                    bl = this.vecMatch((Vector)e, (Vector)e2);
                    continue;
                }
                if (e instanceof ContentElement) {
                    this.debug("is ContentElement");
                    bl = ((ContentElement)e).match((ContentElement)e2);
                    continue;
                }
                System.out.println("elementToTest = " + e2);
                System.out.println("elementToTest.toString = " + e2.toString() + " element.toString = " + e.toString());
                if (!e2.toString().equals(e.toString())) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    void debug(String string) {
        System.out.println(string);
    }
}

