/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import zeus.concepts.BindingsRecord;
import zeus.concepts.fn.IdFn;
import zeus.concepts.fn.ValueFunction;
import zeus.concepts.fn.VarFn;

public class Bindings
extends Hashtable {
    protected IdFn name = null;
    protected VarFn self = null;

    public Bindings() {
    }

    public Bindings(String string) {
        this.name = new IdFn(string);
        this.self = new VarFn("?self");
        this.set(this.self, this.name);
    }

    public Bindings(Bindings bindings) {
        this.set(bindings);
    }

    public void clear() {
        super.clear();
        if (this.self != null && this.name != null) {
            this.set(this.self, this.name);
        }
    }

    public boolean add(Bindings bindings) {
        Enumeration enumeration = bindings.elements();
        while (enumeration.hasMoreElements()) {
            BindingsRecord bindingsRecord = (BindingsRecord)enumeration.nextElement();
            if (bindingsRecord.lhs.unifiesWith(bindingsRecord.rhs, this) != null) continue;
            return false;
        }
        return true;
    }

    public void set(Bindings bindings) {
        super.clear();
        Enumeration enumeration = bindings.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            BindingsRecord bindingsRecord = (BindingsRecord)bindings.get(k);
            this.put(k, bindingsRecord);
        }
    }

    public void set(ValueFunction valueFunction, ValueFunction valueFunction2) {
        ValueFunction valueFunction3;
        if (valueFunction.equals(valueFunction2)) {
            return;
        }
        if (valueFunction.getPD() > valueFunction2.getPD()) {
            valueFunction3 = valueFunction;
            valueFunction = valueFunction2;
            valueFunction2 = valueFunction3;
        }
        if (valueFunction.isDeterminate() && !valueFunction2.isDeterminate()) {
            valueFunction3 = valueFunction;
            valueFunction = valueFunction2;
            valueFunction2 = valueFunction3;
        }
        switch (valueFunction.getID()) {
            case 1: 
            case 4: {
                this.put(valueFunction.toString(), new BindingsRecord(valueFunction, valueFunction2));
                break;
            }
            default: {
                this.put(valueFunction, new BindingsRecord(valueFunction, valueFunction2));
            }
        }
    }

    public ValueFunction lookUp(ValueFunction valueFunction) {
        BindingsRecord bindingsRecord;
        while ((bindingsRecord = this.getBindingsRecord(valueFunction)) != null) {
            if (bindingsRecord.rhs.equals(valueFunction)) {
                System.err.println("Bindings -- Loop found\n" + this);
                System.exit(0);
            }
            valueFunction = bindingsRecord.rhs;
        }
        return valueFunction;
    }

    protected BindingsRecord getBindingsRecord(ValueFunction valueFunction) {
        switch (valueFunction.getID()) {
            case 1: 
            case 4: {
                return (BindingsRecord)this.get(valueFunction.toString());
            }
        }
        return (BindingsRecord)this.get(valueFunction);
    }

    public String toString() {
        String string = new String("(");
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            BindingsRecord bindingsRecord = (BindingsRecord)enumeration.nextElement();
            string = string + bindingsRecord.lhs + "=" + bindingsRecord.rhs + " ";
        }
        return string.trim() + ")";
    }
}

