/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.concepts.Bindings;
import zeus.concepts.DuplicationTable;
import zeus.concepts.ResolutionContext;
import zeus.concepts.fn.NumericFn;
import zeus.concepts.fn.OrFn;
import zeus.concepts.fn.ValueFunction;
import zeus.util.Core;
import zeus.util.GenSym;
import zeus.util.Misc;

public class AttributeList
extends Hashtable {
    AttributeList() {
    }

    AttributeList(AttributeList attributeList) {
        this();
        Enumeration enumeration = attributeList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = attributeList.getFn(string);
            this.setValue(string, valueFunction.mirror());
        }
    }

    public String[] getNames() {
        return this.listAttributes();
    }

    public String[] listAttributes() {
        String[] stringArray = new String[this.size()];
        Enumeration enumeration = this.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    ValueFunction[] listValues() {
        ValueFunction[] valueFunctionArray = new ValueFunction[this.size()];
        Enumeration enumeration = this.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            valueFunctionArray[n] = (ValueFunction)enumeration.nextElement();
            ++n;
        }
        return valueFunctionArray;
    }

    Vector variables() {
        Vector vector = new Vector(100);
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            vector = Misc.union(vector, ((ValueFunction)enumeration.nextElement()).variables());
        }
        return vector;
    }

    public void setValue(String string, ValueFunction valueFunction) {
        this.put(string, valueFunction);
    }

    public String getValue(String string) {
        ValueFunction valueFunction = (ValueFunction)this.get(string);
        if (valueFunction != null) {
            return valueFunction.toString();
        }
        return null;
    }

    public ValueFunction getFn(String string) {
        return (ValueFunction)this.get(string);
    }

    public String toString() {
        String string = new String("(");
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)this.get(string2);
            string = string + "(" + string2 + " " + valueFunction + ")";
        }
        return string.trim() + ")";
    }

    public String toSL() {
        String string = new String("");
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)this.get(string2);
            string = string + ":" + string2 + " " + valueFunction + " ";
        }
        return string.trim();
    }

    String pprint() {
        return this.pprint(0);
    }

    String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = new String("(");
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            ValueFunction valueFunction = (ValueFunction)this.get(string4);
            string3 = string3 + "(" + string4 + " " + valueFunction + ")" + string2;
        }
        return string3.trim() + "\n" + string + ")";
    }

    boolean unifiesWith(AttributeList attributeList, Bindings bindings) {
        Bindings bindings2 = new Bindings(bindings);
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = attributeList.getFn(string);
            ValueFunction valueFunction2 = this.getFn(string);
            Core.ERROR(valueFunction, 1, (Object)this);
            Core.ERROR(valueFunction2, 2, (Object)this);
            if (!(!string.equals("number") ? valueFunction2.unifiesWith(valueFunction, bindings2) == null : (!(valueFunction2 instanceof NumericFn) || !(valueFunction instanceof NumericFn)) && valueFunction2.unifiesWith(valueFunction, bindings2) == null)) continue;
            return false;
        }
        bindings.set(bindings2);
        return true;
    }

    public boolean equals(AttributeList attributeList) {
        if (this.size() != attributeList.size()) {
            return false;
        }
        Enumeration enumeration = attributeList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = attributeList.getFn(string);
            ValueFunction valueFunction2 = this.getFn(string);
            if (valueFunction2 == null) {
                return false;
            }
            if (valueFunction.equals(valueFunction2)) continue;
            return false;
        }
        return true;
    }

    boolean isDeterminate() {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ValueFunction valueFunction = (ValueFunction)enumeration.nextElement();
            if (valueFunction.isDeterminate()) continue;
            return false;
        }
        return true;
    }

    boolean isDeterminate(String string) {
        ValueFunction valueFunction = this.getFn(string);
        return valueFunction.isDeterminate();
    }

    boolean resolve(ResolutionContext resolutionContext, Bindings bindings) {
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = this.getFn(string);
            if ((valueFunction = valueFunction.resolve(resolutionContext, bindings)) == null) {
                return false;
            }
            this.setValue(string, valueFunction);
        }
        return true;
    }

    void disjoin(AttributeList attributeList) {
        Enumeration enumeration = attributeList.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("number")) continue;
            ValueFunction valueFunction = attributeList.getFn(string);
            ValueFunction valueFunction2 = this.getFn(string);
            if (valueFunction2 == null || valueFunction.equals(valueFunction2)) {
                this.setValue(string, valueFunction);
                continue;
            }
            this.setValue(string, new OrFn(valueFunction2, valueFunction));
        }
    }

    AttributeList duplicate(String string, GenSym genSym) {
        DuplicationTable duplicationTable = new DuplicationTable(string, genSym);
        return this.duplicate(duplicationTable);
    }

    AttributeList duplicate(DuplicationTable duplicationTable) {
        AttributeList attributeList = new AttributeList();
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ValueFunction valueFunction = this.getFn(string);
            ValueFunction valueFunction2 = valueFunction.duplicate(duplicationTable);
            attributeList.setValue(string, valueFunction2);
        }
        return attributeList;
    }
}

