/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import zeus.concepts.Address;
import zeus.concepts.AddressEvent;
import zeus.concepts.AddressListener;

public class AddressBook
extends Hashtable {
    private Vector listeners = new Vector();

    public boolean add(Address address) {
        this.put(address.getName(), address);
        try {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                AddressListener addressListener = (AddressListener)iterator.next();
                AddressEvent addressEvent = new AddressEvent(address);
                addressListener.newAddress(addressEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return true;
    }

    public void replace(Address address) {
        this.put(address.getName(), address);
        try {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                AddressListener addressListener = (AddressListener)iterator.next();
                AddressEvent addressEvent = new AddressEvent(address);
                addressListener.replaceAddress(addressEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void del(Address address) {
        this.remove(address.getName());
        try {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                AddressListener addressListener = (AddressListener)iterator.next();
                AddressEvent addressEvent = new AddressEvent(address);
                addressListener.deleteAddress(addressEvent);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void del(String string) {
        this.remove(string);
    }

    public Address lookup(String string) {
        return (Address)this.get(string);
    }

    public void addAddressListener(AddressListener addressListener) {
        this.listeners.addElement(addressListener);
    }

    public void removeAddressListener(AddressListener addressListener) {
        this.listeners.removeElement(addressListener);
    }
}

