/*
 * Decompiled with CFR 0.152.
 */
package zeus.concepts;

import java.util.Vector;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Relationship;
import zeus.util.Misc;

public class Acquaintance
extends Relationship {
    protected Vector abilities = new Vector(100);

    public Acquaintance() {
    }

    public Acquaintance(Acquaintance acquaintance) {
        this.setName(acquaintance.getName());
        this.setRelation(acquaintance.getRelation());
        this.setAbilities(acquaintance.getAbilities());
    }

    public Acquaintance(String string, String string2) {
        super(string, string2);
    }

    public Acquaintance(String string, String string2, AbilitySpec[] abilitySpecArray) {
        super(string, string2);
        this.setAbilities(abilitySpecArray);
    }

    public Acquaintance(String string, String string2, Vector vector) {
        super(string, string2);
        this.setAbilities(vector);
    }

    public void setAbilities(Vector vector) {
        this.abilities.removeAllElements();
        int n = 0;
        while (vector != null && n < vector.size()) {
            this.abilities.addElement(new AbilitySpec((AbilitySpec)vector.elementAt(n)));
            ++n;
        }
    }

    public void setAbilities(AbilitySpec[] abilitySpecArray) {
        this.abilities.removeAllElements();
        int n = 0;
        while (abilitySpecArray != null && n < abilitySpecArray.length) {
            this.abilities.addElement(new AbilitySpec(abilitySpecArray[n]));
            ++n;
        }
    }

    public AbilitySpec[] getAbilities() {
        AbilitySpec[] abilitySpecArray = new AbilitySpec[this.abilities.size()];
        int n = 0;
        while (n < this.abilities.size()) {
            abilitySpecArray[n] = (AbilitySpec)this.abilities.elementAt(n);
            ++n;
        }
        return abilitySpecArray;
    }

    public String toString() {
        String string = new String("(");
        string = string + ":name " + this.name + " ";
        string = string + ":relation " + this.relation + " ";
        if (!this.abilities.isEmpty()) {
            string = string + ":abilities (";
            int n = 0;
            while (n < this.abilities.size()) {
                string = string + ((AbilitySpec)this.abilities.elementAt(n)).toString() + " ";
                ++n;
            }
            string = string.trim() + ")";
        }
        string = string.trim() + ")";
        return string;
    }

    public String pprint() {
        return this.pprint(0);
    }

    public String pprint(int n) {
        String string = Misc.spaces(n);
        String string2 = "\n" + string + " ";
        String string3 = new String("(");
        string3 = string3 + ":name " + this.name + string2;
        string3 = string3 + ":relation " + this.relation + string2;
        if (!this.abilities.isEmpty()) {
            String string4 = ":abilities ";
            String string5 = Misc.spaces(1 + n + string4.length());
            string3 = string3 + string4 + "(";
            int n2 = 0;
            while (n2 < this.abilities.size()) {
                string3 = string3 + ((AbilitySpec)this.abilities.elementAt(n2)).pprint(1 + string5.length());
                ++n2;
            }
            string3 = string3.trim() + "\n" + string5 + ")" + string2;
        }
        return string3.trim() + "\n" + string + ")";
    }
}

