/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.task;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.ZeusInternalFrame;
import zeus.agentviewer.task.ConditionsAttributeTableModel;
import zeus.agentviewer.task.ConstraintsModel;
import zeus.agentviewer.task.OrderingModel;
import zeus.agentviewer.task.TaskConditionsTableModel;
import zeus.agentviewer.task.TaskTableModel;
import zeus.gui.fields.LargeTextField;
import zeus.util.SystemProps;

public class TaskTableUI
extends ZeusInternalFrame
implements ListSelectionListener {
    final int TOP_PANE_MIN_HEIGHT = 43;
    final int TOP_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_WIDTH = 100;
    final int BOTTOM_PANE_MIN_HEIGHT = 100;
    private JPanel contentPane;
    private JTable taskTable;
    private JTable preCondTable;
    private JTable preAttrTable;
    private JTable effectsTable;
    private JTable effectsAttrTable;
    private JTable orderingTable;
    private JTable constraintsTable;
    private static int NUMBER_DISPLAYED = 0;
    private InternalFramesPanel deskTop;
    TaskTableModel taskBuffer;
    ConditionsAttributeTableModel preAttrBuffer;
    ConditionsAttributeTableModel effectsAttrBuffer;
    TaskConditionsTableModel effectsBuffer;
    TaskConditionsTableModel preCondBuffer;
    ConstraintsModel constraintsBuffer;
    OrderingModel orderingBuffer;
    LargeTextField timefield;
    LargeTextField costfield;

    public TaskTableUI(InternalFramesPanel internalFramesPanel, TaskTableModel taskTableModel, TaskConditionsTableModel taskConditionsTableModel, ConditionsAttributeTableModel conditionsAttributeTableModel, TaskConditionsTableModel taskConditionsTableModel2, ConditionsAttributeTableModel conditionsAttributeTableModel2, ConstraintsModel constraintsModel, OrderingModel orderingModel) {
        super("Task Database", true, true, true, true);
        this.setTitle("Task Database:" + ++NUMBER_DISPLAYED);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "agentviewer" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "taskdb.gif");
        this.setFrameIcon(imageIcon);
        this.deskTop = internalFramesPanel;
        this.taskBuffer = taskTableModel;
        this.preCondBuffer = taskConditionsTableModel;
        this.preAttrBuffer = conditionsAttributeTableModel;
        this.effectsBuffer = taskConditionsTableModel2;
        this.effectsAttrBuffer = conditionsAttributeTableModel2;
        this.constraintsBuffer = constraintsModel;
        this.orderingBuffer = orderingModel;
        this.buildUI();
        internalFramesPanel.addInternalFrame(this);
        this.setVisible(true);
    }

    private void buildUI() {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        jPanel.setBorder(BorderFactory.createEtchedBorder(Color.gray, Color.black));
        jPanel.add(this.getPreConditionsPanel());
        jPanel.add(this.getEffectsPanel());
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 15));
        JPanel jPanel3 = this.getTaskPanel();
        JPanel jPanel4 = this.getCostPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        jPanel2.add(jPanel4);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Preconditions and Effects", jPanel2);
        jTabbedPane.addTab("Constraints", this.getConstraintsPanel());
        jTabbedPane.setSelectedIndex(0);
        jTabbedPane.setTabPlacement(3);
        this.contentPane.add((Component)jTabbedPane, "Center");
        this.pack();
    }

    JPanel getConstraintsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(this.makeBorder("PreConditions Ordering Constraints"));
        this.orderingTable = new JTable(this.orderingBuffer);
        this.orderingTable.setPreferredScrollableViewportSize(new Dimension(500, 43));
        JScrollPane jScrollPane = new JScrollPane(this.orderingTable);
        jPanel2.add("Center", jScrollPane);
        jPanel.add("North", jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(this.makeBorder("Task Applicability Constraints"));
        this.constraintsTable = new JTable(this.constraintsBuffer);
        this.constraintsTable.setPreferredScrollableViewportSize(new Dimension(500, 43));
        JScrollPane jScrollPane2 = new JScrollPane(this.constraintsTable);
        jPanel3.add("Center", jScrollPane2);
        jPanel.add("Center", jPanel3);
        return jPanel;
    }

    JPanel getTaskPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
        this.taskTable = new JTable(this.taskBuffer);
        this.taskTable.setPreferredScrollableViewportSize(new Dimension(500, 43));
        JScrollPane jScrollPane = new JScrollPane(this.taskTable);
        this.taskTable.getSelectionModel().addListSelectionListener(this);
        this.taskTable.getSelectionModel().setSelectionMode(0);
        jPanel.add("Center", jScrollPane);
        return jPanel;
    }

    JPanel getPreConditionsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 2, 6));
        Border border = BorderFactory.createLineBorder(Color.red);
        jPanel.setBorder(this.makeBorder("PreConditions"));
        this.preCondTable = new JTable(this.preCondBuffer);
        this.preCondTable.setPreferredScrollableViewportSize(new Dimension(250, 43));
        JScrollPane jScrollPane = new JScrollPane(this.preCondTable);
        this.preCondTable.getSelectionModel().addListSelectionListener(this);
        this.preCondTable.getSelectionModel().setSelectionMode(0);
        this.preCondTable.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(jScrollPane);
        this.preAttrTable = new JTable(this.preAttrBuffer);
        this.preAttrTable.setPreferredScrollableViewportSize(new Dimension(250, 43));
        JScrollPane jScrollPane2 = new JScrollPane(this.preAttrTable);
        this.preAttrTable.getSelectionModel().addListSelectionListener(this);
        this.preAttrTable.getSelectionModel().setSelectionMode(0);
        this.preAttrTable.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(jScrollPane2);
        return jPanel;
    }

    JPanel getEffectsPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 2, 6));
        jPanel.setBorder(this.makeBorder("Effects"));
        this.effectsTable = new JTable(this.effectsBuffer);
        this.effectsTable.setPreferredScrollableViewportSize(new Dimension(250, 43));
        JScrollPane jScrollPane = new JScrollPane(this.effectsTable);
        this.effectsTable.getSelectionModel().addListSelectionListener(this);
        this.effectsTable.getSelectionModel().setSelectionMode(0);
        this.effectsTable.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(jScrollPane);
        this.effectsAttrTable = new JTable(this.effectsAttrBuffer);
        this.effectsAttrTable.setPreferredScrollableViewportSize(new Dimension(250, 43));
        JScrollPane jScrollPane2 = new JScrollPane(this.effectsAttrTable);
        this.effectsAttrTable.getSelectionModel().addListSelectionListener(this);
        this.effectsAttrTable.getSelectionModel().setSelectionMode(0);
        this.effectsAttrTable.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(jScrollPane2);
        return jPanel;
    }

    private TitledBorder makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.black);
        return titledBorder;
    }

    JPanel getCostPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Task Cost and Time");
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.black);
        jPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 5, 10));
        JLabel jLabel = new JLabel("Cost:");
        jLabel.setToolTipText("Default cost of performing this task");
        jPanel2.add(jLabel);
        jLabel = new JLabel("Time:");
        jLabel.setToolTipText("Default duration of this task");
        jPanel2.add(jLabel);
        jPanel.add("West", jPanel2);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 5, 10));
        this.costfield = new LargeTextField(2, 15);
        this.costfield.setLineWrap(true);
        this.costfield.setText("");
        this.costfield.setEditable(false);
        jPanel3.add(this.costfield);
        this.timefield = new LargeTextField(2, 15);
        this.timefield.setLineWrap(true);
        this.timefield.setText("");
        this.timefield.setEditable(false);
        jPanel3.add(this.timefield);
        jPanel.add("Center", jPanel3);
        return jPanel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() == this.taskTable.getSelectionModel()) {
            int n2 = this.taskTable.getSelectedRow();
            this.costfield.setText(this.taskBuffer.getCost(n2));
            this.timefield.setText(this.taskBuffer.getTime(n2));
            if (n2 >= 0 && n2 < this.taskBuffer.getRowCount()) {
                this.preCondBuffer.setFacts(this.taskBuffer.getPreConditions(n2));
                this.preCondTable.validate();
                this.effectsBuffer.setFacts(this.taskBuffer.getEffects(n2));
                this.effectsTable.validate();
            }
        } else if (listSelectionEvent.getSource() == this.preCondTable.getSelectionModel()) {
            int n3 = this.preCondTable.getSelectedRow();
            if (n3 >= 0 && n3 < this.preCondBuffer.getRowCount()) {
                this.preAttrBuffer.setFact(this.preCondBuffer.getFact(n3));
                this.preAttrTable.validate();
            }
        } else if (listSelectionEvent.getSource() == this.effectsTable.getSelectionModel() && (n = this.effectsTable.getSelectedRow()) >= 0 && n < this.effectsBuffer.getRowCount()) {
            this.effectsAttrBuffer.setFact(this.effectsBuffer.getFact(n));
            this.effectsAttrTable.validate();
        }
    }

    void reSize() {
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
    }
}

