/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.task;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.TaskDb;
import zeus.actors.event.TaskEvent;
import zeus.actors.event.TaskMonitor;
import zeus.concepts.Fact;
import zeus.concepts.PrimitiveTask;

public class TaskTableModel
extends AbstractTableModel
implements TaskMonitor {
    private String header = "Task";
    private Vector data = new Vector();
    private TaskDb taskDb;

    public TaskTableModel(AgentContext agentContext) {
        this.taskDb = agentContext.TaskDb();
        this.taskDb.addTaskMonitor(this, 5L, true);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return 1;
    }

    public Object getValueAt(int n, int n2) {
        PrimitiveTask primitiveTask = (PrimitiveTask)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return primitiveTask.getName();
            }
        }
        return new String("Error in TaskTableModel getValue");
    }

    public String getColumnName(int n) {
        return this.header;
    }

    public void addTask(PrimitiveTask primitiveTask) {
        if (this.data.contains(primitiveTask)) {
            return;
        }
        this.data.addElement(primitiveTask);
        this.fireTableDataChanged();
    }

    public void removeTask(PrimitiveTask primitiveTask) {
        if (!this.data.contains(primitiveTask)) {
            return;
        }
        this.data.removeElement(primitiveTask);
        this.fireTableDataChanged();
    }

    public Fact[] getEffects(int n) {
        PrimitiveTask primitiveTask = (PrimitiveTask)this.data.elementAt(n);
        return primitiveTask.getPostconditions();
    }

    public Fact[] getPreConditions(int n) {
        PrimitiveTask primitiveTask = (PrimitiveTask)this.data.elementAt(n);
        return primitiveTask.getPreconditions();
    }

    public void taskAddedEvent(TaskEvent taskEvent) {
        if (!taskEvent.getTask().isPrimitive()) {
            return;
        }
        this.addTask((PrimitiveTask)taskEvent.getTask());
    }

    public void taskModifiedEvent(TaskEvent taskEvent) {
    }

    public void taskDeletedEvent(TaskEvent taskEvent) {
        this.removeTask((PrimitiveTask)taskEvent.getTask());
    }

    public void taskAccessedEvent(TaskEvent taskEvent) {
    }

    public void removeZeusEventMonitors() {
        this.taskDb.removeTaskMonitor(this, 5L);
    }

    public String getCost(int n) {
        PrimitiveTask primitiveTask = (PrimitiveTask)this.data.elementAt(n);
        return primitiveTask.getCostFn().toString();
    }

    public String getTime(int n) {
        PrimitiveTask primitiveTask = (PrimitiveTask)this.data.elementAt(n);
        return primitiveTask.getTimeFn().toString();
    }
}

