/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.resources;

import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.ResourceDb;
import zeus.actors.event.FactEvent;
import zeus.actors.event.FactMonitor;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.ResourceItem;

public class ResourceTableModel
extends AbstractTableModel
implements FactMonitor {
    static final int TYPE = 0;
    static final int ID = 1;
    static final int STATUS = 2;
    private String[] header = new String[]{"Type", "Id", "Status"};
    private Vector data;
    public ResourceDb resDB;
    public OntologyDb ontologyDb;
    protected EventListenerList changeListeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public ResourceTableModel(AgentContext agentContext) {
        this.data = new Vector();
        this.resDB = agentContext.ResourceDb();
        this.ontologyDb = agentContext.OntologyDb();
        this.resDB.addFactMonitor(this, 7L, true);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public String getColumnName(int n) {
        return this.header[n];
    }

    public Object getValueAt(int n, int n2) {
        ResourceItem resourceItem = (ResourceItem)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return resourceItem.getFact().getType();
            }
            case 1: {
                return resourceItem.getFact().getId();
            }
            case 2: {
                return resourceItem.isReserved() ? "RESERVED" : "UNRESERVED";
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Fact getAttributesOf(int n) {
        return ((ResourceItem)this.data.elementAt(n)).getFact();
    }

    public void factAddedEvent(FactEvent factEvent) {
        if (!this.data.contains(factEvent.getObject())) {
            this.data.addElement(factEvent.getObject());
        }
        this.fireTableDataChanged();
        this.fireChanged();
    }

    public void factModifiedEvent(FactEvent factEvent) {
        this.fireTableDataChanged();
        this.fireChanged();
    }

    public void factDeletedEvent(FactEvent factEvent) {
        this.data.removeElement(factEvent.getObject());
        this.fireTableDataChanged();
        this.fireChanged();
    }

    public void factAccessedEvent(FactEvent factEvent) {
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ResourceTableModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = ResourceTableModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? ResourceTableModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    public void removeZeusEventMonitors() {
        this.resDB.removeFactMonitor(this, 7L);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

