/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.protocol;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.ZeusInternalFrame;
import zeus.agentviewer.protocol.AttributesModel;
import zeus.agentviewer.protocol.CheckBoxCellRenderer;
import zeus.agentviewer.protocol.FriendlyRenderer;
import zeus.agentviewer.protocol.HashtableCellRenderer;
import zeus.agentviewer.protocol.ProtocolModel;
import zeus.agentviewer.protocol.StrategyModel;
import zeus.agentviewer.protocol.StringArrayCellRenderer;
import zeus.util.SystemProps;

public class ProtocolUI
extends ZeusInternalFrame
implements ListSelectionListener {
    final int TOP_PANE_MIN_HEIGHT = 43;
    final int TOP_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_WIDTH = 100;
    final int BOTTOM_PANE_MIN_HEIGHT = 100;
    private JPanel contentPane;
    private JTable protocolTable;
    private JTable strategyTable;
    private JTable attributesTable;
    private static int NUMBER_DISPLAYED = 0;
    private InternalFramesPanel deskTop;
    ProtocolModel protocolBuffer;
    StrategyModel strategyBuffer;
    AttributesModel attributesBuffer;

    public ProtocolUI(InternalFramesPanel internalFramesPanel, ProtocolModel protocolModel, StrategyModel strategyModel, AttributesModel attributesModel) {
        super(" ", true, true, true, true);
        this.setTitle("Protocols & Strategies:" + ++NUMBER_DISPLAYED);
        String string = System.getProperty("file.separator");
        String string2 = SystemProps.getProperty("gif.dir") + "agentviewer" + string;
        ImageIcon imageIcon = new ImageIcon(string2 + "protocol.gif");
        this.setFrameIcon(imageIcon);
        this.deskTop = internalFramesPanel;
        this.protocolBuffer = protocolModel;
        this.strategyBuffer = strategyModel;
        this.attributesBuffer = attributesModel;
        this.buildUI();
        internalFramesPanel.addInternalFrame(this);
        this.setVisible(true);
    }

    private void buildUI() {
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.setBorder(BorderFactory.createEtchedBorder(Color.gray, Color.black));
        this.contentPane.add("North", this.getProtocolPanel());
        this.contentPane.add("Center", this.getStrategyPanel());
        this.pack();
    }

    JPanel getProtocolPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.makeBorder("Known Protocols"));
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 24);
        tableColumn.setHeaderValue(this.protocolBuffer.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 24);
        tableColumn.setCellRenderer(new FriendlyRenderer());
        tableColumn.setHeaderValue(this.protocolBuffer.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 8);
        tableColumn.setCellRenderer(new CheckBoxCellRenderer());
        tableColumn.setHeaderValue(this.protocolBuffer.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        this.protocolTable = new JTable(this.protocolBuffer, defaultTableColumnModel);
        this.protocolTable.setPreferredScrollableViewportSize(new Dimension(500, 43));
        this.protocolTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.protocolTable);
        this.protocolTable.getSelectionModel().addListSelectionListener(this);
        this.protocolTable.getSelectionModel().setSelectionMode(0);
        jPanel.add("Center", jScrollPane);
        TableColumn tableColumn2 = this.protocolTable.getColumnModel().getColumn(1);
        TableColumn tableColumn3 = this.protocolTable.getColumnModel().getColumn(0);
        tableColumn3.setPreferredWidth(tableColumn2.getPreferredWidth() * 3);
        return jPanel;
    }

    JPanel getStrategyPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 1, 2, 6));
        jPanel.setBorder(this.makeBorder("Coordination Strategies"));
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 4);
        tableColumn.setCellRenderer(new CheckBoxCellRenderer());
        tableColumn.setHeaderValue(this.strategyBuffer.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(2, 24);
        tableColumn.setCellRenderer(new StringArrayCellRenderer());
        tableColumn.setHeaderValue(this.strategyBuffer.getColumnName(2));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(3, 24);
        tableColumn.setCellRenderer(new StringArrayCellRenderer());
        tableColumn.setHeaderValue(this.strategyBuffer.getColumnName(3));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(4, 24);
        tableColumn.setCellRenderer(new FriendlyRenderer());
        tableColumn.setHeaderValue(this.strategyBuffer.getColumnName(4));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 12);
        tableColumn.setHeaderValue(this.strategyBuffer.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        tableColumn = new TableColumn(5, 24);
        tableColumn.setCellRenderer(new HashtableCellRenderer());
        tableColumn.setHeaderValue(this.strategyBuffer.getColumnName(5));
        defaultTableColumnModel.addColumn(tableColumn);
        this.strategyTable = new JTable(this.strategyBuffer, defaultTableColumnModel);
        this.strategyTable.setPreferredScrollableViewportSize(new Dimension(250, 43));
        this.strategyTable.getTableHeader().setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.strategyTable);
        this.strategyTable.getSelectionModel().addListSelectionListener(this);
        this.strategyTable.getSelectionModel().setSelectionMode(0);
        this.strategyTable.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(jScrollPane);
        this.attributesTable = new JTable(this.attributesBuffer);
        this.attributesTable.setPreferredScrollableViewportSize(new Dimension(250, 43));
        JScrollPane jScrollPane2 = new JScrollPane(this.attributesTable);
        this.attributesTable.setBorder(BorderFactory.createLineBorder(Color.black));
        jPanel.add(jScrollPane2);
        return jPanel;
    }

    private TitledBorder makeBorder(String string) {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
        titledBorder.setTitlePosition(2);
        titledBorder.setTitleJustification(3);
        titledBorder.setTitleFont(new Font("Helvetica", 1, 12));
        titledBorder.setTitleColor(Color.black);
        return titledBorder;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getSource() == this.protocolTable.getSelectionModel()) {
            int n2 = this.protocolTable.getSelectedRow();
            if (n2 >= 0 && n2 < this.protocolBuffer.getRowCount()) {
                this.strategyBuffer.setStrategies(this.protocolBuffer.getStrategyInfos(n2));
                this.attributesBuffer.setFact(this.strategyBuffer.getFact(0));
            }
        } else if (listSelectionEvent.getSource() == this.strategyTable.getSelectionModel() && (n = this.strategyTable.getSelectedRow()) >= 0 && n < this.strategyBuffer.getRowCount()) {
            this.attributesBuffer.setFact(this.strategyBuffer.getFact(n));
        }
    }

    void reSize() {
        this.setSize(this.getWidth() + 1, this.getHeight());
        this.setSize(this.getWidth() - 1, this.getHeight());
    }
}

