/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.protocol;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.ProtocolDb;
import zeus.actors.event.ProtocolEvent;
import zeus.actors.event.ProtocolMonitor;
import zeus.concepts.ProtocolInfo;
import zeus.concepts.StrategyInfo;

public class ProtocolModel
extends AbstractTableModel
implements ProtocolMonitor {
    public static final int TYPE = 0;
    public static final int PROTOCOL = 1;
    public static final int STATE = 2;
    private String[] columnNames = new String[]{"Type", "Protocol", "State"};
    private Vector data = new Vector();
    private ProtocolDb protocolDb;

    public ProtocolModel(AgentContext agentContext) {
        this.protocolDb = agentContext.ProtocolDb();
        this.protocolDb.addProtocolMonitor(this, 7L, true);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public Object getValueAt(int n, int n2) {
        ProtocolInfo protocolInfo = (ProtocolInfo)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return protocolInfo.getType();
            }
            case 1: {
                return protocolInfo.getName();
            }
            case 2: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public void protocolAddedEvent(ProtocolEvent protocolEvent) {
        ProtocolInfo protocolInfo = protocolEvent.getProtocolInfo();
        if (!this.data.contains(protocolInfo)) {
            this.data.addElement(protocolInfo);
            this.fireTableDataChanged();
        }
    }

    public void protocolDeletedEvent(ProtocolEvent protocolEvent) {
        ProtocolInfo protocolInfo = protocolEvent.getProtocolInfo();
        this.data.removeElement(protocolInfo);
        this.fireTableDataChanged();
    }

    public void protocolModifiedEvent(ProtocolEvent protocolEvent) {
    }

    public void protocolAccessedEvent(ProtocolEvent protocolEvent) {
    }

    public void removeZeusEventMonitors() {
        this.protocolDb.removeProtocolMonitor(this, 7L);
    }

    public StrategyInfo[] getStrategyInfos(int n) {
        ProtocolInfo protocolInfo = (ProtocolInfo)this.data.elementAt(n);
        return protocolInfo.getConstraints();
    }
}

