/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.plansch;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import zeus.actors.PlanRecord;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.ZeusInternalFrame;
import zeus.agentviewer.plansch.PlanSchModel;
import zeus.concepts.Goal;
import zeus.concepts.PrimitiveTask;
import zeus.gui.fields.WholeNumberField;
import zeus.util.SystemProps;

public class PlanSchTableUI
extends ZeusInternalFrame
implements ActionListener,
MouseListener,
ChangeListener {
    private JPanel contentPane;
    private JTable table;
    private JTextArea textarea;
    private JScrollPane topPane;
    final int TOP_PANE_MIN_HEIGHT = 27;
    final int TOP_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_WIDTH = 500;
    final int BOTTOM_PANE_MIN_HEIGHT = 30;
    private static int NUMBER_DISPLAYED = 0;
    private InternalFramesPanel deskTop;
    PlanSchModel planSchBuffer;
    WholeNumberField startTime;
    JButton setBtn;
    JButton resetBtn;
    static /* synthetic */ Class class$java$lang$Object;

    public PlanSchTableUI(InternalFramesPanel internalFramesPanel, PlanSchModel planSchModel) {
        super(" ", true, true, true, true);
        try {
            this.setTitle("Planner & Scheduler:" + ++NUMBER_DISPLAYED);
            String string = System.getProperty("file.separator");
            String string2 = SystemProps.getProperty("gif.dir") + "agentviewer" + string;
            ImageIcon imageIcon = new ImageIcon(string2 + "planner.gif");
            this.setFrameIcon(imageIcon);
            this.deskTop = internalFramesPanel;
            this.planSchBuffer = planSchModel;
            this.buildUI();
            this.startTime.setText(Integer.toString(planSchModel.getFrom()));
            internalFramesPanel.addInternalFrame(this);
            planSchModel.addChangeListener(this);
            planSchModel.setTable(this.table);
            this.setSize(500, 350);
            this.setDoubleBuffered(true);
            this.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private JPanel getColorPanel() {
        try {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridLayout(3, 3, 5, 2));
            int n = 0;
            while (n < PlanRecord.state_string.length) {
                KeyLabel keyLabel = new KeyLabel(PlanRecord.state_string[n], PlanRecord.color[n]);
                jPanel.add(keyLabel);
                ++n;
            }
            JPanel jPanel2 = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel2.setLayout(gridBagLayout);
            gridBagConstraints.insets = new Insets(10, 5, 0, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            JLabel jLabel = new JLabel("Key", 2);
            jLabel.setFont(new Font("Courier", 1, 14));
            jLabel.setForeground(Color.black);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            jPanel2.add(jPanel);
            return jPanel2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void buildUI() {
        try {
            this.table = new JTable(this.planSchBuffer);
            this.planSchBuffer.setTable(this.table);
            this.table.addMouseListener(this);
            this.table.getSelectionModel().setSelectionMode(0);
            this.table.setCellSelectionEnabled(true);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer(){

                public void setValue(Object object) {
                    if (object == null) {
                        super.setValue("Free");
                        this.setBackground(PlanRecord.color[0]);
                    } else {
                        PrimitiveTask primitiveTask = ((PlanRecord)object).getTask();
                        Goal goal = ((PlanRecord)object).getGoal();
                        super.setValue(primitiveTask.getName() + ": " + goal.getFactType());
                        this.setBackground(PlanRecord.color[((PlanRecord)object).getState()]);
                    }
                }
            };
            this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PlanSchTableUI.class$("java.lang.Object")) : class$java$lang$Object, defaultTableCellRenderer);
            this.topPane = new JScrollPane(this.table);
            this.topPane.getViewport().setBackground(Color.white);
            this.textarea = new JTextArea(3, 40);
            this.textarea.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), "Diagnostic Information", 1, 0, new Font("Courier", 1, 14), Color.black));
            this.textarea.setEditable(false);
            this.textarea.setLineWrap(true);
            this.textarea.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(this.textarea);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add("Center", this.topPane);
            jPanel.add("South", jScrollPane);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
            jPanel2.add(Box.createRigidArea(new Dimension(15, 10)));
            JLabel jLabel = new JLabel("Display times from ");
            jLabel.setAlignmentY(0.5f);
            jLabel.setForeground(Color.black);
            jPanel2.add(jLabel);
            this.startTime = new WholeNumberField();
            this.startTime.setPreferredSize(new Dimension(100, 20));
            this.startTime.setMinimumSize(new Dimension(100, 20));
            this.startTime.setAlignmentY(0.5f);
            jPanel2.add(this.startTime);
            this.setBtn = new JButton("Set");
            this.setBtn.setAlignmentY(0.5f);
            this.setBtn.addActionListener(this);
            this.setBtn.setToolTipText("Click to set columns");
            this.setBtn.setForeground(Color.red);
            this.setBtn.setBorder(BorderFactory.createRaisedBevelBorder());
            this.resetBtn = new JButton("Reset");
            this.resetBtn.setBorder(BorderFactory.createRaisedBevelBorder());
            this.resetBtn.setForeground(Color.blue);
            this.resetBtn.setToolTipText("Click to reset columns");
            this.resetBtn.setAlignmentY(0.5f);
            this.resetBtn.addActionListener(this);
            JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
            jPanel3.add(this.setBtn);
            jPanel3.add(this.resetBtn);
            jPanel2.add(jPanel3);
            jPanel2.add(Box.createRigidArea(new Dimension(15, 10)));
            this.contentPane = (JPanel)this.getContentPane();
            this.contentPane.setLayout(new BorderLayout(10, 10));
            this.contentPane.add("Center", jPanel);
            this.contentPane.add("North", jPanel2);
            this.contentPane.add("South", this.getColorPanel());
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.startTime.setValue(this.planSchBuffer.getFrom());
            this.textarea.setText("  ");
            this.table.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.table.columnAtPoint(new Point(n, n2));
        int n4 = this.table.rowAtPoint(new Point(n, n2));
        PlanRecord planRecord = (PlanRecord)this.table.getValueAt(n4, n3);
        if (planRecord != null && planRecord.diagnostic() != null) {
            this.textarea.setText(planRecord.diagnostic());
        } else {
            this.textarea.setText("");
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block4: {
            try {
                Object object = actionEvent.getSource();
                if (object == this.setBtn) {
                    Long l = this.startTime.getValue();
                    if (l == null) break block4;
                    this.planSchBuffer.setFrom(l.intValue());
                    break block4;
                }
                if (object == this.resetBtn) {
                    this.planSchBuffer.reSetFrom();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void reSize() {
        try {
            this.setSize(this.getWidth() + 1, this.getHeight());
            this.setSize(this.getWidth() - 1, this.getHeight());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class KeyLabel
    extends JPanel {
        public KeyLabel(String string, Color color) {
            try {
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                this.setLayout(gridBagLayout);
                JPanel jPanel = new JPanel();
                jPanel.setPreferredSize(new Dimension(10, 10));
                jPanel.setBackground(color);
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(jPanel, gridBagConstraints);
                this.add(jPanel);
                JLabel jLabel = new JLabel(string);
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 5, 0, 0);
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.add(jLabel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

