/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.plansch;

import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import zeus.actors.AgentContext;
import zeus.actors.ExecutionMonitor;
import zeus.actors.PlanRecord;
import zeus.actors.Planner;
import zeus.actors.event.ClockEvent;
import zeus.actors.event.ClockMonitor;
import zeus.actors.event.PlanStepEvent;
import zeus.actors.event.PlanStepMonitor;

public class PlanSchModel
extends DefaultTableModel
implements PlanStepMonitor,
ClockMonitor {
    static final int DEFAULT_SIZE = 10;
    private PlanRecord[][] data;
    private PlanRecord[][] newData = null;
    private int length;
    private int width;
    private int from;
    private int now;
    private ExecutionMonitor em;
    private Planner planner;
    protected EventListenerList changeListeners = new EventListenerList();
    private JTable table;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    public PlanSchModel(AgentContext agentContext) {
        this.em = agentContext.ExecutionMonitor();
        this.planner = agentContext.Planner();
        this.length = this.planner.getPlannerLength();
        this.width = this.planner.getPlannerWidth();
        this.now = (int)agentContext.now();
        this.data = new PlanRecord[this.width][this.length];
        int n = 0;
        while (n < this.width) {
            int n2 = 0;
            while (n2 < this.length) {
                this.data[n][n2] = null;
                ++n2;
            }
            ++n;
        }
        this.planner.addPlanStepMonitor(this, 7L);
        this.em.addClockMonitor(this, 1L);
        this.from = this.now;
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        return this.width;
    }

    public int getColumnCount() {
        return 10;
    }

    public Object getValueAt(int n, int n2) {
        if (n > this.width) {
            return null;
        }
        if (n2 + this.from - this.now > this.length) {
            return null;
        }
        return this.data[n][n2 + this.from - this.now];
    }

    public String getColumnName(int n) {
        int n2 = n + this.from;
        return "+" + Integer.toString(n);
    }

    public synchronized void createPlanRecord(PlanRecord planRecord) {
        int n = planRecord.getStartTime() - this.now;
        int n2 = planRecord.getEndTime() - this.now;
        int n3 = planRecord.getProc();
        if (n < 0 || n2 < 0) {
            return;
        }
        int n4 = n;
        while (n4 < n2) {
            this.data[n3][n4] = planRecord;
            ++n4;
        }
        this.fireTableDataChanged();
    }

    public synchronized void stateChangedPlanRecord(PlanRecord planRecord) {
        int n = planRecord.getStartTime() - this.now;
        int n2 = planRecord.getEndTime() - this.now;
        int n3 = planRecord.getProc();
        if (n < 0) {
            return;
        }
        int n4 = 0;
        while (n4 < this.width) {
            int n5 = 0;
            while (n5 < this.length) {
                if (this.data[n4][n5] == planRecord) {
                    this.data[n4][n5] = null;
                }
                ++n5;
            }
            ++n4;
        }
        int n6 = n;
        while (n6 < n2) {
            this.data[n3][n6] = planRecord;
            ++n6;
        }
        this.fireTableDataChanged();
    }

    protected void setTable(JTable jTable) {
        this.table = jTable;
    }

    public synchronized void removePlanRecord(PlanRecord planRecord) {
        int n = planRecord.getProc();
        int n2 = planRecord.getStartTime() - this.now;
        int n3 = planRecord.getEndTime() - this.now;
        if (n2 < 0) {
            return;
        }
        int n4 = n2;
        while (n4 < n3) {
            this.data[n][n4] = null;
            ++n4;
        }
        this.fireTableDataChanged();
    }

    public synchronized void clockTicked(int n) {
        if (this.newData == null) {
            this.newData = new PlanRecord[this.width][this.length];
        }
        int n2 = 0;
        while (n2 < this.width) {
            int n3 = 0;
            while (n3 < this.length - 1) {
                this.newData[n2][n3] = this.data[n2][n3 + 1];
                ++n3;
            }
            this.newData[n2][this.length - 1] = null;
            ++n2;
        }
        this.data = this.newData;
        this.now = n;
        if (n > this.from) {
            this.from = n;
        }
        this.fireTableDataChanged();
    }

    public void setFrom(int n) {
        if (n < this.now) {
            this.reSetFrom();
        } else {
            this.from = n;
        }
        this.fireTableStructureChanged();
    }

    public int getFrom() {
        return this.from;
    }

    public void reSetFrom() {
        this.from = this.now;
        this.fireTableStructureChanged();
    }

    public Object[] getListeners() {
        Object[] objectArray = this.listenerList.getListenerList();
        return objectArray;
    }

    public void clockTickEvent(ClockEvent clockEvent) {
        this.clockTicked(clockEvent.getValue());
        this.fireChanged();
    }

    public void planStepCreatedEvent(PlanStepEvent planStepEvent) {
        this.createPlanRecord(planStepEvent.getPlanRecord());
        this.fireChanged();
    }

    public void planStepDisposedEvent(PlanStepEvent planStepEvent) {
        this.removePlanRecord(planStepEvent.getPlanRecord());
        this.fireChanged();
    }

    public void planStepStateChangedEvent(PlanStepEvent planStepEvent) {
        this.stateChangedPlanRecord(planStepEvent.getPlanRecord());
        this.fireChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PlanSchModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PlanSchModel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, changeListener);
    }

    protected void fireChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.changeListeners.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$ChangeListener == null ? PlanSchModel.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                ChangeListener changeListener = (ChangeListener)objectArray[n + 1];
                changeListener.stateChanged(changeEvent);
            }
            n -= 2;
        }
    }

    public void removeZeusEventMonitors() {
        this.planner.removePlanStepMonitor(this, 7L);
        this.em.removeClockMonitor(this, 1L);
    }

    public int getProcessors() {
        return this.width;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

