/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.mail;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.MailBox;
import zeus.actors.event.MessageEvent;
import zeus.actors.event.MessageMonitor;
import zeus.concepts.Performative;

public class MailOutTableModel
extends AbstractTableModel
implements MessageMonitor {
    private String RECEPIENT = "To";
    private String TYPE = "Type";
    private String SUBJECT = "Subject";
    private String CONTENT = "Content";
    private int BUFFER_CAPACITY = 50;
    private int REMOVE_INDEX = 0;
    private String[] header = new String[]{this.RECEPIENT, this.SUBJECT, this.TYPE};
    private Vector data = new Vector();
    private MailBox mb;

    public MailOutTableModel(AgentContext agentContext) {
        this.mb = agentContext.MailBox();
        this.mb.addMessageMonitor(this, 4L);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public Object getValueAt(int n, int n2) {
        Performative performative = (Performative)this.data.elementAt(n);
        if (this.getColumnName(n2).equals(this.RECEPIENT)) {
            return performative.getReceiver();
        }
        if (this.getColumnName(n2).equals(this.SUBJECT)) {
            return null;
        }
        if (this.getColumnName(n2).equals(this.TYPE)) {
            return performative.getType();
        }
        return new String("Error in MailOutTableModel at getValueAt");
    }

    Performative getMessage(int n) {
        Performative performative = (Performative)this.data.elementAt(n);
        return performative;
    }

    public String getColumnName(int n) {
        return this.header[n];
    }

    public void addMail(Performative performative) {
        if (this.data.contains(performative)) {
            return;
        }
        if (this.data.size() > this.BUFFER_CAPACITY) {
            this.data.removeElementAt(this.REMOVE_INDEX);
        }
        this.data.addElement(performative);
        this.fireTableDataChanged();
    }

    public String getMailContent(int n) {
        Performative performative = (Performative)this.data.elementAt(n);
        return performative.getContent();
    }

    public void messageReceivedEvent(MessageEvent messageEvent) {
    }

    public void messageQueuedEvent(MessageEvent messageEvent) {
    }

    public void messageDispatchedEvent(MessageEvent messageEvent) {
        this.addMail((Performative)messageEvent.getObject());
    }

    public void messageNotDispatchedEvent(MessageEvent messageEvent) {
    }

    public void removeZeusEventMonitors() {
        this.mb.removeMessageMonitor(this, 4L);
    }
}

