/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.engine;

import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.event.NodeEvent;
import zeus.actors.event.NodeMonitor;
import zeus.actors.rtn.Engine;
import zeus.actors.rtn.Node;
import zeus.agentviewer.engine.EngineGraphModel;
import zeus.agentviewer.engine.GraphsModel;
import zeus.gui.graph.GraphNode;
import zeus.util.Core;
import zeus.util.Misc;
import zeus.util.OrderedHashtable;

public class EngineTableModel
extends AbstractTableModel
implements NodeMonitor {
    private String[] header = new String[]{"Graphs"};
    private OrderedHashtable data = new OrderedHashtable();
    private GraphsModel graphsModel = new GraphsModel();
    private Engine engine;
    private int BUFFER_CAPACITY = 25;
    private int REMOVE_INDEX = 0;
    EngineGraphModel markedForDeletion = null;

    public EngineTableModel(AgentContext agentContext) {
        this.engine = agentContext.Engine();
        this.engine.addNodeMonitor(this, 7L);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return 1;
    }

    public Object getValueAt(int n, int n2) {
        try {
            return (String)this.data.getKeyAt(n);
        }
        catch (Exception exception) {
            return "removed";
        }
    }

    public String getColumnName(int n) {
        return this.header[n];
    }

    protected void markForDeletion(EngineGraphModel engineGraphModel) {
        if (this.markedForDeletion != null) {
            Node node = (Node)this.markedForDeletion.getRoot().getUserObject();
            String string = node.getDescription();
            this.data.remove(string);
            this.fireTableDataChanged();
            this.markedForDeletion.deleteTree(this.graphsModel);
        }
        this.markedForDeletion = engineGraphModel;
    }

    public void nodeCreatedEvent(NodeEvent nodeEvent) {
        Core.DEBUG(1, "EngineTableModel addNode(): " + nodeEvent.getNode().getDescription());
        if (nodeEvent.getParents() == null) {
            Core.DEBUG(1, "\tNode has no parents");
            EngineGraphModel engineGraphModel = new EngineGraphModel(new GraphNode(nodeEvent.getNode()));
            try {
                System.out.println("ETM >> " + this.data.size());
                while (this.data.size() > this.BUFFER_CAPACITY) {
                    System.out.println("ETM>> " + this.data.getKeyAt(this.REMOVE_INDEX));
                    EngineGraphModel engineGraphModel2 = (EngineGraphModel)this.data.get(this.data.getKeyAt(this.REMOVE_INDEX));
                    this.markForDeletion(engineGraphModel2);
                    Thread.yield();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.data.put(nodeEvent.getNodeName(), engineGraphModel);
            this.graphsModel.addRoot(nodeEvent.getNodeName(), engineGraphModel.getRoot());
            this.fireTableDataChanged();
        } else {
            Core.DEBUG(1, "\tNode has parents: " + Misc.concat(nodeEvent.getParentNames()));
            GraphNode graphNode = this.graphsModel.addToGraph(nodeEvent);
            EngineGraphModel engineGraphModel = this.updateGraph(nodeEvent.getNodeName());
            if (engineGraphModel != null && graphNode != null) {
                engineGraphModel.refresh(0, graphNode);
            } else {
                this.debug("eRoot or gNode null");
                Core.DEBUG(1, "eRoot or gNode is null");
            }
        }
    }

    private EngineGraphModel updateGraph(String string) {
        try {
            GraphNode graphNode = this.graphsModel.getRoot(string);
            Node node = (Node)graphNode.getUserObject();
            EngineGraphModel engineGraphModel = (EngineGraphModel)this.data.get(node.getDescription());
            return engineGraphModel;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void nodeStateChangedEvent(NodeEvent nodeEvent) {
        GraphNode graphNode = this.graphsModel.changeNode(nodeEvent);
        EngineGraphModel engineGraphModel = this.updateGraph(nodeEvent.getNodeName());
        if (engineGraphModel != null && graphNode != null) {
            engineGraphModel.refresh(2, graphNode);
        }
    }

    public void removeAll() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void removeGraph(EngineGraphModel engineGraphModel) {
        this.data.remove(engineGraphModel);
        this.fireTableDataChanged();
    }

    public EngineGraphModel getGraph(int n) {
        String string = (String)this.data.getKeyAt(n);
        return (EngineGraphModel)this.data.get(string);
    }

    public void nodeDisposedEvent(NodeEvent nodeEvent) {
    }

    public void removeZeusEventMonitors() {
        this.engine.removeNodeMonitor(this, 7L);
    }

    private void debug(String string) {
        System.out.println("EngineTableModel>>" + string);
    }
}

