/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer.acquaintances;

import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import zeus.actors.AgentContext;
import zeus.actors.OrganisationDb;
import zeus.actors.event.AbilityEvent;
import zeus.actors.event.AbilityMonitor;
import zeus.concepts.AbilitySpec;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.util.OrderedHashtable;

public class AbilitiesTableModel
extends AbstractTableModel
implements AbilityMonitor {
    private static final int FACT = 0;
    private static final int COST = 1;
    private static final int DURATION = 2;
    private String[] header = new String[]{"Fact", "Cost", "Duration"};
    private Vector data;
    private String agent;
    private OrderedHashtable allAbilities = new OrderedHashtable();
    OrganisationDb organisationDb;
    OntologyDb ontologyDb;

    public AbilitiesTableModel(AgentContext agentContext) {
        this.organisationDb = agentContext.OrganisationDb();
        this.ontologyDb = agentContext.OntologyDb();
        this.data = null;
        this.agent = null;
        this.organisationDb.addAbilityMonitor(this, 7L, true);
    }

    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    public int getColumnCount() {
        return this.header.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Object getValueAt(int n, int n2) {
        AbilitySpec abilitySpec = (AbilitySpec)this.data.elementAt(n);
        switch (n2) {
            case 0: {
                return abilitySpec.getType();
            }
            case 1: {
                return new Double(abilitySpec.getCost());
            }
            case 2: {
                return new Integer(abilitySpec.getTime());
            }
        }
        return null;
    }

    public String getColumnName(int n) {
        return this.header[n];
    }

    boolean validateInput(String string) {
        try {
            Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, "Invalid Input", "Enter values", 0);
            return false;
        }
        return true;
    }

    public Fact getAttributesof(int n) {
        return ((AbilitySpec)this.data.elementAt(n)).getFact();
    }

    void makeFact(String string) {
        Fact fact = this.ontologyDb.getFact(true, string);
        AbilitySpec abilitySpec = new AbilitySpec(fact, 0, 0.0);
        this.organisationDb.add(this.agent, abilitySpec);
        System.out.println("make fact:agent  " + this.agent);
    }

    public void addAbility(String string, AbilitySpec abilitySpec) {
        if (this.allAbilities.containsKey(string)) {
            Vector vector = (Vector)this.allAbilities.get(string);
            if (vector.contains(abilitySpec)) {
                return;
            }
            vector.addElement(abilitySpec);
        } else {
            Vector<AbilitySpec> vector = new Vector<AbilitySpec>();
            vector.addElement(abilitySpec);
            this.allAbilities.put(string, vector);
        }
        this.fireTableDataChanged();
    }

    public void removeAbility(String string, AbilitySpec abilitySpec) {
        if (this.allAbilities.containsKey(string)) {
            Vector vector = (Vector)this.allAbilities.get(string);
            int n = 0;
            while (n < vector.size()) {
                AbilitySpec abilitySpec2 = (AbilitySpec)vector.elementAt(n);
                if (abilitySpec2.equals(abilitySpec)) {
                    vector.removeElement(abilitySpec2);
                    if (!vector.isEmpty()) break;
                    this.allAbilities.remove(string);
                    break;
                }
                ++n;
            }
        }
        this.fireTableDataChanged();
    }

    public void modifyAbility(String string, AbilitySpec abilitySpec) {
        if (this.allAbilities.containsKey(string)) {
            Vector vector = (Vector)this.allAbilities.get(string);
            int n = 0;
            while (n < vector.size()) {
                AbilitySpec abilitySpec2 = (AbilitySpec)vector.elementAt(n);
                if (abilitySpec2.getType().equals(abilitySpec.getType())) {
                    abilitySpec2 = abilitySpec;
                    break;
                }
                ++n;
            }
        }
        this.fireTableDataChanged();
    }

    public AbilitySpec getAbility(String string, String string2) {
        if (this.allAbilities.containsKey(string)) {
            Vector vector = (Vector)this.allAbilities.get(string);
            int n = 0;
            while (n < vector.size()) {
                AbilitySpec abilitySpec = (AbilitySpec)vector.elementAt(n);
                if (abilitySpec.getType().equals(string2)) {
                    return abilitySpec;
                }
                ++n;
            }
        }
        return null;
    }

    public AbilitySpec getAbility(String string) {
        Vector vector = (Vector)this.allAbilities.get(this.getAgent());
        int n = 0;
        while (n < vector.size()) {
            AbilitySpec abilitySpec = (AbilitySpec)vector.elementAt(n);
            if (abilitySpec.getType().equals(string)) {
                return abilitySpec;
            }
            ++n;
        }
        return null;
    }

    public void setToNull() {
        this.data = null;
        this.fireTableDataChanged();
    }

    public void setAbilitiesof(String string) {
        this.data = (Vector)this.allAbilities.get(string);
        this.agent = string;
        this.fireTableDataChanged();
    }

    public String getAgent() {
        return this.agent;
    }

    void deleteFact(int n) {
        String string = (String)this.getValueAt(n, 0);
        this.organisationDb.del(this.agent, this.getAbility(this.agent, string));
    }

    public boolean hasAbilities(String string) {
        if (!this.allAbilities.containsKey(string)) {
            this.data = null;
            this.agent = string;
            this.fireTableDataChanged();
            return false;
        }
        return true;
    }

    public void abilityAddedEvent(AbilityEvent abilityEvent) {
        this.addAbility(abilityEvent.getAgent(), abilityEvent.getAbility());
    }

    public void abilityModifiedEvent(AbilityEvent abilityEvent) {
        System.out.println("Called event modified");
        this.modifyAbility(abilityEvent.getAgent(), abilityEvent.getAbility());
    }

    public void abilityDeletedEvent(AbilityEvent abilityEvent) {
        this.removeAbility(abilityEvent.getAgent(), abilityEvent.getAbility());
    }

    public void abilityAccessedEvent(AbilityEvent abilityEvent) {
    }

    public void removeZeusEventMonitors() {
        this.organisationDb.removeAbilityMonitor(this, 7L);
    }
}

