/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import zeus.agentviewer.AgentViewer;
import zeus.agentviewer.BasicAgentViewer;

public class InternalFramesPanel
extends JPanel {
    private JScrollPane scrollPane;
    private JDesktopPane desktopPane;
    final int WIDTH = 750;
    final int HEIGHT = 300;
    final int DELTAw = 25;
    final int DELTAh = 80;
    public JFrame frame;
    boolean TILE = false;

    public InternalFramesPanel() {
        this.setLayout(new BorderLayout());
        this.desktopPane = new JDesktopPane(){

            public Dimension getMinimumSize() {
                return new Dimension(10, 10);
            }

            public Dimension getPreferredSize() {
                return new Dimension(4000, 4000);
            }
        };
        this.desktopPane.setOpaque(false);
        this.scrollPane = new JScrollPane(this.desktopPane, 22, 32){

            public boolean isOpaque() {
                return true;
            }
        };
        this.add("Center", this.scrollPane);
        this.setBorder(BorderFactory.createEtchedBorder(Color.black, Color.gray));
        this.setSize(750, 300);
    }

    public InternalFramesPanel(AgentViewer agentViewer) {
        this();
        this.frame = agentViewer;
    }

    public InternalFramesPanel(BasicAgentViewer basicAgentViewer) {
        this();
        this.frame = basicAgentViewer;
    }

    public void addInternalFrame(JInternalFrame jInternalFrame) {
        this.desktopPane.add((Component)jInternalFrame, JLayeredPane.PALETTE_LAYER);
        this.positionInternalFrame(jInternalFrame);
    }

    private void positionInternalFrame(JInternalFrame jInternalFrame) {
        try {
            jInternalFrame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.desktopPane.validate();
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        if (jInternalFrameArray.length > 1) {
            this.cascade();
        } else {
            Dimension dimension = new Dimension(600, 300);
            int n = dimension.width * 2 / 4;
            int n2 = dimension.height * 2 / 4;
            jInternalFrame.setBounds(20, 20, n, n2);
            jInternalFrame.setSize(n, n2);
        }
        this.repaint();
    }

    private Vector getDisplayedFrames() {
        Vector<JInternalFrame> vector = new Vector<JInternalFrame>();
        JInternalFrame[] jInternalFrameArray = this.desktopPane.getAllFrames();
        int n = 0;
        while (n < jInternalFrameArray.length) {
            if (!jInternalFrameArray[n].isIcon()) {
                vector.addElement(jInternalFrameArray[n]);
            }
            ++n;
        }
        return vector;
    }

    public void tile() {
        Vector vector = this.getDisplayedFrames();
        int n = vector.size();
        if (n == 0) {
            return;
        }
        Dimension dimension = this.desktopPane.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height / n;
        Dimension dimension2 = new Dimension(n2, n3);
        int n4 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            JInternalFrame jInternalFrame = (JInternalFrame)enumeration.nextElement();
            jInternalFrame.setSize(dimension2);
            jInternalFrame.setLocation(new Point(0, n4));
            n4 += n3;
        }
        this.TILE = true;
    }

    public void cascade() {
        int n;
        int n2;
        Vector vector = this.getDisplayedFrames();
        int n3 = vector.size();
        if (n3 == 0) {
            return;
        }
        Dimension dimension = this.getSize();
        if (n3 > 1) {
            n2 = dimension.width * 4 / 5;
            n = dimension.height * 2 / 3;
        } else {
            n2 = dimension.width - 10;
            n = dimension.height - 10;
        }
        Dimension dimension2 = new Dimension(n2, n);
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            JInternalFrame jInternalFrame = (JInternalFrame)enumeration.nextElement();
            jInternalFrame.setSize(dimension2);
            jInternalFrame.setLocation(new Point(n4, n5));
            n4 += n2 / (n3 + 1);
            n5 += n / (n3 + 1);
        }
        this.TILE = false;
    }

    public boolean tileOn() {
        return this.TILE;
    }
}

