/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import zeus.actors.AgentContext;
import zeus.actors.rtn.Engine;
import zeus.agentviewer.AddFactDialog;
import zeus.agentviewer.FactSelector;
import zeus.agentviewer.FactTableModel;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.OntologyDb;
import zeus.gui.editors.ExpressionCellEditor;
import zeus.gui.editors.ValidatingCellRenderer;
import zeus.gui.editors.ValidatingModel;
import zeus.gui.fields.WholeNumberField;
import zeus.util.Assert;
import zeus.util.Time;

public class GoalDialog
extends JDialog
implements ItemListener,
ActionListener,
FactSelector {
    final int TOP_PANE_MIN_HEIGHT = 150;
    final int TOP_PANE_MIN_WIDTH = 400;
    public static final String[] FORMAT_TYPE = new String[]{"popup", "email", "phone", "voice"};
    public static final boolean BASIC = true;
    public static final boolean EXTENDED = false;
    protected JLabel gLabel;
    protected JLabel fLabel;
    protected JLabel aLabel;
    protected JLabel eLabel;
    protected JLabel rLabel;
    protected JLabel sLabel;
    protected JLabel cLabel;
    protected JLabel tLabel;
    protected JLabel dLabel;
    protected JLabel pLabel;
    protected JLabel nLabel;
    protected JLabel slaLabel;
    protected JLabel cmLabel;
    protected JTextField fTextF;
    protected JTextField gTextF;
    protected JTextField dTextF;
    protected JTextField slaTextF;
    protected WholeNumberField cTextF;
    protected WholeNumberField eTextF;
    protected WholeNumberField cmTextF;
    protected WholeNumberField sTextF;
    protected WholeNumberField nTextF;
    protected WholeNumberField pTextF;
    protected JButton browseBtn;
    protected JButton browseAgentBtn = null;
    protected JComboBox typeChooser;
    protected JComboBox goalType;
    protected JList agentDialog = null;
    protected OntologyDb ontology = null;
    protected Engine engine = null;
    protected Fact fact = null;
    protected String[] agents = null;
    protected JButton okButton;
    protected JButton cancelButton;
    protected int nFormat = FORMAT_TYPE.length;
    protected LocalCheckBox[] _cb = new LocalCheckBox[this.nFormat];
    protected JTextField[] _cbTf = new JTextField[this.nFormat];
    protected boolean type = true;
    protected Vector sla = new Vector();
    protected Vector sla_data = new Vector();
    protected String II_key = null;
    protected String IC_key = null;
    protected String WMP_key = null;
    JScrollPane topPane;
    JTable table;
    JPanel contentPane;
    FactTableModel gdModel;
    AgentContext context;

    public GoalDialog(Frame frame, boolean bl, AgentContext agentContext) {
        super(frame, " Enter Goal Dialog", false);
        this.context = agentContext;
        this.set(agentContext.Engine());
        this.set(agentContext.OntologyDb());
        this.gdModel = new FactTableModel(this.ontology);
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.type = bl;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 10, 10));
        this.okButton = new JButton("Ok");
        this.okButton.setForeground(Color.black);
        this.okButton.setFont(new Font("Helvetica", 1, 14));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setForeground(Color.black);
        this.cancelButton.setFont(new Font("Helvetica", 1, 14));
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel2.add(jPanel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.add("North", new JSeparator(0));
        jPanel3.add("Center", jPanel2);
        this.contentPane.add("South", jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        this.gLabel = new JLabel("Goal:");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.gLabel, gridBagConstraints);
        jPanel4.add(this.gLabel);
        this.gTextF = new JTextField(15);
        this.gTextF.setEditable(false);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.gTextF, gridBagConstraints);
        jPanel4.add(this.gTextF);
        gridBagConstraints.weightx = 0.0;
        this.fLabel = new JLabel("Fact:");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.fLabel, gridBagConstraints);
        jPanel4.add(this.fLabel);
        String[] stringArray = new String[]{"achieve", "sell", "buy"};
        this.goalType = new JComboBox<String>(stringArray);
        gridBagLayout.setConstraints(this.goalType, gridBagConstraints);
        jPanel4.add(this.goalType);
        this.fTextF = new JTextField(15);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.fTextF, gridBagConstraints);
        jPanel4.add(this.fTextF);
        this.fTextF.setEditable(false);
        this.browseBtn = new JButton("Browse...");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.browseBtn, gridBagConstraints);
        jPanel4.add(this.browseBtn);
        this.aLabel = new JLabel("Attributes:");
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.aLabel, gridBagConstraints);
        jPanel4.add(this.aLabel);
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumn tableColumn = new TableColumn(0, 12);
        tableColumn.setHeaderValue(this.gdModel.getColumnName(0));
        defaultTableColumnModel.addColumn(tableColumn);
        ExpressionCellEditor expressionCellEditor = new ExpressionCellEditor(this.gdModel);
        tableColumn = new TableColumn(1, 24, new ValidatingCellRenderer((ValidatingModel)this.gdModel, 1), expressionCellEditor);
        tableColumn.setHeaderValue(this.gdModel.getColumnName(1));
        defaultTableColumnModel.addColumn(tableColumn);
        this.table = new JTable(this.gdModel, defaultTableColumnModel);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.topPane = new JScrollPane(this.table);
        this.table.getSelectionModel().setSelectionMode(0);
        this.topPane.setPreferredSize(new Dimension(400, 150));
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.topPane, gridBagConstraints);
        jPanel4.add(this.topPane);
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.eLabel = new JLabel("End Time:");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.eLabel, gridBagConstraints);
        jPanel4.add(this.eLabel);
        this.eTextF = new WholeNumberField();
        this.eTextF.setPreferredSize(new Dimension(100, 20));
        this.eTextF.setMinimumSize(new Dimension(100, 20));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.eTextF, gridBagConstraints);
        jPanel4.add(this.eTextF);
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.cmLabel = new JLabel("Confirm Time:");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cmLabel, gridBagConstraints);
        jPanel4.add(this.cmLabel);
        this.cmTextF = new WholeNumberField();
        this.cmTextF.setPreferredSize(new Dimension(100, 20));
        this.cmTextF.setMinimumSize(new Dimension(100, 20));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cmTextF, gridBagConstraints);
        jPanel4.add(this.cmTextF);
        this.cLabel = new JLabel("Cost:");
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.cLabel, gridBagConstraints);
        jPanel4.add(this.cLabel);
        this.cTextF = new WholeNumberField();
        this.cTextF.setPreferredSize(new Dimension(100, 20));
        this.cTextF.setMinimumSize(new Dimension(100, 20));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cTextF, gridBagConstraints);
        jPanel4.add(this.cTextF);
        this.contentPane.add("Center", jPanel4);
        this.goalType.addItemListener(this);
        this.browseBtn.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GoalDialog.this.setVisible(false);
            }
        });
        this.pack();
        this.setVisible(true);
        this.setResizable(false);
    }

    public void set(OntologyDb ontologyDb) {
        Assert.notNull(ontologyDb);
        this.ontology = ontologyDb;
    }

    public void set(Engine engine) {
        Assert.notNull(engine);
        this.engine = engine;
    }

    public void set(String[] stringArray) {
        Assert.notFalse(!this.type);
        this.agents = stringArray;
    }

    public void factSelected(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.gdModel.setFact(stringArray[0]);
        this.fact = this.gdModel.getFact();
        this.fTextF.setText(stringArray[0]);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.browseBtn && this.ontology != null) {
            this.browseBtnFn();
        }
        if (object == this.okButton) {
            if (this.okBtnFn()) {
                this.setVisible(false);
            }
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    protected void browseBtnFn() {
        AddFactDialog addFactDialog = new AddFactDialog(this, this.gdModel);
        addFactDialog.display(this);
        this.fact = this.gdModel.getFact();
        this.topPane.validate();
    }

    protected void browseAgentBtnFn() {
        if (this.agents != null) {
            if (this.agentDialog == null) {
                this.agentDialog = new JList<String>(this.agents);
            }
            String string = this.dTextF.getText();
            string = (String)this.agentDialog.getSelectedValue();
            if (string != null && !string.equals("")) {
                this.dTextF.setText(string);
            }
        }
    }

    public boolean okBtnFn() {
        String string = this.fTextF.getText();
        String string2 = (String)this.goalType.getSelectedItem();
        if (string == null || string.equals("")) {
            JOptionPane.showMessageDialog(null, "Fact Type is undefined", "Error", 0);
            return false;
        }
        if (this.fact == null) {
            this.fact = this.ontology.getFact(true, string);
        }
        boolean bl = true;
        Long l = this.eTextF.getValue();
        Long l2 = this.cmTextF.getValue();
        Long l3 = this.cTextF.getValue();
        if (l2 == null || l == null || l3 == null) {
            return false;
        }
        String string3 = this.gTextF.getText();
        String string4 = this.context.whoami();
        Goal goal = new Goal(string3, this.fact, l.intValue(), l3.intValue(), 1, string4, null, new Time(l2.doubleValue()));
        if (this.engine == null) {
            return true;
        }
        if (bl) {
            if (string2.equals("achieve")) {
                this.engine.achieve(goal);
            } else if (string2.equals("sell")) {
                this.engine.sell(goal);
            } else if (string2.equals("buy")) {
                this.engine.buy(goal);
            }
        }
        return true;
    }

    public void display(String[] stringArray) {
        this.set(stringArray);
        this.display();
    }

    public void display() {
        this.goalType.setSelectedIndex(0);
        this.gTextF.setText(this.context.newId("goal"));
        this.eTextF.setText("");
        this.cmTextF.setText("");
        this.cTextF.setText(Integer.toString(0));
        this.fTextF.setText("");
    }

    class LocalCheckBox
    extends JCheckBox
    implements ItemListener {
        boolean state = false;

        public LocalCheckBox(String string) {
            super(string);
            this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.state = itemEvent.getStateChange() == 1;
        }

        boolean getState() {
            return this.state;
        }

        void setState(boolean bl) {
            this.state = bl;
            this.setSelected(bl);
        }
    }
}

