/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer;

import javax.swing.table.AbstractTableModel;
import zeus.concepts.Fact;
import zeus.concepts.OntologyDb;
import zeus.concepts.ZeusParser;
import zeus.concepts.fn.ValueFunction;
import zeus.gui.editors.ValidatingModel;
import zeus.util.Misc;

public class FactTableModel
extends AbstractTableModel
implements ValidatingModel {
    static final int ATTRIBUTE = 0;
    static final int VALUE = 1;
    protected String[] columnNames = new String[]{"Attribute", "Value"};
    private Fact fact;
    OntologyDb ontologyDb;

    public FactTableModel(OntologyDb ontologyDb) {
        this.ontologyDb = ontologyDb;
        this.fact = null;
    }

    public int getRowCount() {
        if (this.fact == null) {
            return 0;
        }
        return this.fact.listAttributes().length;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    public void setValueAt(Object object, int n, int n2) {
        String string;
        String string2 = this.fact.listValues()[n].toString();
        String string3 = this.fact.listAttributes()[n];
        String string4 = string = object == null ? null : ((String)object).trim();
        if (string.equals("")) {
            string = null;
        }
        if (string == null) {
            if (string2 == null) {
                return;
            }
            string2 = string;
            this.fact.setValue(string3, this.fact.newVar());
        } else {
            string = Misc.substitute(string, this.fact.getId(), "?this");
            if (string2 != null && string2.equals(string)) {
                return;
            }
            string2 = string;
            ValueFunction valueFunction = ZeusParser.Expression(string2);
            if (valueFunction != null) {
                this.fact.setValue(string3, valueFunction);
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public boolean isValidEntry(int n, int n2) {
        switch (n2) {
            case 1: {
                if (this.fact.listValues()[n] == null) {
                    return true;
                }
                if (this.fact.listValues()[n].equals("")) {
                    return true;
                }
                return ZeusParser.Expression(this.fact.listValues()[n].toString()) != null;
            }
            case 0: {
                return true;
            }
        }
        return false;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.fact.listAttributes()[n];
        }
        if (n2 == 1) {
            return this.fact.listValues()[n].toString();
        }
        return new String("Error in AttributesTableModel at getValueAt");
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public void setFact(String string) {
        if (string == null) {
            return;
        }
        this.fact = this.ontologyDb.getFact(true, string);
        System.out.println(this.fact);
        this.fireTableDataChanged();
    }

    public Fact getFact() {
        return this.fact;
    }
}

