/*
 * Decompiled with CFR 0.152.
 */
package zeus.agentviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import zeus.actors.AgentContext;
import zeus.agents.ZeusAgentUI;
import zeus.agentviewer.AgentButton;
import zeus.agentviewer.InternalFramesPanel;
import zeus.agentviewer.mail.MailInTableModel;
import zeus.agentviewer.mail.MailInTableUI;
import zeus.agentviewer.mail.MailOutTableModel;
import zeus.agentviewer.mail.MailOutTableUI;
import zeus.agentviewer.msghandler.MsgHandlerTableModel;
import zeus.agentviewer.msghandler.MsgHandlerTableUI;
import zeus.gui.help.HelpWindow;
import zeus.util.Assert;
import zeus.util.SystemProps;

public class BasicAgentViewer
extends JFrame
implements ActionListener,
ComponentListener,
ZeusAgentUI {
    JPanel contentPane;
    public JPanel topPanel;
    InternalFramesPanel bottomPanel;
    String fsep = System.getProperty("file.separator");
    String IMAGEPATH = SystemProps.getProperty("gif.dir") + "agentviewer" + this.fsep;
    final int ICONh = 40;
    final int ICONw = 35;
    final int HEADERw = 165;
    final int HEADERh = 43;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenu viewMenu;
    private JMenuItem exit;
    private JMenuItem about;
    private JMenuItem aboutZeus;
    private JMenuItem tile;
    private JMenuItem cascade;
    private JMenuItem nativeLF;
    private JMenuItem metalLF;
    private JToolBar toolBar;
    private AgentButton mailInBtn;
    private AgentButton mailOutBtn;
    private AgentButton msgHandlerBtn;
    AgentContext context = null;
    Thread agentViewerThread;
    MailInTableModel mailInBuffer;
    MailOutTableModel mailOutBuffer;
    MsgHandlerTableModel msgHandlerBuffer;

    public BasicAgentViewer() {
        super("Basic Zeus Agent Viewer");
        this.createMenus();
        ImageIcon imageIcon = new ImageIcon(this.IMAGEPATH + "viewer.gif");
        this.setIconImage(imageIcon.getImage());
        this.setJMenuBar(this.menuBar);
        this.setContentPane();
        this.getNativeUI();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                BasicAgentViewer.this.exitBtnFn();
            }
        });
        this.addComponentListener(this);
        this.setVisible(true);
        this.setSize(600, 500);
        this.pack();
    }

    public void showHelp() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "Agent Viewer");
        helpWindow.setSize(new Dimension(600, this.getHeight()));
        helpWindow.setLocation(point.x + 24, point.y + 24);
        helpWindow.validate();
    }

    public void About() {
        Point point = this.getLocation();
        HelpWindow helpWindow = new HelpWindow(this, point, "visualiser", "About");
        helpWindow.setSize(new Dimension(440, 440));
        helpWindow.setLocation(point.x + 24, point.y + 24);
        helpWindow.setTitle("About ZEUS ...");
        helpWindow.validate();
    }

    void setMailInBox() {
        this.mailInBuffer = new MailInTableModel(this.context);
    }

    void setMailOutBox() {
        this.mailOutBuffer = new MailOutTableModel(this.context);
    }

    void setMsgHandlerBox() {
        this.msgHandlerBuffer = new MsgHandlerTableModel(this.context);
    }

    public void showMsg(String string) {
    }

    public void set(AgentContext agentContext) {
        Assert.notNull(agentContext);
        this.context = agentContext;
        this.setTitle(agentContext.whoami());
        this.setMailInBox();
        this.setMailOutBox();
        this.setMsgHandlerBox();
    }

    private void getNativeUI() {
        String string = System.getProperty("path.separator");
        System.out.println("Choosing native look & feel ....");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            System.out.println("Error getting UI");
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.bottomPanel.tileOn()) {
            this.bottomPanel.tile();
        } else {
            this.bottomPanel.cascade();
        }
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    private void setContentPane() {
        this.bottomPanel = new InternalFramesPanel(this);
        this.toolBar = new JToolBar(1);
        this.toolBar.setFloatable(false);
        JPanel jPanel = new JPanel(new GridLayout(1, 1));
        jPanel.add(this.toolBar);
        jPanel.setBorder(BorderFactory.createEtchedBorder(Color.red, Color.black));
        this.addButtonsToToolBar();
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.setLayout(new BorderLayout());
        this.contentPane.add("West", jPanel);
        this.contentPane.add("Center", this.bottomPanel);
    }

    private void createMenus() {
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.exit = new JMenuItem("Exit");
        this.exit.addActionListener(this);
        this.fileMenu.add(this.exit);
        this.menuBar.add(this.fileMenu);
        this.viewMenu = new JMenu("View");
        this.tile = new JMenuItem("Tile");
        this.tile.addActionListener(this);
        this.viewMenu.add(this.tile);
        this.cascade = new JMenuItem("Cascade");
        this.cascade.addActionListener(this);
        this.viewMenu.add(this.cascade);
        this.viewMenu.addSeparator();
        this.nativeLF = new JMenuItem("Native Look & Feel");
        this.nativeLF.addActionListener(this);
        this.viewMenu.add(this.nativeLF);
        this.metalLF = new JMenuItem("Metal Look & Feel");
        this.metalLF.addActionListener(this);
        this.viewMenu.add(this.metalLF);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(Box.createHorizontalGlue());
        this.helpMenu = new JMenu("Help");
        this.about = new JMenuItem("Using the Agent Viewer");
        this.about.addActionListener(this);
        this.helpMenu.add(this.about);
        this.aboutZeus = new JMenuItem("About Zeus");
        this.aboutZeus.addActionListener(this);
        this.helpMenu.add(this.aboutZeus);
        this.menuBar.add(this.helpMenu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nativeLF) {
            this.getNativeUI();
            return;
        }
        if (object == this.metalLF) {
            try {
                System.out.println("Metal look & feel chosen");
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (Exception exception) {
                System.out.println("Error getting UI");
            }
            return;
        }
        if (this.context != null) {
            if (object == this.exit) {
                this.exitBtnFn();
            } else if (object == this.tile) {
                this.bottomPanel.tile();
            } else if (object == this.cascade) {
                this.bottomPanel.cascade();
            } else if (object != this.about) {
                if (object == this.mailInBtn) {
                    new MailInTableUI(this.bottomPanel, this.mailInBuffer);
                } else if (object == this.mailOutBtn) {
                    new MailOutTableUI(this.bottomPanel, this.mailOutBuffer);
                } else if (object == this.msgHandlerBtn) {
                    new MsgHandlerTableUI(this.bottomPanel, this.msgHandlerBuffer);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "No associated agent", "Error Message", 0);
        }
    }

    private void exitBtnFn() {
        System.exit(0);
    }

    Icon getIcon(String string, int n, int n2) {
        String string2 = new String(this.IMAGEPATH + string);
        Image image = Toolkit.getDefaultToolkit().getImage(string2);
        image = image.getScaledInstance(n, n2, 4);
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    private void addButtonsToToolBar() {
        JLabel jLabel = new JLabel(this.getIcon("header.gif", 165, 43));
        this.toolBar.add(jLabel);
        this.toolBar.add(Box.createRigidArea(new Dimension(10, 30)));
        this.mailInBtn = new AgentButton("Incoming Mail", this.getIcon("mailin.gif", 35, 40));
        this.mailInBtn.addActionListener(this);
        this.toolBar.add(this.mailInBtn);
        this.mailOutBtn = new AgentButton("Outgoing Mail", this.getIcon("mailout.gif", 35, 40));
        this.mailOutBtn.addActionListener(this);
        this.toolBar.add(this.mailOutBtn);
    }

    public static void main(String[] stringArray) {
        new BasicAgentViewer();
    }
}

