/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import java.net.InetAddress;
import javax.agent.Envelope;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.MsgHandler;
import zeus.actors.OutTray;
import zeus.actors.ResourceDb;
import zeus.actors.factories.TransportFactory;
import zeus.actors.factories.TransportUnsupportedException;
import zeus.concepts.FIPAPerformative;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.Fact;
import zeus.concepts.Goal;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.util.Queue;

public class SimpleAPI {
    private boolean messQ = false;
    private Queue messageQueue = null;
    private AgentContext agentContext = null;

    public boolean sendMessage(String string, String string2, String string3) {
        FIPAPerformative fIPAPerformative = new FIPAPerformative(string);
        fIPAPerformative.setContent(string2);
        fIPAPerformative.setReceiver(string3);
        try {
            TransportFactory transportFactory = this.agentContext.getTransportFactory();
            OutTray outTray = transportFactory.getTransport(string3);
            InetAddress inetAddress = InetAddress.getLocalHost();
            String string4 = inetAddress.getHostAddress();
            InTray inTray = this.agentContext.getInTray();
            String string5 = inTray.getResponseAddress();
            Envelope envelope = fIPAPerformative.jasEnvelope(new FIPA_AID_Address(string3), string5);
            outTray.send(envelope);
        }
        catch (TransportUnsupportedException transportUnsupportedException) {
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unexpected exception in SimpleAPI.sendMessage() - attempting to recover");
            return false;
        }
        return true;
    }

    public void achieve(Fact[] factArray) {
        int n = 0;
        while (n < factArray.length) {
            Goal goal = new Goal(true, this.agentContext.getGenSym().newId("goal"), factArray[n], this.agentContext.whoami());
            this.agentContext.getEngine().achieve(goal);
            ++n;
        }
    }

    public void setHandler(String string, String string2, Object object, String string3) {
        MsgHandler msgHandler = this.agentContext.getMsgHandler();
        String[] stringArray = new String[]{"type", string.toLowerCase(), "sender", "\\A" + string2 + "\\Z"};
        MessageRuleImpl messageRuleImpl = new MessageRuleImpl(this.agentContext.newId("Rule"), stringArray, object, string3);
        String[] stringArray2 = new String[]{"type", string.toUpperCase(), "sender", "\\A" + string2 + "\\Z"};
        messageRuleImpl = new MessageRuleImpl(this.agentContext.newId("Rule"), stringArray2, object, string3);
        msgHandler.addRule(messageRuleImpl);
    }

    public void setHandler(String string, Object object, String string2) {
        MsgHandler msgHandler = this.agentContext.getMsgHandler();
        String[] stringArray = new String[]{"type", string.toLowerCase()};
        MessageRuleImpl messageRuleImpl = new MessageRuleImpl(this.agentContext.newId("Rule"), stringArray, object, string2);
        msgHandler.addRule(messageRuleImpl);
        String[] stringArray2 = new String[]{"type", string.toUpperCase()};
        messageRuleImpl = new MessageRuleImpl(this.agentContext.newId("Rule"), stringArray2, object, string2);
        msgHandler.addRule(messageRuleImpl);
    }

    public void setMessageQueue() {
        this.messQ = true;
        this.messageQueue = new Queue();
        this.setHandler(null, null, this, "addQueue");
    }

    public boolean isQueueOn() {
        return this.messQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Performative getNextMessage() {
        if (!this.messQ) {
            return null;
        }
        Queue queue = this.messageQueue;
        synchronized (queue) {
            if (this.messageQueue.isEmpty()) {
                return null;
            }
            Object object = this.messageQueue.dequeue();
            if (object == null) {
                return null;
            }
            try {
                return (Performative)object;
            }
            catch (ClassCastException classCastException) {
                System.out.println("Bad message in SimpleAPI.getNextMessage()");
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Performative waitNextMessage() {
        if (!this.messQ) {
            return null;
        }
        Queue queue = this.messageQueue;
        synchronized (queue) {
            Object object = this.messageQueue.dequeue();
            if (object == null) {
                return null;
            }
            try {
                return (Performative)object;
            }
            catch (ClassCastException classCastException) {
                System.out.println("Bad message in SimpleAPI.getNextMessage()");
                return null;
            }
        }
    }

    public void addQueue(Performative performative) {
        this.messageQueue.enqueue(performative);
    }

    public void addFact(Fact fact) {
        ResourceDb resourceDb = this.agentContext.getResourceDb();
        resourceDb.add(fact);
    }

    public SimpleAPI(AgentContext agentContext) {
        this.agentContext = agentContext;
    }
}

