/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import java.net.InetAddress;
import zeus.actors.AgentContext;
import zeus.actors.MailBox;
import zeus.actors.MsgHandler;
import zeus.concepts.Address;
import zeus.concepts.AddressBook;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;

public class FIPA_Services {
    protected AgentContext context = null;
    protected String name = null;
    protected String host = null;
    protected String type = null;

    public void setRegister() {
        MsgHandler msgHandler = this.context.getMsgHandler();
        String[] stringArray = new String[]{"receiver", this.type, "content", "\\A(.*)\\((\\s*)register(.*)\\Z"};
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "handleRegister"));
    }

    public void setDeregister() {
        MsgHandler msgHandler = this.context.getMsgHandler();
        String[] stringArray = new String[]{"receiver", this.type, "content", "\\A(.*)deregister(.*)\\Z"};
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "handleDeregister"));
    }

    public void setModify() {
        MsgHandler msgHandler = this.context.getMsgHandler();
        String[] stringArray = new String[]{"receiver", this.type, "content", "\\A(.*)modify(.*)\\Z"};
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "handleModify"));
    }

    public void setSearch() {
        MsgHandler msgHandler = this.context.getMsgHandler();
        String[] stringArray = new String[]{"receiver", this.type, "content", "\\A(.*)search(.*)\\Z"};
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "handleSearch"));
    }

    public void setName() {
        this.name = new String(this.type + "@");
        if (this.host == null) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                String string = inetAddress.getHostAddress();
                this.name = this.name + string;
            }
            catch (Exception exception) {
                System.out.println("network configuration problems in " + this.type);
                System.out.println("Exception thrown : ");
                exception.printStackTrace();
                System.out.println("setting name to " + this.type + "@127.0.0.1");
                this.name = this.name + "127.0.0.1";
            }
        } else {
            this.name = this.name + this.host;
        }
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    protected void registerAlias(String string) {
        MailBox mailBox = this.context.getMailBox();
        AddressBook addressBook = this.context.getAddressBook();
        int n = 0;
        while (n < this.context.nameservers().size()) {
            Address address = (Address)this.context.nameservers().elementAt(n);
            addressBook.add(address);
            Performative performative = new Performative("request");
            performative.setReceiver(address.getName());
            performative.setReplyWith(string);
            performative.setContent("register");
            performative.setSender(string);
            mailBox.sendMsg(performative);
            System.out.println("tried to send " + performative.toString());
            ++n;
        }
        System.out.println("finished attempted registration");
    }

    public void send(Performative performative) {
        MailBox mailBox = this.context.getMailBox();
        mailBox.sendMsg(performative);
    }
}

