/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import JADE_SL.abs.AbsAgentAction;
import JADE_SL.abs.AbsAggregate;
import JADE_SL.abs.AbsConcept;
import JADE_SL.abs.AbsContentElement;
import JADE_SL.abs.AbsPrimitive;
import JADE_SL.lang.sl.SLCodec;
import JADE_SL.lang.sl.SLOntology;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.InTray;
import zeus.actors.MsgHandler;
import zeus.actors.ResourceDb;
import zeus.actors.intrays.Zeus_ACC_Server;
import zeus.agents.FIPA_Services;
import zeus.concepts.AMS_Description;
import zeus.concepts.Address;
import zeus.concepts.AddressBook;
import zeus.concepts.AddressEvent;
import zeus.concepts.AddressListener;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.FIPA_AMS_Management_Content;
import zeus.concepts.FIPA_AP_Description;
import zeus.concepts.FIPA_MTP_Description;
import zeus.concepts.FIPA_Transport_Profile;
import zeus.concepts.Fact;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.OntologyDb;
import zeus.concepts.Performative;
import zeus.concepts.SL_Util;
import zeus.concepts.TransportConfig;
import zeus.concepts.ZeusAddress;
import zeus.concepts.ZeusParser;
import zeus.util.SystemProps;

public class FIPA_AMS_Services
extends FIPA_Services
implements AddressListener {
    private Hashtable ams_info = new Hashtable();
    private SLCodec codec = new SLCodec();

    public void exec(AgentContext agentContext) {
        this.type = new String("ams");
        this.context = agentContext;
        this.registerAlias(this.type);
        AddressBook addressBook = agentContext.getAddressBook();
        addressBook.addAddressListener(this);
        this.setName();
        this.setRegister();
        this.setDeregister();
        this.setModify();
        this.setSearch();
        this.setGet_description();
    }

    public void setGet_description() {
        MsgHandler msgHandler = this.context.getMsgHandler();
        String[] stringArray = new String[]{"receiver", this.type, "content", "\\A(.*)get-description(.*)\\Z"};
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "handleGet_description"));
    }

    private String stripLeadingTrailing(String string) {
        String string2 = string.substring(1, string.length() - 1);
        System.err.println("retVal is : " + string2);
        return string2;
    }

    public void handleGet_description(Performative performative) {
        try {
            String string = performative.getContent();
            Performative performative2 = new Performative("agree");
            performative2.setSender(performative.getReceiver());
            performative2.setReceiver(performative.getSender());
            FIPA_AMS_Management_Content fIPA_AMS_Management_Content = ZeusParser.FIPA_AMS_Management_Content(string);
            AbsContentElement absContentElement = this.codec.decode(SLOntology.getInstance(), string);
            absContentElement.dump();
            InetAddress inetAddress = InetAddress.getLocalHost();
            Performative performative3 = new Performative("inform");
            performative3.setSender("ams");
            performative3.setReceiver(performative.getSender());
            FIPA_AP_Description fIPA_AP_Description = new FIPA_AP_Description();
            fIPA_AP_Description.setDynamic(false);
            fIPA_AP_Description.setMobility(false);
            fIPA_AP_Description.setName(SystemProps.getProperty("HAP.address"));
            FIPA_Transport_Profile fIPA_Transport_Profile = new FIPA_Transport_Profile();
            FIPA_MTP_Description fIPA_MTP_Description = new FIPA_MTP_Description();
            fIPA_MTP_Description.setMTPName("fipa.mts.mtp.iiop.std");
            TransportConfig transportConfig = SystemProps.getTransport("FIPA_IIOP_2000");
            fIPA_MTP_Description.addAddress("iiop://" + inetAddress.getHostAddress() + ":" + transportConfig.getPort() + "/acc");
            fIPA_Transport_Profile.addMTPDescription(fIPA_MTP_Description);
            FIPA_MTP_Description fIPA_MTP_Description2 = new FIPA_MTP_Description();
            fIPA_MTP_Description2.setMTPName("fipa.mts.mtp.http.std");
            TransportConfig transportConfig2 = SystemProps.getTransport("FIPA_HTTP_2000");
            fIPA_MTP_Description2.addAddress("http://" + inetAddress.getHostAddress() + ":" + transportConfig2.getPort() + "/acc");
            fIPA_Transport_Profile.addMTPDescription(fIPA_MTP_Description2);
            fIPA_AP_Description.setTransportProfile(fIPA_Transport_Profile);
            performative3.setContent("(result " + this.stripLeadingTrailing(performative.getContent()) + "(set " + fIPA_AP_Description.toString() + "))");
            performative3.setLanguage("FIPA-SL0");
            performative3.setProtocol("FIPA-Request");
            performative3.setOntology("FIPA-Agent-Management");
            performative3.setConversationId(performative.getConversationId());
            performative3.setInReplyTo(performative.getReplyWith());
            performative3.send(this.context);
        }
        catch (Exception exception) {
            this.notUnderstood(performative, "failed");
        }
    }

    public void informDone(Performative performative) {
        String string = performative.getContent();
        Performative performative2 = new Performative("inform");
        performative2.setSender("ams");
        performative2.setReceiver(performative.getSender());
        performative2.setLanguage("FIPA-SL0");
        performative2.setProtocol("FIPA-Request");
        performative2.setOntology("FIPA-Agent-Management");
        performative2.setConversationId(performative.getConversationId());
        performative2.setInReplyTo(performative.getReplyWith());
        performative2.setContent("(done" + string + ")");
        this.send(performative2);
    }

    public void sendAgree(Performative performative) {
        Performative performative2 = new Performative("agree");
        performative2.setContent(performative.getContent().substring(0, performative.getContent().length() - 1) + "true)");
        performative2.setLanguage("FIPA-SL0");
        performative2.setProtocol("FIPA-Request");
        performative2.setOntology("FIPA-Agent-Management");
        performative2.setConversationId(performative.getConversationId());
        performative2.setInReplyTo(performative.getReplyWith());
        performative2.setReceiver(performative.getSender());
        performative2.setSender("ams");
        performative2.send(this.context);
    }

    public void handleRegister(Performative performative) {
        try {
            String string = performative.getContent();
            AbsContentElement absContentElement = this.codec.decode(SLOntology.getInstance(), string);
            absContentElement.dump();
            AbsAgentAction absAgentAction = (AbsAgentAction)absContentElement.getAbsObject("ACTION");
            this.sendAgree(performative);
            AbsConcept absConcept = (AbsConcept)absContentElement.getAbsObject("ACTOR");
            AbsAggregate absAggregate = (AbsAggregate)absConcept.getAbsObject("addresses");
            AbsPrimitive absPrimitive = (AbsPrimitive)absConcept.getAbsObject("name");
            String string2 = SL_Util.makeAddressString(absPrimitive, absAggregate);
            this.ams_info.put(string2, this.makeDescription(absAgentAction));
            this.informDone(performative);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public AMS_Description makeDescription(AbsConcept absConcept) {
        try {
            AbsConcept absConcept2 = (AbsConcept)absConcept.getAbsObject("_SL.UNNAMED0");
            AbsConcept absConcept3 = (AbsConcept)absConcept2.getAbsObject("name");
            AbsPrimitive absPrimitive = (AbsPrimitive)absConcept3.getAbsObject("name");
            AbsAggregate absAggregate = (AbsAggregate)absConcept3.getAbsObject("addresses");
            FIPA_AID_Address fIPA_AID_Address = new FIPA_AID_Address(SL_Util.makeAddressString(absPrimitive, absAggregate));
            AbsPrimitive absPrimitive2 = (AbsPrimitive)absConcept2.getAbsObject("ownership");
            AbsPrimitive absPrimitive3 = (AbsPrimitive)absConcept2.getAbsObject("state");
            AMS_Description aMS_Description = new AMS_Description();
            aMS_Description.setName(fIPA_AID_Address);
            if (absPrimitive2 != null) {
                aMS_Description.setOwnership(absPrimitive2.getString());
            }
            if (absPrimitive3 != null) {
                aMS_Description.setState(absPrimitive3.getString());
            }
            return aMS_Description;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void handleDeregister(Performative performative) {
        try {
            String string = performative.getContent();
            String string2 = new String(string);
            AbsContentElement absContentElement = this.codec.decode(SLOntology.getInstance(), string);
            AbsAgentAction absAgentAction = (AbsAgentAction)absContentElement.getAbsObject("ACTION");
            if (absAgentAction != null && absAgentAction.getTypeName().equalsIgnoreCase("deregister")) {
                this.sendAgree(performative);
            }
            OntologyDb ontologyDb = this.context.getOntologyDb();
            ResourceDb resourceDb = this.context.getResourceDb();
            Fact fact = ontologyDb.getFact(true, "agent");
            String string3 = new String();
            AbsConcept absConcept = (AbsConcept)absContentElement.getAbsObject("ACTOR");
            AbsAggregate absAggregate = (AbsAggregate)absConcept.getAbsObject("addresses");
            AbsPrimitive absPrimitive = (AbsPrimitive)absConcept.getAbsObject("name");
            String string4 = SL_Util.makeAddressString(absPrimitive, absAggregate);
            Enumeration enumeration = this.ams_info.keys();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                if (!string5.equals(string4)) continue;
                this.ams_info.remove(string5);
                this.informDone(performative);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void handleModify(Performative performative) {
        try {
            Object object;
            Enumeration enumeration = this.ams_info.elements();
            String string = performative.getContent();
            FIPA_AMS_Management_Content fIPA_AMS_Management_Content = ZeusParser.FIPA_AMS_Management_Content(string);
            AbsContentElement absContentElement = this.codec.decode(SLOntology.getInstance(), string);
            absContentElement.dump();
            AMS_Description aMS_Description = fIPA_AMS_Management_Content.getDescription();
            Performative performative2 = new Performative("agree");
            FIPA_AMS_Management_Content fIPA_AMS_Management_Content2 = ZeusParser.FIPA_AMS_Management_Content(string);
            fIPA_AMS_Management_Content2.setResult(true);
            performative2.setSender(performative.getReceiver());
            performative2.setReceiver(performative.getSender());
            performative2.setLanguage("FIPA-SL0");
            performative2.setProtocol("FIPA-Request");
            performative2.setOntology("FIPA-Agent-Management");
            performative2.setContent(fIPA_AMS_Management_Content2.toString());
            performative2.setConversationId(performative.getConversationId());
            performative2.setInReplyTo(performative.getReplyWith());
            performative2.send(this.context);
            Vector<Object> vector = new Vector<Object>();
            while (enumeration.hasMoreElements()) {
                this.debug("attempting a match");
                object = (AMS_Description)enumeration.nextElement();
                this.debug("calling match");
                boolean bl = aMS_Description.match((AMS_Description)object);
                this.debug("matched = " + String.valueOf(bl));
                if (!bl) continue;
                vector.addElement(object);
            }
            object = new String("(set ");
            Enumeration enumeration2 = vector.elements();
            boolean bl = false;
            while (enumeration2.hasMoreElements()) {
                bl = true;
                object = (String)object + ((AMS_Description)enumeration2.nextElement()).toString() + " ";
            }
            object = (String)object + " )";
            Performative performative3 = new Performative("inform");
            fIPA_AMS_Management_Content.setAction("search");
            if (bl) {
                fIPA_AMS_Management_Content.setResult((String)object);
            }
            performative3.setSender(performative.getReceiver());
            performative3.setReceiver(performative.getSender());
            performative3.setLanguage("FIPA-SL0");
            performative3.setProtocol("FIPA-Request");
            performative3.setOntology("FIPA-Agent-Management");
            performative3.setContent(fIPA_AMS_Management_Content.toString());
            performative3.setConversationId(performative.getConversationId());
            performative3.setInReplyTo(performative.getReplyWith());
            performative3.send(this.context);
        }
        catch (Exception exception) {
            this.notUnderstood(performative, "failed");
            exception.printStackTrace();
        }
        this.notUnderstood(performative, "(unsupported-act " + performative.getType() + ")");
    }

    public void handleSearch(Performative performative) {
        try {
            boolean bl;
            Object object;
            Enumeration enumeration = this.ams_info.elements();
            String string = performative.getContent();
            AbsContentElement absContentElement = this.codec.decode(SLOntology.getInstance(), string);
            absContentElement.dump();
            AbsAgentAction absAgentAction = (AbsAgentAction)absContentElement.getAbsObject("ACTION");
            AMS_Description aMS_Description = this.makeDescription(absAgentAction);
            Performative performative2 = new Performative("agree");
            this.sendAgree(performative);
            Vector<Object> vector = new Vector<Object>();
            while (enumeration.hasMoreElements()) {
                this.debug("attempting a match");
                object = (AMS_Description)enumeration.nextElement();
                this.debug("calling match");
                if (aMS_Description != null) {
                    bl = aMS_Description.match((AMS_Description)object);
                    this.debug("matched = " + String.valueOf(bl));
                    if (!bl) continue;
                    vector.addElement(object);
                    continue;
                }
                vector.addElement(object);
            }
            object = vector.elements();
            bl = false;
            String string2 = new String();
            while (object.hasMoreElements()) {
                bl = true;
                string2 = string2 + ((AMS_Description)object.nextElement()).toString() + " ";
            }
            Performative performative3 = new Performative("inform");
            performative3.setSender(performative.getReceiver());
            performative3.setReceiver(performative.getSender());
            performative3.setLanguage("FIPA-SL0");
            performative3.setProtocol("FIPA-Request");
            performative3.setOntology("FIPA-Agent-Management");
            String string3 = new String("((result " + string.substring(1, string.length() - 1) + " (set ");
            string3 = string3 + string2;
            string3 = string3 + ")))";
            performative3.setContent(string3);
            performative3.setConversationId(performative.getConversationId());
            performative3.setInReplyTo(performative.getReplyWith());
            performative3.send(this.context);
        }
        catch (Exception exception) {
            this.notUnderstood(performative, "failed");
            exception.printStackTrace();
        }
    }

    public void notUnderstood(Performative performative, String string) {
        Performative performative2 = new Performative("not-understood");
        performative2.setReceiver(performative.getSender());
        performative2.setSender(performative.getReceiver());
        performative2.setLanguage("FIPA-SL0");
        performative2.setProtocol("FIPA-Request");
        performative2.setOntology("FIPA-Agent-Management");
        String string2 = performative.getContent();
        FIPA_AMS_Management_Content fIPA_AMS_Management_Content = ZeusParser.FIPA_AMS_Management_Content(string2);
        fIPA_AMS_Management_Content.setResult(string);
        performative2.setContent(fIPA_AMS_Management_Content.toString());
    }

    void debug(String string) {
    }

    public static void main(String[] stringArray) {
        FIPA_AMS_Services fIPA_AMS_Services = new FIPA_AMS_Services();
        fIPA_AMS_Services.debug(fIPA_AMS_Services.stripLeadingTrailing(stringArray[0]));
    }

    public void newAddress(AddressEvent addressEvent) {
        Address address = addressEvent.getAddress();
        String string = new String();
        InTray inTray = this.context.getMailBox().getInTray();
        try {
            Zeus_ACC_Server zeus_ACC_Server = (Zeus_ACC_Server)inTray;
            if (!(address instanceof ZeusAddress)) {
                return;
            }
            String string2 = address.getName() + "@" + SystemProps.getProperty("HAP.address");
            string = new String("(agent-identifier :name ");
            string = string + string2.toString() + " :addresses (sequence ";
            string = string + zeus_ACC_Server.getResponseAddress();
            string = string + "))";
            FIPA_AID_Address fIPA_AID_Address = new FIPA_AID_Address(string);
            AMS_Description aMS_Description = new AMS_Description();
            aMS_Description.setName(fIPA_AID_Address);
            aMS_Description.setOwnership("ams@" + SystemProps.getProperty("HAP.address"));
            aMS_Description.setState("active");
            this.ams_info.put(string, aMS_Description);
        }
        catch (Exception exception) {}
    }

    public void deleteAddress(AddressEvent addressEvent) {
    }

    public void replaceAddress(AddressEvent addressEvent) {
    }
}

