/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.MsgHandler;
import zeus.agents.BasicAgent;
import zeus.agents.BasicAgentUI;
import zeus.agents.PersistentStore;
import zeus.agents.ZeusExternal;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.util.Assert;
import zeus.util.Core;
import zeus.util.MsgContentHandler;
import zeus.util.SystemProps;

public class DbProxy
extends BasicAgent {
    protected PersistentStore proxy = null;

    public DbProxy(String string, Vector vector, PersistentStore persistentStore) {
        super(SystemProps.getProperty("agent.names.dbProxy"), string, vector);
        Assert.notNull(persistentStore);
        this.proxy = persistentStore;
        String[][] stringArrayArray = new String[][]{{"type", "request", "reply-with", "(\\w)(.*)", "content", "\\Adb_create(\\s+)(.*)\\Z"}, {"type", "request", "reply-with", "(\\w)(.*)", "content", "\\Adb_delete(\\s+)(.*)\\Z"}, {"type", "request", "reply-with", "(\\w)(.*)", "content", "\\Adb_purge(\\s+)(.*)\\Z"}, {"type", "request", "reply-with", "(\\w)(.*)", "content", "\\Adb_open(\\s+)(.*)\\Z"}, {"type", "request", "reply-with", "(\\w)(.*)", "content", "\\Adb_save(\\s+)(.*)\\Z"}, {"type", "request", "reply-with", "(\\w)(.*)", "content", "\\Adb_close(\\s+)(\\w)(.*)\\Z"}, {"type", "query-ref", "reply-with", "(\\w)(.*)", "content", "\\Adb_next(\\s+)(.*)\\Z"}, {"type", "query-ref", "reply-with", "(\\w)(.*)", "content", "\\Adb_prior(\\s+)(.*)\\Z"}, {"type", "query-ref", "reply-with", "(\\w)(.*)", "content", "\\Adb_first(\\s+)(.*)\\Z"}, {"type", "query-ref", "reply-with", "(\\w)(.*)", "content", "\\Adb_last(\\s+)(.*)\\Z"}, {"type", "query-ref", "reply-with", "(\\w)(.*)", "content", "\\Adb_sessions(\\s+)(.*)\\Z"}, {"type", "query-ref", "reply-with", "(\\w)(.*)", "content", "\\Adb_list(\\s+)(.*)\\Z"}, {"type", "query-ref", "reply-with", "(\\w)(.*)", "content", "\\Adb_count(\\s+)(.*)\\Z"}};
        MsgHandler msgHandler = this.context.MsgHandler();
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[0], this, "db_create"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[1], this, "db_delete"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[2], this, "db_purge"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[3], this, "db_open"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[4], this, "db_save"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[5], this, "db_close"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[6], this, "db_next"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[7], this, "db_prior"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[8], this, "db_first"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[9], this, "db_last"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[10], this, "db_sessions"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[11], this, "db_list"));
        msgHandler.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArrayArray[12], this, "db_count"));
    }

    public void sendMsg(Performative performative) {
        this.context.MailBox().sendMsg(performative);
    }

    public void db_create(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.createSession(string, performative.getSender(), msgContentHandler.data(0), msgContentHandler.data(1), msgContentHandler.data(2));
    }

    public void db_delete(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.deleteSession(string, performative.getSender(), msgContentHandler.data(0), msgContentHandler.data(1));
    }

    public void db_purge(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.deleteSessionType(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_open(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.openSession(string, performative.getSender(), msgContentHandler.data(0), msgContentHandler.data(1), msgContentHandler.data(2));
    }

    public void db_save(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.saveRecord(string, performative.getSender(), msgContentHandler.data(0), msgContentHandler.rest(0));
    }

    public void db_close(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.closeSession(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_next(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.nextRecord(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_prior(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.priorRecord(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_first(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.beginSession(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_last(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.endSession(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_sessions(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.getAllSessions(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_list(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.getAgents(string, performative.getSender(), msgContentHandler.data(0));
    }

    public void db_count(Performative performative) {
        MsgContentHandler msgContentHandler = new MsgContentHandler(performative.getContent());
        String string = performative.getReplyWith();
        this.proxy.countRecords(string, performative.getSender(), msgContentHandler.data(0));
    }

    protected static void version() {
        System.err.println("DbProxy version: " + SystemProps.getProperty("version.id"));
        System.exit(0);
    }

    protected static void usage() {
        System.err.println("Usage: java zeus.agents.DbProxy <name> -p <db_classpath> -s <dns_file> [-gui ViewerProg] [-e ExternalProg] [-debug] [-v] [-h]");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Vector vector = null;
        String string = null;
        String string2 = null;
        DbProxy dbProxy = null;
        PersistentStore persistentStore = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (stringArray.length < 5) {
            DbProxy.usage();
        } else {
            int n = 1;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-s") && ++n < stringArray.length) {
                    string = stringArray[n];
                } else if (stringArray[n].equals("-p") && ++n < stringArray.length) {
                    string2 = stringArray[n];
                } else if (stringArray[n].equals("-e") && ++n < stringArray.length) {
                    string4 = stringArray[n];
                } else if (stringArray[n].equals("-gui") && ++n < stringArray.length) {
                    string3 = stringArray[n];
                } else if (stringArray[n].equals("-debug")) {
                    Core.debug = true;
                    Core.setDebuggerOutputFile(stringArray[0] + ".log");
                } else if (stringArray[n].equals("-h")) {
                    DbProxy.usage();
                } else if (stringArray[n].equals("-v")) {
                    DbProxy.version();
                } else if (stringArray[n].equals("-access") && ++n < stringArray.length) {
                    string5 = stringArray[n];
                } else {
                    DbProxy.usage();
                }
                ++n;
            }
        }
        if (string2 == null) {
            System.err.println("Database path must be specified with -p option");
            DbProxy.usage();
        }
        if (string == null) {
            System.err.println("Domain nameserver file must be specified with -s option");
            DbProxy.usage();
        }
        try {
            Object object;
            vector = ZeusParser.addressList(new FileInputStream(string));
            if (vector == null || vector.isEmpty()) {
                throw new IOException();
            }
            Class<?> clazz = Class.forName(string2);
            persistentStore = (PersistentStore)clazz.newInstance();
            dbProxy = new DbProxy(stringArray[0], vector, persistentStore);
            persistentStore.setProxy(dbProxy);
            if (string5 != null) {
                if (string5.equals("true")) {
                    persistentStore.setAccess(true);
                } else if (string5.equals("false")) {
                    persistentStore.setAccess(false);
                } else {
                    throw new Exception("Error specifying access level");
                }
            }
            AgentContext agentContext = dbProxy.getAgentContext();
            if (string3 != null) {
                clazz = Class.forName(string3);
                object = (BasicAgentUI)clazz.newInstance();
                agentContext.set((BasicAgentUI)object);
                object.set(agentContext);
            }
            if (string4 != null) {
                clazz = Class.forName(string4);
                object = (ZeusExternal)clazz.newInstance();
                agentContext.set((ZeusExternal)object);
                object.exec(dbProxy.getAgentContext());
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(0);
        }
    }
}

