/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import java.util.Enumeration;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.MsgHandler;
import zeus.actors.ZeusAgentContext;
import zeus.actors.event.AgentEvent;
import zeus.actors.event.AgentMonitor;
import zeus.actors.event.MessageMonitor;
import zeus.actors.intrays.Zeus_ACC_MailBox;
import zeus.agents.BasicAgent;
import zeus.util.Assert;
import zeus.util.Clock;
import zeus.util.HSet;

public class ACCAgent
extends BasicAgent {
    private HSet[] eventMonitor = new HSet[4];
    public static final int CREATE = 0;
    public static final int DEATH = 1;
    public static final int SUSPEND = 2;
    public static final int RESUME = 3;
    protected AgentContext context = null;

    public ACCAgent(String string, String string2, Vector vector) {
        this(string, string2, vector, null);
    }

    public ACCAgent(String string, String string2, Vector vector, Clock clock) {
        this.context = new ZeusAgentContext(string2, string);
        this.context.set(this);
        this.context.setNameservers(vector);
        new MsgHandler(this.context);
        Zeus_ACC_MailBox zeus_ACC_MailBox = new Zeus_ACC_MailBox(this.context);
        this.context.set(zeus_ACC_MailBox);
        if (clock != null) {
            this.context.set(clock);
        }
        int n = 0;
        while (n < this.eventMonitor.length) {
            this.eventMonitor[n] = new HSet();
            ++n;
        }
        long l = System.currentTimeMillis();
        while (this.context.Clock() == null) {
            long l2 = System.currentTimeMillis();
            if (l2 - l > (long)(this.context.getRegistrationTimeout() * 60000.0)) {
                System.err.println("Cannot initialize " + string2 + " -- exiting");
                this.notifyMonitors(1);
                System.exit(0);
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.notifyMonitors(0);
    }

    public AgentContext getAgentContext() {
        return this.context;
    }

    public void addMessageMonitor(MessageMonitor messageMonitor, long l) {
        this.context.MailBox().addMessageMonitor(messageMonitor, l);
    }

    public void removeMessageMonitor(MessageMonitor messageMonitor, long l) {
        this.context.MailBox().removeMessageMonitor(messageMonitor, l);
    }

    public void addAgentMonitor(AgentMonitor agentMonitor, long l) {
        Assert.notNull(agentMonitor);
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].add(agentMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].add(agentMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].add(agentMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].add(agentMonitor);
        }
    }

    public void removeAgentMonitor(AgentMonitor agentMonitor, long l) {
        Assert.notNull(agentMonitor);
        if ((l & 1L) != 0L) {
            this.eventMonitor[0].remove(agentMonitor);
        }
        if ((l & 2L) != 0L) {
            this.eventMonitor[1].remove(agentMonitor);
        }
        if ((l & 4L) != 0L) {
            this.eventMonitor[2].remove(agentMonitor);
        }
        if ((l & 8L) != 0L) {
            this.eventMonitor[3].remove(agentMonitor);
        }
    }

    public void notifyMonitors(int n) {
        if (this.eventMonitor[n].isEmpty()) {
            return;
        }
        Enumeration enumeration = this.eventMonitor[n].elements();
        switch (n) {
            case 0: {
                AgentEvent agentEvent = new AgentEvent(this, this, 1L);
                while (enumeration.hasMoreElements()) {
                    AgentMonitor agentMonitor = (AgentMonitor)enumeration.nextElement();
                    agentMonitor.agentCreatedEvent(agentEvent);
                }
                break;
            }
            case 1: {
                AgentEvent agentEvent = new AgentEvent(this, this, 2L);
                while (enumeration.hasMoreElements()) {
                    AgentMonitor agentMonitor = (AgentMonitor)enumeration.nextElement();
                    agentMonitor.agentDeathEvent(agentEvent);
                }
                break;
            }
            case 2: {
                AgentEvent agentEvent = new AgentEvent(this, this, 4L);
                while (enumeration.hasMoreElements()) {
                    AgentMonitor agentMonitor = (AgentMonitor)enumeration.nextElement();
                    agentMonitor.agentSuspendedEvent(agentEvent);
                }
                break;
            }
            case 3: {
                AgentEvent agentEvent = new AgentEvent(this, this, 8L);
                while (enumeration.hasMoreElements()) {
                    AgentMonitor agentMonitor = (AgentMonitor)enumeration.nextElement();
                    agentMonitor.agentResumedEvent(agentEvent);
                }
                break;
            }
        }
    }
}

