/*
 * Decompiled with CFR 0.152.
 */
package zeus.agents;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import zeus.actors.AgentContext;
import zeus.actors.ExecutionMonitor;
import zeus.actors.ExternalDb;
import zeus.actors.MsgHandler;
import zeus.actors.OrganisationDb;
import zeus.actors.Planner;
import zeus.actors.ProtocolDb;
import zeus.actors.ResourceDb;
import zeus.actors.TaskDb;
import zeus.actors.intrays.Zeus_ACC_MailBox;
import zeus.actors.intrays.Zeus_ACC_Server;
import zeus.actors.rtn.Engine;
import zeus.agents.ACCAgent;
import zeus.agents.BasicAgent;
import zeus.agents.BasicAgentUI;
import zeus.agents.FIPA_AMS_Services;
import zeus.agents.FIPA_DF_Services;
import zeus.agents.ZeusAgentUI;
import zeus.agents.ZeusExternal;
import zeus.concepts.Bindings;
import zeus.concepts.FIPA_AID_Address;
import zeus.concepts.MessageRuleImpl;
import zeus.concepts.OntologyDb;
import zeus.concepts.Performative;
import zeus.concepts.ZeusParser;
import zeus.concepts.xmlobject.acc.Contact;
import zeus.concepts.xmlobject.acc.Contacts;
import zeus.util.Core;
import zeus.util.StringHashtable;
import zeus.util.SystemProps;

public class ACC
implements ZeusExternal {
    String fipaNames = null;
    AgentContext context = null;
    MsgHandler msg = null;
    public File contactsDb = null;
    public Contacts contactsRoot = new Contacts();

    protected static void version() {
        System.err.println("ZeusAgent - ACC version: 1.2");
    }

    protected static void usage() {
        System.err.println("Usage: java ACC -s <dns_file> [-gui ViewerProg] ] [-debug] [-fipaNames fipNameFileName] [-transports transportConfigFile");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = "ACC";
        Vector vector = new Vector(10);
        Object var4_3 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Object var8_7 = null;
        Vector vector2 = null;
        Object var11_9 = null;
        Object var12_10 = null;
        String string5 = "contacts.xml";
        String string6 = null;
        String string7 = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-s") && ++n < stringArray.length) {
                string2 = stringArray[n];
            }
            if (stringArray[n].equals("-gui") && ++n < stringArray.length) {
                string4 = stringArray[n];
            }
            if (stringArray[n].equals("-fipaNames") && ++n < stringArray.length) {
                string5 = stringArray[n];
            }
            if (stringArray[n].equals("-transports") && ++n < stringArray.length) {
                string6 = stringArray[n];
            }
            if (stringArray[n].equals("-o") && ++n < stringArray.length) {
                string7 = stringArray[n];
            } else if (stringArray[n].equals("-debug")) {
                Core.debug = true;
                Core.setDebuggerOutputFile("ACC.log");
            }
            ++n;
        }
        Bindings bindings = new Bindings(string);
        if (string2 == null) {
            System.err.println("Domain nameserver file must be specified with -s option");
            ACC.usage();
        }
        try {
            Object object;
            Class<?> clazz;
            vector2 = ZeusParser.addressList(new FileInputStream(string2));
            System.out.println("namerservers = " + vector2);
            if (vector2 == null || vector2.isEmpty()) {
                throw new IOException();
            }
            ACC aCC = new ACC();
            if (string6 != null) {
                aCC.initialiseTransports(string6);
            }
            ACCAgent aCCAgent = new ACCAgent(string, string, vector2);
            AgentContext agentContext = ((BasicAgent)aCCAgent).getAgentContext();
            OntologyDb ontologyDb = new OntologyDb(agentContext.GenSym());
            agentContext.set(ontologyDb);
            int n2 = 0;
            n2 = string7 == null ? ontologyDb.openFile(new File("ACC.ont")) : ontologyDb.openFile(new File(string7));
            new OrganisationDb(agentContext);
            new ResourceDb(agentContext);
            new Engine(agentContext);
            new TaskDb(agentContext);
            new Planner(agentContext, 4, 40);
            new ExecutionMonitor(agentContext);
            new ProtocolDb(agentContext);
            if (string3 != null) {
                clazz = Class.forName(string3);
                object = (ExternalDb)clazz.newInstance();
                agentContext.set((ExternalDb)object);
                object.set(agentContext);
            }
            if (string4 != null) {
                clazz = Class.forName(string4);
                object = (ZeusAgentUI)clazz.newInstance();
                agentContext.set((BasicAgentUI)object);
                object.set(agentContext);
            }
            agentContext.set(aCC);
            aCC.exec(agentContext);
            if (string5 != null) {
                System.out.println("attempting to register names");
                aCC.fipaNames = string5;
                aCC.loadFIPAAliases();
            }
            FIPA_DF_Services fIPA_DF_Services = new FIPA_DF_Services();
            System.out.println("calling fdf");
            fIPA_DF_Services.exec(agentContext);
            FIPA_AMS_Services fIPA_AMS_Services = new FIPA_AMS_Services();
            System.out.println("calling fams");
            fIPA_AMS_Services.exec(agentContext);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void exec(AgentContext agentContext) {
        this.context = agentContext;
        this.msg = agentContext.MsgHandler();
        this.setMessageRules();
    }

    public void setMessageRules() {
        String[] stringArray = new String[]{"type", "request", "content", "\\A(action acc(\\s*)(forward (\\s*)(.*)))\\Z"};
        this.msg.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray, this, "forward_message"));
        String[] stringArray2 = new String[]{"type", "inform", "content", "\\A(<contact\\s)(.*)(/>)\\Z"};
        this.msg.addRule(new MessageRuleImpl(this.context.newId("Rule"), stringArray2, this, "add_new_contact"));
    }

    public void forward_message(Performative performative) {
        System.out.println(performative.toString());
    }

    protected synchronized void loadFIPAAliases() {
        List list = null;
        try {
            this.contactsDb = new File(this.fipaNames);
            this.buildTree();
            list = this.contactsRoot.getList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (list != null) {
            Zeus_ACC_MailBox zeus_ACC_MailBox = (Zeus_ACC_MailBox)this.context.getMailBox();
            Zeus_ACC_Server zeus_ACC_Server = zeus_ACC_MailBox.getZeus_ACC_Server();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Contact contact = (Contact)listIterator.next();
                System.out.println(contact.toString());
                String string = contact.getZEUSName();
                FIPA_AID_Address fIPA_AID_Address = new FIPA_AID_Address(contact.getFIPAAddress());
                System.out.println("ZEUS Name = " + string + ",  FIPA Address = " + fIPA_AID_Address.toString());
                zeus_ACC_Server.setFIPAAlias(string, fIPA_AID_Address);
            }
        } else {
            System.out.println("Failed to load FIPA aliases into address book");
        }
    }

    protected synchronized void saveFIPAAliases() {
        try {
            this.contactsRoot.validate();
            this.marshalTree();
            System.out.println("FIPA Aliases file saved successfully!");
        }
        catch (Exception exception) {
            System.out.println("Error saving FIPA Aliases to file");
            exception.printStackTrace();
        }
    }

    public void add_new_contact(Performative performative) {
        Performative performative2 = new Performative();
        performative2.setInReplyTo(performative.getReplyWith());
        performative2.setReceiver(performative.getSender());
        Contact contact = new Contact();
        String string = performative.getContent();
        System.out.println("Msg content: " + string);
        try {
            contact = Contact.unmarshal(new ByteArrayInputStream(string.getBytes()));
            List list = this.contactsRoot.getList();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                Contact contact2 = (Contact)listIterator.next();
                if (!contact2.getZEUSName().equalsIgnoreCase(contact.getZEUSName())) continue;
                listIterator.remove();
            }
            list.add(contact);
            this.saveFIPAAliases();
            this.loadFIPAAliases();
            performative2.setType("inform");
            performative2.setContent("((done (" + string + ")))");
        }
        catch (Exception exception) {
            System.out.println("Error unmarshalling XML msg content to Java object");
            exception.printStackTrace();
            performative2.setType("failure");
            performative2.setContent(string);
        }
        performative2.send(this.context);
    }

    protected void initialiseTransports(String string) {
        Object object;
        Object object2;
        String string2 = new String();
        try {
            object2 = new FileInputStream(string);
            object = new DataInputStream((InputStream)object2);
            while (((FilterInputStream)object).available() > 0) {
                System.out.println("reading");
                String string3 = ((DataInputStream)object).readLine();
                string2 = string2 + "\n" + string3;
                System.out.println(string3);
            }
            System.out.println(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = ZeusParser.Transports(string2);
        object = ((Hashtable)object2).keys();
        while (object.hasMoreElements()) {
            System.out.println("key  = " + (String)object.nextElement());
        }
        SystemProps.setTransports((StringHashtable)object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void buildTree() throws Exception {
        FileInputStream fileInputStream = new FileInputStream(this.contactsDb);
        try {
            this.contactsRoot = Contacts.unmarshal(fileInputStream);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void marshalTree() throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(this.contactsDb);
        try {
            this.contactsRoot.marshal(fileOutputStream);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
    }
}

